/* filename: CHECK4CH.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifdef NET
#include <index.h>

BOOL IndexesChanged(void)
{
  int i;

  if (Semaphore[Selected]) {
    if (Semaphore[Selected]->LastChange != Semaphore[Selected]->Data.Changecount)
    {
#ifdef NETLOG
      WriteLog("Detected index changed since last read");
#endif
      for (i = 0; i < MaxOrder; ++i)
        if (Ind[Selected][i])
          ReadAnchorNode(Selected,i);
      // prevent unnecessary reading of the anchor
      Semaphore[Selected]->LastChange = Semaphore[Selected]->Data.Changecount;
      ResetCache();
      return TRUE;
    }
  }
  return FALSE;
}

BOOL CheckForChange(void)
{
  if (IndexesChanged()) { // sync up primary index index
    RawGo(RecNo()); // same as skip(0)
    SoftSyncIndex();
    return TRUE; // has been changed
  }
  return FALSE;  // has not been changed
}
#endif
