/* filename: APPNDIDX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifndef NDX_TYPE
#include <stdio.h>
#include <string.h>
#include <io.h>

extern long  AvailableNode;

static void  AddNode(const char * k, int order);
static void  FindLeaf(const char * key, int order);

static int   AddNodeLeft = 0;
static int   LeafEOF=0, LeafBOF=0;

void AppendIndex(const char * k, int order)
{       // adds an entry onto the tree..does file checking first
  PIndexType p;
  PNode      pi, cnptr;// current cache node pointer
  int        coffset;  // cache offset

  p = Ind[Selected][order];
  pi = p->Index;

#ifdef NETLOG
  WriteLog("Appending new record to index");
#endif

  // if this is the first record in the database, we want to write
  // the single node over the now meaningless placekeeping node:
  if (RecCount() == 1L) {   // to add the very first node, define all the vars first
    p->BOFFlag = p->EOFFlag = FALSE;
    p->Anchor.FirstRec = p->Anchor.LastRec = 1;
    p->Anchor.TotalLiveNodes = 1;// this is a special case of 1 record
    p->Modified = TRUE;
    WriteAnchorNode(Selected,order);
    pi->DBFRecNo = pi->Entry = 1;
    pi->GrtrNode = pi->LessNode = pi->PreviousNode = 0;
    strcpy(pi->Key, k);

    // now write this data out to the first node
    if (!SeekAndWrite(Selected,order,pi->Entry,pi))
      return;
    // adding the first record to an index that is cached, needs to update
    // the cache too! SeekAndWrite does not do that, so this does.
    if (!order && Cache[Selected] && (pi->Entry <= (long) CCacheSize[Selected]))
    { // put the new node in the cache
      coffset = CNSize[Selected] * ((int)pi->Entry-1);
      cnptr = (PNode) ((char *)Cache[Selected]+coffset);
      memcpy( cnptr, pi, CNSize[Selected] );
      Ind[Selected][0]->Index = cnptr;
    }

    return; // leave the routine..we are done, just one record in database
  }
  // otherwise..and this is most of the time..there is an already built tree
  FindLeaf(k,order);
  AddNode(k, order);
  // check to see if this key is a new EOF
  if (LeafEOF && !AddNodeLeft) {
    p->Anchor.LastRec = RecNo();
    p->Modified = TRUE;
    WriteAnchorNode(Selected,order);
  }
  if (LeafBOF && AddNodeLeft) {
    p->Anchor.FirstRec = RecNo();
    p->Modified = TRUE;
    WriteAnchorNode(Selected,order);
  }
  // however, appending a record means that we cannot be at eof!
  p->EOFFlag = FALSE;
}

static void AddNode(const char * k, int order)
{
  int          handle, coffset; // cache offset
  PNode        pi, cnptr; // current cache node pointer
  long         saveFilePos;
  long         NewNode;
  long         curpos, flength;
  PIndexType   p;

#ifdef NETLOG
  WriteLog("Appending node");
#endif

  p = Ind[Selected][order];
  pi = p->Index;
  if(AvailableNode) {
    NewNode = AvailableNode;
    AvailableNode = 0;
  }
  else {
    // get information about the file size
    handle = p->Ndx;
    curpos = tell(handle);
    lseek(handle, 0L, SEEK_END);
    flength = tell(handle);
    lseek(handle, curpos, SEEK_SET);
    NewNode = flength/p->NodeSize; // filesize
  }
  if (strcmp(k,pi->Key) < 0) {
    pi->LessNode = NewNode;
    AddNodeLeft = TRUE;
  }
  else {
    pi->GrtrNode = NewNode;
    AddNodeLeft = FALSE;
  }
  saveFilePos = pi->Entry;
  if(!SeekAndWrite(Selected,order,pi->Entry,pi))
    return;
  pi = p->Index = &p->NodeBuffer;
  strcpy(pi->Key,k);
  pi->Entry = NewNode;
  pi->DBFRecNo = RecNo();
  pi->GrtrNode = pi->LessNode = 0L;
  pi->PreviousNode = saveFilePos;
  if(!SeekAndWrite(Selected,order,pi->Entry,pi))
    return;
  // put the new node in the cache
  if (!order && Cache[Selected] && (pi->Entry <= (long) CCacheSize[Selected]))
  {
    coffset = CNSize[Selected] * ((int)pi->Entry - 1);
    cnptr = (PNode) ((char *)Cache[Selected]+coffset);
    memcpy( cnptr, pi, CNSize[Selected] );
    Ind[Selected][0]->Index = cnptr;
  }
}

static void FindLeaf(const char * key, int order)
// finds correct leaf to add a new node to
//   --used in indexing and appending the index
{
  PIndexType p;
  PNode      pi;

  GetNode(1,order);
  p = Ind[Selected][order];
  pi = p->Index;

LOOP:
  if (strcmp(key,pi->Key) >= 0) {
    if(pi->GrtrNode > 0L ) {
      GetNode(pi->GrtrNode, order );
      pi = p->Index;
      goto LOOP;
    }
  }
  else
    if (pi->LessNode > 0L) {
      GetNode(pi->LessNode,order);
      pi = p->Index;
      goto LOOP;
    }
  LeafEOF = (pi->DBFRecNo == p->Anchor.LastRec);
  LeafBOF = (pi->DBFRecNo == p->Anchor.FirstRec);
}
#endif // NDX_TYPE
  
