/* filename: SVRSTCNF.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <direct.h>
#include <dos.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <edit.h>

static char _tzfar SaveEditPath[80] = {0};

static void SetConfig(unsigned char Which, Configuration *cfg)
{
  if (!Which) {
    EditBox.blox = cfg->c1;
    EditBox.bloy = cfg->r1;
    EditBox.brux = cfg->c2;
    EditBox.bruy = cfg->r2;
  }
  else {
    MemoBox.blox = cfg->c1;
    MemoBox.bloy = cfg->r1;
    MemoBox.brux = cfg->c2;
    MemoBox.bruy = cfg->r2;
  }
  strcpy(helppath, cfg->HelpFile);
  strcpy(actdir, cfg->DefaultDir);
  strcpy(DefaultExt,cfg->DefaultExt);
  strcpy(LPTNumber,cfg->LPTNumber);
  Lmarg = cfg->LeftMargin;
  TMarg = cfg->TopMargin;
  lpp = cfg->LinesPerPage;
  Wrap = cfg->WrapEnabled;
  WordWrapWidth = cfg->WrapWidth;
}

void RestoreEditConfig(char *editfilename)
{
  FILE *f;
  Configuration cfg;
  char buf[STRSIZ];

  if(FileExists(editfilename)) {
    f = fopen(editfilename, "rb");
    if (errno == 2) {
      fclose(f);
      return;
    }
  }
  else {
    _fullpath(SaveEditPath, editfilename, 80);
    return;  // if it's not there it's ok
  }
  DBFError = errno;
  if (DBFError > 0) {
    sprintf(buf," [RestoreEditConfig(%s)]",editfilename);
    SetError(DBFError,1,buf);
  }
  else {
    fread(&cfg,1,sizeof(cfg),f);
    SetConfig(0,&cfg);
    fread(&cfg,1,sizeof(cfg),f);
    DBFError = errno;
    if (DBFError > 0) {
      fclose(f);
      sprintf(buf," [RestoreEditConfig(%s)]",editfilename);
      SetError(DBFError,1,buf);
    }
    else {
      SetConfig(1,&cfg);
      fclose(f);
      _fullpath(SaveEditPath, editfilename, 80);
    }
  }
}

static void GetConfig(unsigned char which, Configuration *cfg)
{
  char s[35]  = "TOPAZ 4.5 EDIT/MEMO CONFIG FILE\r\n\x1A";

  if (!which) {
    cfg->c1 = EditBox.blox;
    cfg->r1 = EditBox.bloy;
    cfg->c2 = EditBox.brux;
    cfg->r2 = EditBox.bruy;
  }
  else {
    cfg->c1 = MemoBox.blox;
    cfg->r1 = MemoBox.bloy;
    cfg->c2 = MemoBox.brux;
    cfg->r2 = MemoBox.bruy;
  }
  strcpy(cfg->HeaderConf,s);
  cfg->Version[0] = 3;
  cfg->Version[1] = 0;
  strcpy(cfg->HelpFile, helppath);
  strcpy(cfg->DefaultDir, actdir);
  strcpy(cfg->DefaultExt,DefaultExt);
  strcpy(cfg->LPTNumber,LPTNumber);
  cfg->LeftMargin = Lmarg;
  cfg->TopMargin = TMarg;
  cfg->LinesPerPage = lpp;
  cfg->WrapEnabled = Wrap;
  cfg->WrapWidth = WordWrapWidth;
}

void SaveEditConfig(char *editfilename)
{
  FILE *f;
  Configuration cfg;
  char buf[STRSIZ];

  errno = 0;
  if((f = fopen(SaveEditPath,"wb+")) != NULL)
    errno = 0;
  DBFError = errno;
  if (DBFError > 0) {
    sprintf(buf," [SaveEditConfig(%s)]",editfilename);
    SetError(DBFError,1,buf);
  }
  else {
    GetConfig(0,&cfg);
    fwrite(&cfg,1,sizeof(cfg),f);
    GetConfig(1,&cfg);
    fwrite(&cfg,1,sizeof(cfg),f);
    DBFError = errno;
    fclose(f);
    if (DBFError > 0) {
      sprintf(buf," [SaveEditConfig(%s)]",editfilename);
      SetError(DBFError,1,buf);
    }
  }
}
