/* filename: SET.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <direct.h>
#include <errno.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
  
#include <dialog.h>
#include <sayget.h>
#include <utils.h>
#include <edit.h>
  
void SetChangedFlags(void)
{
  EditChanged = AutoSaveChanged = TRUE;
  NeverChanged = FALSE;
}

void SetDirectory(void)
{
  char SaveDir[STRSIZ];
  char tmp[STRSIZ];
  
  errno = 0;
  strcpy(SaveDir,actdir);
  if ((strlen(actdir) > 3) && (actdir[strlen(actdir)-1] == '\\'))
    actdir[strlen(actdir)-1] = 0;
  WindowEdit(Default_Directory_Message,actdir);
  if (!*actdir|| !strcmp(actdir,SaveDir))
    return;
  if ((strlen(actdir) > 3) && (actdir[strlen(actdir)-1] == '\\'))
    actdir[strlen(actdir)-1] = 0;
  else
    if (strlen(actdir) < 3)
      strcat(actdir,"\\");
  chdir(actdir);
  if (errno) {
    sprintf(tmp,"%s:;%s CENTERTEXT",Invalid_Directory,actdir);
    EditDialogBox(tmp);
    strcpy(actdir, SaveDir);
  }
  else
    if ((actdir[strlen(actdir)-1] != '\\'))
      strcat(actdir,"\\");
}
  
void SetExtension(void)
{
  char SaveExt[STRSIZ];
  int i;
  char InvalidChars[9];
  
  strcpy(InvalidChars,".,;:><|*");
  strcpy(SaveExt,DefaultExt);
  WindowEdit(Default_Extension,DefaultExt);
  if (!*DefaultExt|| !strcmp(DefaultExt,SaveExt))
    return;
  i = 1;
  while (((unsigned)i <= strlen(InvalidChars)) && (strchr(DefaultExt,InvalidChars[i-1]) == NULL))
    ++i;
  if ((unsigned)i <= strlen(InvalidChars)) {
    EditDialogBox(Invalid_File_extension);
    strcpy(DefaultExt,SaveExt);
  }
}
  
extern unsigned char MemoX1, MemoX2;
  
void SetWrapWidth(void)
{
  char SWidth[4];
  
  do {
    if(MemoIn)
      WordWrapWidth = MemoX2 - MemoX1;
    strcpy(SWidth,SInteger(WordWrapWidth,0));
    WindowEdit(Word_Wrap_Width,SWidth);
    WordWrapWidth = IntegerVal(SWidth);
    if (!WordWrapWidth)
      WordWrapWidth = WindowWidth;
    if(MemoIn) {
      MemoX1 = 0;
      MemoX2 = WordWrapWidth;
    }
  }  while (!((WordWrapWidth > 1) && (WordWrapWidth <= 128)));
  if (Wrap)
    EdReformat(WordWrapWidth);
}
  
void PadTo(char *s, int width)
{
  if ((width > 0) && (width < STRSIZ))
    while (strlen(s) < (size_t)width)
      strcat(s, " ");
}
  
void MakeEdiDynString(char *s, int LineNumber)
{
  char * ptr;
  
  if ( ((unsigned)LineNumber <= MaxLines) && (coreleft() > ReservedMemory) ) {
    if((Linebuffer[LineNumber-1] = malloc(strlen(s)+1)) == NULL) {
      SetError(217, 1, " [EditText/PasteString]");
      return;
    }
    ptr = Linebuffer[LineNumber-1];
    strcpy(ptr ,s);
  }
}
  
void ForgetEdiDynString(int LineNumber)
{
  if ((unsigned)LineNumber <= MaxLines)
    FreePtrClear((void*) &Linebuffer[LineNumber-1]);
}
