/* filename: HANDLFUN.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <dos.h>
#include <stdio.h>

#include <string.h>
#include <dialog.h>
#include <edit.h>

void BeginFile(void);
void ControlChars(void);
void CopyBlock(int);
void DeleteBlock(unsigned char);
void DeleteWord(void);
void EdCharacter(void);
void EdIns(void);
void EdReplace(unsigned char, int);
void EdZap(int);
void EndFile(void);
void FuncPgDn(void);
void FuncPgUp(void);
void GetFileName(int);
char *GetFilenameToSave(PathStr SuggestedName, FilePromptMode PromptMode);
void GetPrinterParameters(void);
void GoToLine(void);
void Helpf(void);
void MarkBlockBegin(void);
void MarkBlockEnd(void);
void NextWordEdit(void);
void PrevWord(void);
void PrintOut(int);
void ResizeWindow(void);
void SetDirectory(void);
void SetExtension(void);
void SetWrapWidth(void);
void Tab(unsigned char);

int EditInsertmode = TRUE;

extern unsigned char LastRep, fselect;
extern int editquit;

void HandleFunc(void)
{
  char tmp[STRSIZ], SavedFN[STRSIZ], ch;
  int SaveInsertmode;

  switch (fselect) {
    case _backsp:
      if (!editnoedit)
        EdBackSpace();
      break;
    case _blockoff:
      if (!editnoedit && EditInsertmode) {
        ClearBlockMarkers();
        DisplayEditorStatus();
        DrawScreen();
      }
      break;
    case _blockbeg: MarkBlockBegin(); break;
    case _blockend: MarkBlockEnd(); break;
    case _readblock:
      if (!editnoedit) {
        SaveInsertmode = EditInsertmode;
        EditInsertmode = TRUE;
        GetFileName(TRUE);
        EditInsertmode = SaveInsertmode;
        DisplayEditorStatus();
      }
      break;
    case _writeblock:
      if (!editnoedit && BlockMarked)
        if (!BwriteOK(SaveBlock)) {
          sprintf(tmp,"%s%s", Error_writing,current_file);
          EditDialogBox(tmp);
          DisplayEditorStatus();
        }
      break;
    case _copyblock:
      if (BlockMarked && !editnoedit && EditInsertmode)
        CopyBlock(FALSE);
      break;
    case _moveblock:
      if (BlockMarked && !editnoedit && EditInsertmode)
        CopyBlock(TRUE);
      break;
    case _delblock:
      if (!editnoedit && BlockMarked)
        DeleteBlock(1);
      break;
    case _printblock:
      if (BlockMarked)
        PrintOut(TRUE);
      else
        PrintOut(FALSE);
      break;
    case _findblockb:
      if (BlockMarked) {
        Home();
        CurrentLine = BlockStartLine;
        while (EditColumn < (int)BlockStartColumn)
          CursorRight(FALSE);
        RefreshStatus();
        DrawScreen();
      }
      break;
    case _findblocke:
      if (BlockMarked) {
        Home();
        CurrentLine = BlockEndLine;
        while (EditColumn < (int)BlockEndColumn)
          CursorRight(FALSE);
        DisplayEditorStatus();
        DrawScreen();
      }
      break;
    case _quicksave:
      if (!MemoIn)
        if (!BwriteOK(SaveWithNoPrompt)) {
          sprintf(tmp,"%s%s", Error_writing,current_file);
          EditDialogBox(tmp);
          DisplayEditorStatus();
        }
      break;
    case _exitsave:
      if (MemoIn) {
        if (Txtin && EditChanged) {
          if (!BwriteOK(SaveWithNoPrompt)) {
            sprintf(tmp, "%s%s",Error_writing,current_file);
            EditDialogBox(tmp);
          }
          DisplayEditorStatus();
        }
      }
      EditChanged = FALSE;
      editquit = TRUE;
      break;
    case _quitnosave:
      if (EditChanged) {
        if (!MemoIn)
          sprintf(tmp,"%s%s%s",Abandon_changes,Trim(RawFilename),Question);
        else
          sprintf(tmp,"%s%s", Abandon_changes,memo_question);
        ch = DialogBox(tmp,yes_no_buttons);
        DisplayEditorStatus();
      }
      else
        ch = yes_no_chars[0];
      if (ch == yes_no_chars[0])
        editquit = TRUE;
      DisplayEditorStatus();
      DrawScreen();
      break;
    case _ctrchars: ControlChars(); break;
    case _searchcont: EdReplace(LastRep,TRUE); DisplayEditorStatus(); break;
    case _search:
      EdReplace(1,FALSE);
      LastRep = 1;
      DisplayEditorStatus();
      break;
    case _replace:
      if (!editnoedit) {
        EdReplace(2,FALSE);
        LastRep = 2;
        DisplayEditorStatus();
        DrawScreen();
      }
      break;
    case _delword: DeleteWord(); break;
    case _delline:
      if (!editnoedit) {
        DeleteLine();
        Home();
        DisplayEditorStatus();
        DrawScreen();
      }
      break;
    case _tab:
      if (!editnoedit)
        Tab(0);
      break;
    case _enter:
      if (!editnoedit)
        Enter();
      break;
    case _insline:
      if (!editnoedit) {
        Enter();
        CursorUp();
        FuncEnd();
      }
      break;
    case _escape:
      if (EditChanged) {
        if (!MemoIn)
          sprintf(tmp,"%s%s%s",Abandon_changes,Trim(RawFilename),Question);
        else
          sprintf(tmp, "%s%s", Abandon_changes,memo_question);
        ch = DialogBox(tmp,yes_no_buttons);
      }
      else
        ch = yes_no_chars[0];
      if (ch == yes_no_chars[0])
        editquit = TRUE;
      DisplayEditorStatus();
      break;
    case _backtab:  break;
    case _help:     Helpf(); break;
    case _setwidth: SetWrapWidth(); break;
    case _gotoln:   GoToLine(); break;
    case _reformat: EdReformat(WordWrapWidth); break;
    case _togglewrap: Wrap = !Wrap; DisplayEditorStatus(); break;
    case _sethelp:
      if (!NoHelp)
        WindowEdit(Help_File_Name_Message,helppath);
      break;
    case _savefile:
      if (!MemoIn) { // F2 inhibited when editing memos
        if (!BwriteOK(SaveWithPrompt)) {
          sprintf(tmp,"%s%s", Error_writing,current_file);
          ch = EditDialogBox(tmp);
        }
        DisplayEditorStatus();
      }
      break;
    case _setdir: SetDirectory(); break;
    case _loadfile: GetFileName(FALSE); break;
    case _setext: SetExtension(); break;
    case _print: PrintOut(FALSE); break;
    case _setprint: GetPrinterParameters(); break;
    case _resize: ResizeWindow(); break;
    case _zap: EdZap(TRUE); break;
    case _quickexit:
      if (MemoIn)
        EditChanged = FALSE;
      else {
        if (Txtin && EditChanged)
          if (!BwriteOK(SaveWithNoPrompt)) {
            sprintf(tmp,"%s%s", Error_writing,current_file);
            EditDialogBox(tmp);
          }
      }
      editquit = TRUE;
      break;
    case _home:     Home(); DrawScreen(); break;
    case _curup:    CursorUp(); break;
    case _pgup:     FuncPgUp(); break;
    case _curleft:  CursorLeft(); break;
    case _curright: CursorRight(TRUE); break;
    case _end:      FuncEnd(); break;
    case _curdown:  CursorDown(); break;
    case _ins:
      if (!editnoedit)
        EdIns();
      break;
    case _del:
      if (!editnoedit) {
        if (!Wrap) {
          if (EditColumn <= (int)strlen(Linebuffer[CurrentLine-1]))
            Del();
        }
        else
          Del();
      }
      break;
    case _pgdown:   FuncPgDn(); break;
    case _prevword: PrevWord(); break;
    case _nextword: NextWordEdit(); break;
    case _endfile:
      CurrentLine = (Highestline / WindowDepth) * WindowDepth + 1;
      if (CurrentLine > Highestline)
        CurrentLine = Highestline;
      SetTextColors();
      clrscr();
      EndFile();
      break;
    case _beginfile: BeginFile(); break;
    case _changefilename:
      strcpy(SavedFN, editfilename);
      strcpy(editfilename,GetFilenameToSave(editfilename,SaveWithPrompt));
      if(!*editfilename)
        strcpy(editfilename, SavedFN);
      GetRawName(editfilename, RawFilename);
      EditChanged = TRUE;
      DisplayEditorStatus();
      break;
    case _UNDEFINED:
      EditDialogBox("Undefined function requested in [EditText/EditMemo]");
      break;
    default:
#ifdef _MSC_VER
      _putch(7);
#else
      sound(2200);
      delay(30);
      nosound();
#endif
  }
}
