/* filename: GETFILNM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <ctype.h>
#include <errno.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dialog.h>
#include <pick.h>
#include <utils.h>
#include <edit.h>

void ClearBuffer(void);

void EdZap(int confirm)
{
  char ch;

  if (!editnoedit) {
    if (confirm)
      ch = DialogBox(AskforDelete,yes_no_buttons);
    else
      ch = yes_no_chars[0];
    if (toupper(ch) != yes_no_chars[0])
      return;
    ClearBlockMarkers();
    ClearBuffer();
    ScreenLine = 1;
    CurrentLine = 1;
    Highestline = 1;
    Home();
    Enter();
    EdBackSpace();
    DeleteLine();
    strcpy(editfilename, Defaultname);
    strcpy(RawFilename,editfilename);
    Home();
    DisplayEditorStatus();
    DrawScreen();
    SetChangedFlags();
    Zapped = TRUE;
  }
}

static int NoMem4Edit(void)
{
  return coreleft() < ReservedMemory;
}

void MoveLinesDown(void)
{
  ++CurrentLine;
  if (Highestline < CurrentLine)
    Highestline = CurrentLine;
  memmove(&Linebuffer[CurrentLine],&Linebuffer[CurrentLine-1],4 * (Highestline - CurrentLine + 1));
  ++Highestline;
}

void BlockIn(PathStr f)
{
  char NewLine[STRSIZ];
  char shalf[STRSIZ];
  FILE *TextFile;
  int  counter;
  int  OldCurrentLine;
  char Message[STRSIZ];
  char tmp[STRSIZ];

  errno = 0;
  memset(NewLine,0,STRSIZ);
  OldCurrentLine = CurrentLine;
  TextFile = fopen(f, "r");
  if (errno != 0) {
    EditDialogBox(Readerror_reading_Blockfile);
    return;
  }
  if (feof(TextFile))
    return;
  window(ActiveBox.wlox,ActiveBox.wloy - 1,ActiveBox.wrux,ActiveBox.wruy);
  PushWindow(ActiveBox.wlox,(unsigned char)(ActiveBox.wloy - 1),ActiveBox.wrux,(unsigned char)(ActiveBox.wloy - 1));  /* save first line */
  SetBlockColors();
  gotoxy(1,1);
  sprintf(tmp,"%s %s",Reading_edit_message,f);
  WriteToEOL(tmp,1,WindowWidth);
  SetTextColors();
  ClearBlockMarkers();
  if (!Linebuffer[CurrentLine-1])
    shalf[0]=0;
  else
    strcpy(shalf,Copy(Linebuffer[CurrentLine-1],EditColumn-1,STRSIZ-1));
  BlockStartLine = CurrentLine;
  BlockStartColumn = EditColumn;
  fgets(NewLine,STRSIZ-1,TextFile);
  if (NewLine[strlen(NewLine)-1] == '\n')
    NewLine[strlen(NewLine)-1]=0;
  strcpy(BlockHead,NewLine);
  if (Linebuffer[CurrentLine-1] != NULL) {
    strcpy(tmp,strcat(Copy(Linebuffer[CurrentLine-1],0,EditColumn-1),NewLine));
    strcpy(NewLine,tmp);
  }
  ForgetEdiDynString(CurrentLine);
  MakeEdiDynString(NewLine,CurrentLine);
  counter = 0;
  while (!feof(TextFile) && (!NoMem4Edit()) && ((unsigned)Highestline < MaxLines)) {
    memset(NewLine,0,STRSIZ);
    MoveLinesDown();
    fgets(NewLine,STRSIZ-1,TextFile);
    if (NewLine[strlen(NewLine)-1] == '\n')
      NewLine[strlen(NewLine)-1]=0;
    if (ferror(TextFile)) {
      clearerr(TextFile);
      EditDialogBox(Readerror_reading_Blockfile);
      fclose(TextFile);
      PopWindow();
      return;
    }
    MakeEdiDynString(NewLine,CurrentLine);
    ++counter;
  }
  if (!feof(TextFile) || NoMem4Edit()) {
    if (NoMem4Edit())
      EditDialogBox(Insufficient_memory_to_read_Block);
    else {
      if ((unsigned)Highestline == MaxLines)
        sprintf(Message,"%s%s%s",Maximum_of,SInteger(MaxLines,0),lines_allowed);
      else
        Message[0]=0;
      sprintf(tmp,"%s%s CENTERTEXT",Message,Entire_file_not_loaded);
      EditDialogBox(tmp);
    }
  }
  fclose(TextFile);
  BlockEndLine = CurrentLine;
  BlockEndColumn = strlen(Linebuffer[CurrentLine-1]) + 1;
  BlockMarked = TRUE;
  strcpy(BlockTail,shalf);
  if (!NoMem4Edit()) {
    if (!counter) { // block is a single line
      strcpy(NewLine,Linebuffer[CurrentLine-1]);
      strcat(NewLine,shalf);
      ForgetEdiDynString(CurrentLine);
      MakeEdiDynString(NewLine,CurrentLine);
    }
    else
      if (*shalf) {
        MoveLinesDown();
        MakeEdiDynString(shalf,CurrentLine);
      }
  }
  PopWindow();
  SetChangedFlags();
  CurrentLine = OldCurrentLine;
  while (!Linebuffer[Highestline-1])
    --Highestline;
}

void LoadFile(PathStr name)
{
  SetCursorOff();
  Txtin = TRUE;
  ClearBuffer();
  CurrentLine = Highestline = 1;
  BlockIn(name);
  strcpy(editfilename, name);
  GetRawName(editfilename,RawFilename);
  AutoSaveChanged = EditChanged = Zapped = FALSE;
  NeverChanged = TRUE;
  ClearBlockMarkers();
  EditColumn = ScreenColumn = ScreenLine = 1;
  SetCursorOn();
}

void GetFileName(int IsBlock)
{
  char tmp2[STRSIZ], tmp3[STRSIZ], tmp4[STRSIZ], mess[STRSIZ], drive[10], ch;
  DirStr  dir;
  NameStr name;
  ExtStr  ext;
  PathStr path, newfile, oldfile;
  FILE    *test;

  if (MemoIn && !IsBlock)
    return;
  if (IsBlock) {
    strcpy(mess,Load_Block);
    strcpy(oldfile, BlockFilename);
  }
  else {
    strcpy(mess,Load_file);
    strcpy(oldfile, editfilename);
  }
  strcpy(path, oldfile);
  drive[0] = newfile[0] = dir[0] = name[0] = ext[0] = 0;
  WindowEdit(mess,path);
  if (!*path)
    goto Done;
  strcpy(path, Upper(Trim(Ltrim(path))));
  strcpy(path, AddExt(path,DefaultExt));
  _splitpath(path,drive,dir,name,ext);
  if (!*dir)
    strcpy(dir, actdir);
  if (dir[strlen(dir)-1] != '\\')
    strcat(dir,"\\");
  _makepath(path,drive,dir,name,ext);
  strcpy(newfile, path);
  if (strchr(path,'*') || strchr(path,'?'))
    strcpy(newfile, PickFile(path));
  else {
    if (IsBlock)
      if (!FileExists(path)) {
        sprintf(tmp4,"%s %s.;%s",path,notfound,Do_you_want_a_list_of_all_files_in_the_current_directory);
        if (DialogBox(tmp4,yes_no_buttons) == yes_no_chars[0])
          strcpy(newfile, PickFile(strcat(dir,"*.*")));
        else
          *newfile = 0;
      }
  }
  if (!*newfile)
    goto Done;
  if (nocreate && (strcmp(editfilename ,newfile) != 0)) {
    sprintf(tmp3, "%s%s", Cannot_create_file_other_than,editfilename);
    EditDialogBox(tmp3);
    goto Done;
  }
  if (IsBlock) {
    if (FileExists(newfile))
      BlockIn(newfile);
    else
      strcpy(BlockFilename, oldfile);
  }
  else {
    if (Txtin && EditChanged) {
      sprintf(tmp3,"%s%s%s",Save_file,RawFilename,Question);
      ch = DialogBox(tmp3,yes_no_buttons);
      if (ch == '\x1B')
        return;
      if (ch == yes_no_chars[0]) {
        if (!BwriteOK(SaveWithNoPrompt)) {
          sprintf(tmp3,"%s%s",Error_writing,RawFilename);
          EditDialogBox(tmp3);
        }
      }
    }
    if (FileExists(newfile)) {
      LoadFile(newfile);
      strcpy(editfilename, newfile);
    }
    else {
      sprintf(tmp2,"%s %s;%s CENTERTEXT",newfile,notfound,Create_a_new_file);
      ch = DialogBox(tmp2,yes_no_buttons);
      if (ch == yes_no_chars[0]) {
        if((test = fopen(newfile, "w")) != NULL)
          errno = 0;
        else {
          sprintf(tmp3,"%s%s", newfile,Is_an_Invalid_name);
          EditDialogBox(tmp3);
          goto Done;
        }
        fclose(test);
        remove(newfile);
        EdZap(FALSE);
        strcpy(editfilename, newfile);
        GetRawName(editfilename, RawFilename);
      }
    }
  }
Done:
  DisplayEditorStatus();
  DrawScreen();
}
