/* filename: EDREPCE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>
#include <conio.h>
#ifdef _MSC_VER
 #include <limits.h>
#else
 #include <values.h>
#endif
#include <sayget.h>
#include <dialog.h>
#include <utils.h>
#include <edit.h>

extern char *EditSearchString, *EditReplacement, *EditOpt;

void CursorDelay (void)
{
  unsigned char i;

  i = 0;
  do {
    delay (27);
    ++i;
  }  while (!(EventPending () || (i == 10)));
}

void EdReplace (unsigned char pa, int ControlL)
{
  typedef enum { Fwd,Backward } DirectionMode;

  char zstring[STRSIZ], ch;
  char RestOfString[STRSIZ];
  int position;
  unsigned char found;
  DirectionMode Direction;
  int Searching;
  int Replacing;
  int NoConfirm;
  int MaxFinds;
  int TotalFinds;
  int ReplacedString;
  int SearchLine;
  PathStr LocalSearchString;
  char Times[8];
  int FoundWord;
  int AbsolutePos;
  int FirstLine;
  int Count;
  unsigned char SaveX, SaveY;
  unsigned char SaveXX, SaveYY;
  int FirstTime;
  char tmp[STRSIZ], tmp1[STRSIZ], cc[2];
  int c;
  EventRec e;

  memset (tmp, 0, STRSIZ);
  cc[1] = 0;

  Searching = (pa == 1);
  Replacing = (pa == 2);

  if (!ControlL) {
    WindowEdit (Find_Message, EditSearchString);
    if (!EditSearchString[0])
      return;
    if (Replacing)
      WindowEdit (Replace_Message, EditReplacement);
    WindowEdit (Options_Message, EditOpt);
    FirstTime = TRUE;
  }
  else
    FirstTime = FALSE;
  UpperCase (EditOpt);
  Direction = Fwd;
  MaxFinds = 1;
  SearchLine = CurrentLine;
  FirstLine = TRUE;

  if (Pos ("B", EditOpt) >= 0)
    Direction = Backward;

  Count = (Pos ("C", EditOpt) >= 0);

  if (Pos ("G", EditOpt) >= 0) {
    if (FirstTime)
      if (Direction == Fwd)
        SearchLine = 1;
      else
        SearchLine = Highestline;
#ifdef  _MSC_VER
    MaxFinds = INT_MAX;
#else
    MaxFinds = MAXINT;
#endif
  }
  NoConfirm = (Pos ("N", EditOpt) >= 0);

  strcpy (LocalSearchString, EditSearchString);
  if (Pos ("U", EditOpt) >= 0)
    strcpy (LocalSearchString, Upper (EditSearchString));
  zstring[0] = 0;
  for (found = 1; found <= strlen (EditOpt); found++)
    if (EditOpt[found] >= '0' && EditOpt[found] <= '9') {
      strcpy (tmp, zstring);
      sprintf (zstring, "%s%c", tmp, EditOpt[found]);
    }
  if (!zstring)
    MaxFinds = IntegerVal (zstring);
  found = 0;
  ReplacedString = FALSE;
  TotalFinds = 0;
  while ((SearchLine <= Highestline) && (SearchLine >= 1)
      && (TotalFinds < MaxFinds)) {
    if (!found) {
      strcpy (zstring, Linebuffer[SearchLine - 1]);
      strcpy (RestOfString, zstring);
      if (FirstLine && (EditColumn > 0)) {
        // chop off the first part of the line
        memset (RestOfString, STRSIZ-1, EditColumn);
        EditColumn = 1;
        FirstLine = FALSE;
      }
      if (Pos ("U", EditOpt) >= 0)
        UpperCase (RestOfString);
    }
    position = Pos (LocalSearchString, RestOfString);
    if (position >= 0) {  // we found a match
      FoundWord = TRUE;
      if (Pos ("W", EditOpt) >= 0) {
        if (Pos ("U", EditOpt) >= 0)
          AbsolutePos = Pos (RestOfString, Upper (zstring)) + position + 1;
        else
          AbsolutePos = Pos (RestOfString, zstring) + position + 1;
        if (AbsolutePos != 1) {
          c = zstring[AbsolutePos - 1];
          if ((c >= 0 && c <= 47) ||
            (c >= 58 && c <= 64) ||
            (c >= 91 && c <= 94) ||
            (c == 96) ||
            (c >= 123 && c <= 127))
            FoundWord = FALSE;
        }
        if (AbsolutePos + strlen (LocalSearchString) != strlen (zstring)) {
          c = zstring[AbsolutePos + strlen (LocalSearchString)];
          if ((c >= 0 && c <= 47) ||
            (c >= 58 && c <= 64) ||
            (c >= 91 && c <= 94) ||
            (c == 95) ||
            (c >= 123 && c <= 127))
            FoundWord = FALSE;
        }
      }
      if (!found)
        found = position + 1;
      else
        found += strlen (ReplacedString ? EditReplacement : EditSearchString) + position;
      Delete (RestOfString, 0, position + strlen (EditSearchString));
      CurrentLine = SearchLine;
      if (SearchLine > (int)WindowDepth)
        ScreenLine = WindowDepth - 2;
      else
        ScreenLine = SearchLine;
      if (FoundWord) {
      	if(Searching) {
          ++TotalFinds;
          if(NoConfirm) {
	        if (Direction == Backward)
    	      ch = 's';
        	else
              ch = 't';
          }
        }
        Home ();
        while (EditColumn < (int)found)
          CursorRight (FALSE);
        SaveX = ScreenColumn;
        SaveY = ScreenLine;
        DrawScreen ();
        SetCursorOn ();
        if (nostatus)
          --ScreenLine;
        gotoxy (ScreenColumn, ScreenLine + 1);
      }
      if (FoundWord && Replacing) {
        if (!NoConfirm) {
          window (ActiveBox.wlox, ActiveBox.wloy - 1, ActiveBox.wrux, ActiveBox.wruy);
          gotoxy (1, 1);
          SetBlockColors ();
          HideMouse ();
          sprintf (tmp1, "\"%s\"%s%s", LocalSearchString, found_on_line, SInteger (SearchLine, 0));
#ifdef _MSC_VER
          _outtext (memmove (tmp1, tmp1, WindowWidth));
          _outtext (_replaceYesNo);
#else
          cprintf ("%s", memmove (tmp1, tmp1, WindowWidth));
          cprintf ("%s", _replaceYesNo);
#endif
          SaveXX = wherex ();
          SaveYY = wherey ();
#ifdef _MSC_VER
          ClearEOL (wherex (), wherey ());
#else
          clreol ();
#endif
          ShowMouse ();
          SetTextColors ();
          do {
            do {
              gotoxy (SaveX, SaveY + 1);
              CursorDelay ();
              gotoxy (SaveXX, SaveYY);
              CursorDelay ();
            }  while (!(EventPending ()));
            GetEvent (&e);
            switch (e.WhichEvent) {
              case Keyboard: {
                ch = e.v.sKeyboard.Key;
                if (toupper (ch) == 'Q' || toupper (ch) == '\x1B')
                  goto exitpoint;
              }
                break;
              case Mouse:   ;
                break;
            }
            cc[0] = toupper (ch);
          }  while (! (Pos(cc, yes_no_chars) >= 0));
        }
        else
          ch = yes_no_chars[0];
        if (toupper (ch) == yes_no_chars[0]) {
          ReplacedString = TRUE;
          Delete (zstring, found - 1, strlen (EditSearchString));
          InsertEdit (EditReplacement, zstring, found);
          ForgetEdiDynString (SearchLine);
          MakeEdiDynString (zstring, SearchLine);
          SetChangedFlags();
          DrawScreen ();
          if (Direction == Backward)
            ch = 's';
          else
            ch = 't';
          if (FoundWord)
            ++TotalFinds;
        }
        else {
          ReplacedString = FALSE;
          if (toupper (ch) == yes_no_chars[1])
            ch = '\f';
        }
      }
      if (!FoundWord)
        ch = '\f';
      if ((ch != 's') && (ch != 't') && (ch != '\f'))
        goto exitpoint;
      if (TotalFinds == MaxFinds)
        goto exitpoint;
    }
    else {
      found = 0;
      EditColumn = 1;
      if (Direction == Fwd)
        ++SearchLine;
      else
        --SearchLine;
    }
  }
exitpoint:
  DisplayEditorStatus ();
  if (!TotalFinds)
     DialogBox(BuildStr("\"",LocalSearchString,"\" ",notfound,NULL),ScrollPressAnyKey);
  else
    if (Count) {
      strcpy (Times, (TotalFinds == 1) ? " time." : " times.");
      if (Searching)
        DialogBox(BuildStr(Search_completed,";","\"",EditSearchString,"\" ",_found," ",SInteger(TotalFinds,0),Times,"; CENTERTEXT",NULL),ScrollPressAnyKey);
      else
        DialogBox(BuildStr(Replacing_completed,";\"",EditSearchString,"\" ",replaced_with," \"",EditReplacement,"\" ",SInteger (TotalFinds, 0),Times,"; CENTERTEXT",NULL),ScrollPressAnyKey);
    }
  if (nostatus)
    CursorDown ();
  DisplayEditorStatus ();
}
