/* filename: EDITSTAT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dialog.h>
#include <sayget.h>
#include <edit.h>

void PaintHorizontalScrollBar(void);
void PaintVerticalScrollBar(void);

char EditDialogBox(const char *str)
{
  return DialogBox((char*) str, "buttons=Ok");
}

void DisplayEditorStatus(void)
{
  char bstring[13], fn[13];
  char istring[15];
  char wstring[18];
  char Stat[STRSIZ];
  char tmp[STRSIZ];

  memset(Stat,0,STRSIZ);
  if (nostatus || EditNoDisplay)
    return;
  window(ActiveBox.wlox,ActiveBox.wloy - 1,ActiveBox.wrux,ActiveBox.wruy);
  SetStatusColors();
  gotoxy(1,1);
  if ((unsigned)Highestline > MaxLines) {
    sprintf(tmp,"%s%d%s",Document_can_contain_upto, Highestline, _lines);
    EditDialogBox(tmp);
  }
  if (MemoIn)
    strcpy(RawFilename," >> MEMO << ");

  strcpy(istring, EditInsertmode ? InsertMessage : OverWriteMessage);
  strcpy(wstring, Wrap ? Wrap_ON_Message : Wrap_OFF_Message);
  sprintf(fn,"%c%s", EditChanged ? '*' : ' ',(char _far *)RawFilename);

  switch (ResizeMode) {
    case NoMoveMode: strcpy(fn,RawFilename);       break;
    case Grow:     strcpy(fn,Grow_Mode_Message);   break;
    case Shrink:   strcpy(fn,Shrink_Mode_Message); break;
    case MoveMode: strcpy(fn,Move_Mode_Message);   break;
  }
  strcpy(bstring, BlockMarked ? Block_message : Blank_Block_Message);
  sprintf(Stat," %s%s%5d%s%3d %s %s %s",fn,Line_Message,CurrentLine,Column_Message,EditColumn,istring,wstring,bstring);
  SetCursorOff();
  WriteToEOL(Stat,1,(unsigned char)copye);
  SetCursorOn();
  window(ActiveBox.wlox,ActiveBox.wloy,ActiveBox.wrux,ActiveBox.wruy);
}

void RefreshStatus(void)
{
  char buf[81], tmp[81];

  memset(buf,0,81);
  memset(tmp,0,81);

  if(EditNoDisplay)
    return;
  if (!nostatus) {
    SetCursorOff();
    window(ActiveBox.wlox,ActiveBox.wloy - 1,ActiveBox.wrux,ActiveBox.wruy);
    SetStatusColors();
    if( EditChanged ) {
      gotoxy(1,1);
      HideMouse();
#ifdef _MSC_VER
      _outtext("*");
#else
      cprintf("*");
#endif
      ShowMouse();
    }
    HideMouse();
    if (!ResizeMode && WindowWidth > 18) {
      gotoxy(LinePos,1);
      SetCursorOn();
      sprintf(buf," %5d Col %3d",CurrentLine,EditColumn);
      strncpy(tmp,buf,WindowWidth-LinePos+1);
#ifdef _MSC_VER
      _outtext(tmp);
#else
      cprintf(tmp);
#endif
    }
    window(ActiveBox.wlox,ActiveBox.wloy,ActiveBox.wrux,ActiveBox.wruy);
    ShowMouse();
  }
  if (!NoMouse) {
    SetCursorOff();
    PaintHorizontalScrollBar();
    PaintVerticalScrollBar();
  }
  SetCursorOn();
}

