/* filename: EDITS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <malloc.h>
#include <memory.h>
#include <stdio.h>
#include <string.h>
  
#include <sayget.h>
#include <dialog.h>
#include <vidpop.h>
#include <edit.h>
  
extern char *MemoLineTails;
extern int SoftCrFlag;
extern ColorScheme ActiveColors;
  
SaveMemoRecord *PushPtr  = NULL;
  
void SetTextColors(void)
{
  SetColorTo(ActiveColors.TextFG,ActiveColors.TextBG,ActiveColors.TextFG,ActiveColors.TextBG);
}
  
void SetBlockColors(void)
{
  SetColorTo(ActiveColors.BlockFG,ActiveColors.BlockBG,ActiveColors.BlockFG,ActiveColors.BlockBG);
}
  
void SetStatusColors(void)
{
  SetColorTo(ActiveColors.StatusFG,ActiveColors.StatusBG,ActiveColors.StatusFG,ActiveColors.StatusBG);
}
  
void SetHelpColors(void)
{
  SetColorTo(ActiveColors.HelpTextFG,ActiveColors.HelpTextBG,ActiveColors.HelpTextFG,ActiveColors.HelpTextBG);
}
  
void EdBox(unsigned char a, unsigned char b, unsigned char c,
           unsigned char d, unsigned char r, char * g)
{
  PushColors();
  SetColorTo(ActiveColors.FrameFG,ActiveColors.FrameBG,
  ActiveColors.FrameFG,ActiveColors.FrameBG);
  Box(a,b,c,d,r,g);
  PopColors();
}
  
#ifdef _MSC_VER
#include <graph.h>
  
void delline()
{
  short left, top, right, bottom;
  int savex, savey;
  
  savex = wherex();
  savey = wherey();
  _gettextwindow( &top, &left, &bottom, &right );
  _scrolltextwindow( _GSCROLLUP );
  _settextwindow( top, left, bottom, right );
  _settextposition( savey, savex );
}
#endif
  
void Scroll(void)
{
  if (!EditNoDisplay) {
    --ScreenLine;
    if (!BlockMarked || (BlockEndLine < CurrentLine - WindowDepth)
    || (BlockStartLine > CurrentLine + WindowDepth)) {
      gotoxy(1,1);
      SetTextColors();
      HideMouse();
      delline();
      ShowMouse();
      gotoxy(1,WindowDepth);
      if (Linebuffer[CurrentLine-1])
        WriteToEOL(Linebuffer[CurrentLine-1],(unsigned char)copyb,(unsigned char)copye);
    }
    else
      DrawScreen();
    gotoxy(1,ScreenLine);
  }
}
  
int PushMemoData(void)
{
  if (coreleft() >= sizeof(*PushPtr)) {
    if((PushPtr = malloc(sizeof(*PushPtr))) == NULL) {
      SetError(217, 1, " [SetHelpTo]");
      return FALSE;
    }
    PushPtr->PushedMemoColors = MemoColors;
    PushPtr->PushedMemoBox = MemoBox;
    PushPtr->SaveWrap = Wrap;
    PushPtr->SaveWordWrapWidth = WordWrapWidth;
    memmove(&PushPtr->SaveJumpTable,JumpTable,sizeof(PushPtr->SaveJumpTable));
    return TRUE;
  }
  return FALSE;
}
  
void PopMemoData(void)
{
  if (PushPtr) {
    MemoColors = PushPtr->PushedMemoColors;
    MemoBox = PushPtr->PushedMemoBox;
    Wrap = PushPtr->SaveWrap;
    WordWrapWidth = PushPtr->SaveWordWrapWidth;
    memmove(JumpTable,&PushPtr->SaveJumpTable,sizeof(JumpTable));
    FreePtrClear((void*) &PushPtr);
  }
}
  
void GetMemoCoordinates(long *c1, long *r1, long *c2, long *r2)
{
  *c1 = ActiveBox.blox;
  *r1 = ActiveBox.bloy;
  *c2 = ActiveBox.brux;
  *r2 = ActiveBox.bruy;
}
  
void EdIns(void)
{
  EditInsertmode = !EditInsertmode;
  SetCursorOn();
  DisplayEditorStatus();
}
  
void InsertEdit(char *str, char *zstring, int Column)
{
  char c, buf[STRSIZ];
  
  c = zstring[Column-1];
  zstring[Column-1]=0;
  strcpy(buf,zstring);
  strcat(buf, str);
  zstring[Column-1]=c;
  strcat(buf,zstring+Column-1);
  strcpy(zstring,buf);
}
  
void InsertLine(void)
{
  char tmp[STRSIZ];
  
  if (((unsigned)Highestline < MaxLines) && ((unsigned)CurrentLine < MaxLines))
  {
    SetChangedFlags();
    memmove(&Linebuffer[CurrentLine],&Linebuffer[CurrentLine-1],(Highestline - CurrentLine + 1) * 4);
    if(MemoIn) {
      memmove(&MemoLineTails[CurrentLine],&MemoLineTails[CurrentLine-1],sizeof(char)*(Highestline-CurrentLine+1));
      MemoLineTails[CurrentLine-2] = (SoftCrFlag == TRUE) ? '\x8D' : '\r';
    }
    MakeEdiDynString("",CurrentLine);
    ++Highestline;
  }
  else {
    sprintf(tmp,"%s%s%s",Document_can_contain_upto,SInteger(MaxLines,0),_lines);
    EditDialogBox(tmp);
  }
}
  
