/* filename: CURSORS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <stdio.h>
#include <string.h>

#include <sayget.h>
#include <utils.h>
#include <edit.h>

#ifdef _MSC_VER
void insline()
{
  short left, top, right, bottom;
  int savex, savey;

  savex = wherex();
  savey = wherey();
  _gettextwindow( &top, &left, &bottom, &right );
  _scrolltextwindow( _GSCROLLDOWN );
  _settextwindow( top, left, bottom, right );
  _settextposition( savey, savex );
}
#endif

void CursorUp(void)
{
  if (CurrentLine > 1) {
    --CurrentLine;
    if (ScreenLine == 1) {
      if (!BlockMarked || (BlockEndLine < CurrentLine - WindowDepth)
      || (BlockStartLine > CurrentLine + WindowDepth)) {
        gotoxy(1,1);
        SetTextColors();
        HideMouse();
        insline();
        ShowMouse();
        gotoxy(1,1);
        WriteToEOL(Linebuffer[CurrentLine-1],(unsigned char)copyb,(unsigned char)copye);
      }
      else
        DrawScreen();
    }
    else
      --ScreenLine;
    RefreshStatus();
  }
}

void CursorDown(void)
{
  if (CurrentLine < Highestline) {
    ++ScreenLine;
    ++CurrentLine;
    if (ScreenLine > (int)WindowDepth)
      Scroll();
    RefreshStatus();
  }
}

void EdBackSpace(void)
{
  if (!((EditColumn == 1) && (CurrentLine == 1))) {
    if (EditColumn == 1) {
      CursorUp();
      FuncEnd();
    }
    else
      CursorLeft();
    Del();
  }
}

void CursorRight(int draw)
{
  if (EditColumn < STRSIZ-1) {
    ++ScreenColumn;
    ++EditColumn;
  }
  if (ScreenColumn > (int)WindowWidth) {
    ScreenColumn = WindowWidth;
    ++copyb;
    if (draw)
      DrawScreen();
  }
  if(EditNoDisplay)
    RefreshStatus();
}

void CursorLeft()
{
  if ((ScreenColumn == 1) && (EditColumn > 1)) {
    --copyb;
    DrawScreen();
  }
  if (EditColumn > 1)
    --EditColumn;
  if (ScreenColumn > 1)
    --ScreenColumn;
  if (ScreenColumn < 1)
    ScreenColumn = 1;
  if(EditNoDisplay)
    RefreshStatus();
}

void FuncEnd(void)
{
  int l, p;

  if (Linebuffer[CurrentLine-1]) {
    Home();
    l = strlen(Linebuffer[CurrentLine-1]);
    p = Pos("\x8D",Linebuffer[CurrentLine-1]) + 1;
    while ((Wrap && (EditColumn < p))  ||
    (!p && (EditColumn < (l+1)) && (EditColumn < STRSIZ-2))) {
      ++ScreenColumn;
      ++EditColumn;
      if (ScreenColumn > (int)(WindowWidth)) {
        ScreenColumn = WindowWidth;
        ++copyb;
      }
    }
    DrawScreen();
  }
}

void BeginFile(void)
{
  CurrentLine = 1;
  Home();
  ScreenLine = 1;
  DrawScreen();
}

void EndFile(void)
{
  if ((unsigned char) Highestline <= WindowDepth)
    ScreenLine = Highestline;
  else
    ScreenLine = Highestline - CurrentLine + 1;
  CurrentLine = Highestline;
  DrawScreen();
}

void FuncPgUp(void)
{
  CurrentLine = CurrentLine - WindowDepth;
  if (CurrentLine <= ScreenLine)
    BeginFile();
  else
    DrawScreen();
  RefreshStatus();
}

void FuncPgDn(void)
{
  if ((Highestline > CurrentLine)) {
    if ((Highestline > (CurrentLine - ScreenLine + WindowDepth))) {
      CurrentLine = CurrentLine + WindowDepth;
      if (CurrentLine > Highestline)
        CurrentLine = Highestline;
      SetTextColors();
      clrscr();
      DrawScreen();
    }
    else
      EndFile();
    RefreshStatus();
  }
}

void Home(void)
{
  ScreenColumn = 1;
  EditColumn = 1;
  copyb = 1;
}

void GoToLine(void)
{
  PathStr Ln = "";
  int X;

  WindowEdit(Go_to_Line_Number,Ln);
  X = IntegerVal(Ln);
  if (X > Highestline)
    X = Highestline;
  if (X > 0) {
    CurrentLine = X;
    ScreenLine = 1;
    DrawScreen();
    DisplayEditorStatus();
  }
}
