/* filename: BWRITEOK.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <direct.h>
#include <dos.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
  
#include <dialog.h>
#include <sayget.h>
#include <utils.h>
#include <edit.h>
  
extern int BakUp;
  
char *GetFilenameToSave(PathStr SuggestedName, FilePromptMode PromptMode);
  
int BwriteOK(FilePromptMode PromptMode)
{
  int      a, b, i;
  char     z[STRSIZ], buf[STRSIZ];
  PathStr  name, bakfile;
  long     tsize, avail;
  FILE     *TextFile;
  unsigned drive;
  
#ifdef _MSC_VER
  struct  _diskfree_t freedom;
#else
  struct  diskfree_t freedom;
#endif
  
  if (!MemoIn)
    if ((PromptMode == SaveWithNoPrompt) && !EditChanged)
      return TRUE;
    switch (PromptMode) {
      case SaveBlock:
        *name = 0;
        GetFilenameToSave(name,PromptMode);
        if (!*name)
          return TRUE;
        break;
      case SaveWithNoPrompt:
        if (!strcmp(editfilename,Defaultname)) {
          *name = 0;
          GetFilenameToSave(name,PromptMode);
          if (!*name)
            return TRUE;
        }
        else
          strcpy(name,editfilename);
        break;
      case SaveWithPrompt:
        strcpy(name,GetFilenameToSave(editfilename,PromptMode));
        if (!*name)
          return TRUE;
        break;
    }
  SetCursorOff();
  if (BakUp && !(PromptMode == SaveBlock) && FileExists(name)) {
    strcpy(bakfile,ReplaceExt(name,"BAK"));
    if (strcmp(bakfile, name)) {
      if (FileExists(bakfile))
        remove(bakfile);
      rename(name,bakfile);
    }
  }
  a = 1;
  b = Highestline;
  if (PromptMode == SaveBlock) {
    strcpy(BlockFilename, name);
    a = BlockStartLine;
    b = BlockEndLine;
  }
  tsize = 0;
  for (i = a; i <= b; i++)
    tsize = tsize + strlen(Trim(Linebuffer[i-1])) + 2;
  _dos_getdrive(&drive);
  _dos_getdiskfree(drive, &freedom);
  avail =  (long) freedom.avail_clusters
  * (long) freedom.bytes_per_sector
  * (long) freedom.sectors_per_cluster;
  if (tsize >= avail) {
    EditDialogBox(Diskfull);
    SetCursorOn();
    return FALSE;
  }
  window(ActiveBox.wlox,ActiveBox.wloy - 1,ActiveBox.wrux,ActiveBox.wruy);
  SetBlockColors();
  SetTextColors();
  window(ActiveBox.wlox,ActiveBox.wloy,ActiveBox.wrux,ActiveBox.wruy);
  errno = 0;
  if( (TextFile = fopen(name,"w")) != NULL)
    errno = 0;
  for (i = a; i <= b; i++) {
    if (Linebuffer[i-1]) {
      strcpy(z,Linebuffer[i-1]);
      if (PromptMode == SaveBlock) {
        if (i == BlockStartLine)
          strcpy(z,BlockHead);
        if (i == BlockEndLine)
          strcpy(z,Copy(Linebuffer[BlockEndLine-1],0,BlockEndColumn - 1));
        if (BlockStartLine == BlockEndLine)
          strcpy(z,BlockHead);
      }
      strcpy(buf, Trim(z));
      fprintf(TextFile, "%s\n", buf);
      DBFError = errno;
      if (DBFError) {
        fclose(TextFile);
        return FALSE;
      }
    }
  }
  fclose(TextFile);
  DBFError = errno;
  if (DBFError)
    return FALSE;
  AutoSaveChanged = FALSE;
  EditChanged = FALSE;
  if (PromptMode != SaveBlock) {
    strcpy(editfilename, name);
    GetRawName(editfilename, RawFilename);
  }
  DisplayEditorStatus();
  return TRUE;
}
