/* filename: MENU.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <sayget.h>
#include <utils.h>
#include <vidpop.h>
#include <dialog.h>
#ifdef _MSC_VER
#include <graph.h>
#endif

char MenuSeparatorChar  = ';';
unsigned char MenuMargin  = 0;
int  LeaveMenusDisplayed  = FALSE;  // boolean

void Menu(const char * instring)
{
  static char   schar[2] = " ";
  char buffer[STRSIZ];
  char MenuString[STRSIZ]; // An individual menu choice string
  char OldHeading[STRSIZ]; // Original / default menu heading string.
  char MenuChoices[STRSIZ];// trimmed copy of the input string
  int  MenuStayOn;   // Flag whether to pop the window when done.
  int  NextTrigger;  // Flag to locate Trigger characters in menu
  int  CenterChoices;// Flag whether to center menu choices
  int  NoMenuBox;    // Flag TRUE if MenuLineStyle = NoLine
  int  NoMenuHeading;// Flag TRUE if MenuHeading = ''
  int  ResetColors;  // Controls resetting of menu colors vars.
  int  ResetHeading; // Controls resetting of menu heading string
  int  ResetTrigger; // Controls resetting of trigger key colors.
  int  RoomForBox;   // Controls whether or not a Box is drawn
  int  saveOrder;    // Save the current coordinate system
  unsigned char ColNo;    // Menu Choice output starting column number
  unsigned char FirstLine;// First MenuChoice line on the screen
  unsigned char LineNo;   // Menu Choice output Line Number
  unsigned char Longest;  // Length of the longest Choice or the heading
  unsigned char LongestChoice = 0;// Length of the longest MenuChoice String
  unsigned char MaxCols;  // Max available columns on the screen.
  unsigned char MaxRows;  // Max available rows on the screen.
  unsigned char MenuRows; // Number of screen rows occupied by the menu
  unsigned char NLength;  // Computed length of each MenuChoice string
  unsigned char NStrings; // Number of strings in the MenuChoices param
  unsigned char Start;// Starting MenuChoices char number
  unsigned char StartCol;   // Menu Choice output starting column number
  unsigned char TriggerKeys[MaxTriggers];   // Menu Choice trigger keys
  unsigned char TotalLength; // Length of the Trimmed MenuChoices string
  unsigned char BottomWindow;// Bottom of Pushed window - plus shadow
  unsigned char RightWindow; // Right side of Pushed window - plus shadow
  unsigned char LeftSide, RightSide;   // Locations of the Menu Box
  unsigned char TopSide, BottomSide;
  unsigned char From, tmpchar, Keys, Into;

  char *ptr;
  int saveX, saveY, pos, i;// Vars used to increment & count through arrays
#ifdef _MSC_VER
  short wc1,wc2,wr1,wr2;
#else
  struct text_info ti; // Save the user's window coordinates
#endif

  // NOTE: if NoLine is specified for the Menu Box, then the MenuMargin is
  // ignored, and the Moving Bar is exactly as wide as the longest menu
  // string.  If a line style is specified for the Menu Box, then the
  // MenuMargin is used to calculate the amount of space between the
  // side of the Menu Box and the MOVING BAR.  ADDITIONALLY,
  // the Moving Bar is one space wider than the longest menu choice!

  strcpy(MenuChoices, Trim(instring));
  NoMenuBox = MenuLineStyle == NoLine;
  MaxRows = MaxAvailRows();
  MaxCols = 80;
  if (MaxRows > MaxTriggers)
    MaxRows = MaxTriggers;
  CenterChoices = MenuStayOn = ResetHeading  = 0;
  if ((pos = PosOf(1," centertext", Lower(MenuChoices))) >= 0) {
    CenterChoices = TRUE;
    Delete(MenuChoices, pos, 11);
  }
  if ((pos = PosOf(1," stayon", Lower(MenuChoices))) >= 0) {
    MenuStayOn = TRUE;
    Delete(MenuChoices, pos, 7);
  }
  if ((pos = PosOf(1," heading=",Lower(MenuChoices))) >= 0) {
    strcpy(OldHeading,MenuHeading);
    Start = pos;
    Delete(MenuChoices, pos, 9);
    if (((unsigned) pos = PosOf(1, "\'", MenuChoices)) >= Start) {
      Delete(MenuChoices, Start, pos + 1 - Start);
      if ((ptr = strchr(MenuChoices,'\'')) != NULL) {
        ResetHeading = TRUE;
        tmpchar = *ptr;
        *ptr = 0;
        strcpy(MenuHeading, &MenuChoices[Start]);
        *ptr = tmpchar;
      }
      Delete(MenuChoices, Start, strlen(MenuHeading)+1);
    }
  }
  NoMenuHeading = (*MenuHeading == 0);
  if (!*MenuChoices) {
    MenuChoice = 0;
    *MenuString = 0;
    MenuChar = ' ';
    return;
  }
  NStrings = 1;
  for (i = 0; i < MaxTriggers; i++)
    TriggerKeys[i] = 0;
  TotalLength = strlen(MenuChoices);
  for (i = 0; i < (int)TotalLength; i++)
    if (MenuChoices[i] == MenuSeparatorChar)
  ++NStrings;
  if (NStrings > MaxRows) {
    MenuChoice = 0;
    *MenuString = 0;
    MenuChar = ' ';
    SetError(InvalidParameter, 5, Menu_String_Has_Too_Many_Choices,
             SInteger(MaxRows,0), ") ", MenuChoices, " [Menu]");
    return;
  }
  Longest = Start = Keys = 0U;
  if (NStrings == 1) {// First, handle the 1 line horizontal menu
    Longest = TotalLength;
    if (strchr(MenuChoices,'[') && strchr(MenuChoices,']')) {
      From = Into = 0U;
      NextTrigger = FALSE;
      while ((From < TotalLength) && (Keys <= MaxRows)) {
        if ((MenuChoices[From] == '[') && (MenuChoices[From + 2] == ']'))
          NextTrigger = TRUE;
        else {
          MenuChoices[Into] = MenuChoices[From];
          if (NextTrigger) {
            ++Keys;
            MenuChoices[From] = ' ';
            ++From;
            TriggerKeys[Keys-1] = Into;
            NextTrigger = FALSE;
          }
          ++Into;
        }
        if (From != (unsigned char)(Into - 1))
          MenuChoices[From] = ' ';
        ++From;
      }
    }
    strcpy(MenuChoices,Trim(MenuChoices));
    TotalLength = strlen(MenuChoices);
    Longest = TotalLength;
  }
  else {  // Then handle the vertical menu
    for (i = 0; i < (int)NStrings; i++) {
      strcpy(MenuString, &MenuChoices[Start]);
      ptr = strchr(MenuString, MenuSeparatorChar);
      if (ptr == NULL) // Last String - no more Separators
        NLength = strlen(Trim(MenuString));
      else {
        NLength = (unsigned char) (ptr - MenuString);
        *ptr = 0;
      }
      // Here, MenuString is just 1 single string.
      // Next, look for a trigger key in the string.
      ptr = strchr(MenuString,'[');
      if (ptr && (strchr(MenuString, ']') == ptr + 2)) {
        NLength -= 2;
        TriggerKeys[i] = (unsigned char)(ptr - MenuString + 1);
      }
      // Here, we recognize a trigger key inside double brackets...
      // the effect will be to highlight a character that is displayed
      // inside a set of single brackets - (for those who use brackets
      // to surround the trigger key on keys that don't show highlights
      // very well.
      ptr = strstr(MenuString,"[[");
      if (ptr)
        if (strstr(MenuString, "]]") == ptr + 3) {
          NLength -= 2;
          TriggerKeys[i] = (unsigned char)(ptr - MenuString + 2);
        }
      if (NLength > Longest)
        Longest = NLength;
      schar[0] = MenuSeparatorChar;     // char schar[2] = " ";
      Start += PosOf(1, schar, &MenuChoices[Start]) + 1;
    }
    // Finally, pack the []'s out of the entire MenuChoices string
    if (strchr(MenuChoices,'[') && strchr(MenuChoices,']')) {
      From = Into = 0U;
      NextTrigger = FALSE;
      while(From < TotalLength) {
        if ((MenuChoices[From] == '[') && (MenuChoices[From + 2] == ']'))
          NextTrigger = TRUE;
        else {
          MenuChoices[Into] = MenuChoices[From];
          if (NextTrigger) {
            MenuChoices[From] = ' ';
            ++From;
            NextTrigger = FALSE;
          }
          ++Into;
        }
        if (From != (unsigned char)(Into - 1))
          MenuChoices[From] = ' ';
        ++From;
      }
    }
    strcpy(MenuChoices,Trim(MenuChoices));
    TotalLength = strlen(MenuChoices);
  }
  if (strlen(MenuHeading) > Longest)
    Longest = strlen(MenuHeading);
  if (Longest > (unsigned char)(MaxCols - (2 * MenuMargin))) {
    MenuChoice = 0;
    *MenuString = 0;
    MenuChar = ' ';
    SetError(InvalidParameter,3,Menu_Too_Wide_For_Screen,MenuChoices," [Menu]");
    return;
  }
  StartCol = (MaxCols - Longest) / 2 + 1;
  RoomForBox = TRUE;
  // First, determine the Left & Right sides of the menu box...
  // REMEMBER:  there is always one blank between the side of the box
  //            and the choices because the Moving Bar Menu is 1
  //            wider than the widest choice!
  if (StartCol == 1)   // ..then Longest string is as wide as the screen
    RoomForBox = FALSE;
  else {
    if (ULCol == 255) {  // no user defined Column, so center it!
      if (NoMenuBox)
        LeftSide = StartCol;
      else
        if (StartCol > (unsigned char)(3 + MenuMargin))
          LeftSide = StartCol - (2 + MenuMargin);
        else
          LeftSide = 1;
      RightSide = MaxCols - LeftSide + 1;
      if (Longest % 2 == 1)
        --RightSide;
    }
    else {// There is a user defined Column... so start there!
      LeftSide = ULCol;
      if (NoMenuBox)
        RightSide = LeftSide + Longest - 1;
      else
        RightSide = ULCol + 3 + (2 * MenuMargin) + Longest;
      if (RightSide > MaxCols) {  // If the menu's too wide, move it
                                  // to the left so it'll fit.
        RightSide = MaxCols;
        if (NoMenuBox)
          LeftSide = MaxCols - Longest + 1;
        else
          LeftSide = MaxCols - 3 - (2 * MenuMargin) - Longest;
      }
      StartCol = LeftSide;
      if (!NoMenuBox)
        StartCol += (MenuMargin + 2);
    }
  }
  // Then, determine the Top & Bottom sides of the menu box ...
  if (NStrings >= (unsigned char)(MaxRows - 1)) {// Full screen of menu choice lines
    RoomForBox = FALSE;
    TopSide = 0;
  }
  else {
    MenuRows = NStrings + 2;
    if (NoMenuBox)
      if (NoMenuHeading)
        MenuRows -= 2;
      else
        --MenuRows;
    if (ULRow == CenterVert) {  // no user defined Row,  so center it!
      if (NStrings > MaxRows)
        TopSide = 1;
      else
        TopSide = (MaxRows - MenuRows) / 2;
      BottomSide = TopSide + MenuRows - 1;
      if (BottomSide > MaxRows)
        BottomSide = MaxRows;
    }
    else {  // There is a user defined Row... so start there!
      TopSide = ULRow;
      BottomSide = TopSide + MenuRows - 1;
      if (BottomSide > MaxRows) {
        BottomSide = MaxRows;
        TopSide = BottomSide - MenuRows + 1;
      }
    }
  }
  // At this point we have decided that all is well and we are ready to
  // actually do stuff that will affect the screen . . . so, push the
  // window, save the coordinates, setup the colors, etc. - and restore
  // the original settings at the end of the routine.
  // If the global flag LeaveMenuDisplayed is set to TRUE, then don't push
  // the window here, or restore it later... just leave the menu on the screen,
  // and let the user worry about screen management.
  saveX = wherex();
  saveY = wherey();
  SaveCursor(&CursorVariable);
  // Save window
#ifdef _MSC_VER
  _gettextwindow(&wr1, &wc1, &wr2, &wc2);
  _settextwindow(1, 1, MaxAvailRows(), 80);
#else
  gettextinfo(&ti);
  window(1, 1, 80, MaxAvailRows());
#endif
  if (RightSide < (unsigned char)(MaxCols - 1))
    RightWindow = RightSide + 2;
  else
    RightWindow = MaxCols;
  if (BottomSide < MaxRows)
    BottomWindow = BottomSide + 1;
  else
    BottomWindow = MaxRows;
  if (!LeaveMenusDisplayed) {
    PushWindow(LeftSide, TopSide, RightWindow, BottomWindow);
    if (MenuStayOn)
      ++MenusOnStack;
  }
  if (!FGTrig && !BGTrig) {
    FGTrig = SelectedColor & 0x0F;
    BGTrig = (SelectedColor & 0xF0) >> 4;
    ResetTrigger = TRUE;
    if (!FGTrig && !BGTrig) {
      FGTrig = WHITE;
      BGTrig = BLACK;
    }
  }
  else
    ResetTrigger = FALSE;
  if (!FGBox && !FGBar && !BGBox && !BGBar) {
    ResetColors = TRUE;
    CurrentColors(&FGBox, &BGBox, &FGBar, &BGBar);
  }
  else {
    ResetColors = FALSE;
    PushColors();
    SetColorTo(FGBox, BGBox, FGBar, BGBar);
  }
  saveOrder = dBASEOrder;
  dBASEOrder = FALSE;
  if (RoomForBox)
    if (NoMenuBox) {
      if (!NoMenuHeading)
        At(LeftSide + ((Longest - strlen(MenuHeading))/2),TopSide,MenuHeading);
    }
    else
      Box(LeftSide,TopSide,RightSide,BottomSide,MenuLineStyle,MenuHeading);
  Start = 0;
  if (NoMenuBox && NoMenuHeading)
    FirstLine = TopSide;
  else
    FirstLine = TopSide + 1;
  LineNo = FirstLine;
  for(i = 0; i < (int)NStrings; i++) {
    if (CenterChoices) {
      if (ULCol == CenterHoriz) {  // Then we are centering on the screen
        tmpchar = MenuChoices[TotalLength];
        MenuChoices[TotalLength] = 0;
        if (strchr(&MenuChoices[Start], MenuSeparatorChar) == NULL)
          ColNo = (MaxCols - strlen(Trim(&MenuChoices[Start]))) / 2 + 1;
        else {
          strcpy(buffer, &MenuChoices[Start]);
          if ((ptr = strchr(buffer,MenuSeparatorChar)) != NULL)
            *ptr = 0;
          ColNo = (MaxCols - strlen(buffer)- 1) / 2 + 1;
        }
        MenuChoices[TotalLength] = tmpchar;
      }
      else {  // Else, we are centering in the box drawn somewhere
        tmpchar = MenuChoices[TotalLength];
        MenuChoices[TotalLength] = 0;
        if (strchr(&MenuChoices[Start], MenuSeparatorChar) == NULL)
          ColNo = LeftSide + (RightSide - LeftSide - 1 - strlen(Trim(&MenuChoices[Start]))) / 2 + 1;
        else {
          strcpy(buffer, &MenuChoices[Start]);
          if ((ptr = strchr(buffer,MenuSeparatorChar)) != NULL)
            *ptr = 0;
          ColNo = LeftSide + (RightSide - LeftSide - 1- strlen(buffer)- 1) / 2 + 1;
        }
        MenuChoices[TotalLength] = tmpchar;
      }
      if (!NoMenuBox)
        if (ColNo == (unsigned char)(LeftSide + MenuMargin + 1))
          ++ColNo;
    }
    else
      ColNo = StartCol;
    if (strchr(&MenuChoices[Start],MenuSeparatorChar) == NULL)
      strcpy(buffer, Trim(&MenuChoices[Start]));
    else {
      strcpy(buffer, &MenuChoices[Start]);
      if ((ptr = strchr(buffer,MenuSeparatorChar)) != NULL)
        *ptr = 0;
    }
    At(ColNo,LineNo,buffer);
    pos = strlen(buffer);
    if (pos > (int)LongestChoice)
      LongestChoice = pos;
    if (NStrings > 1)
      if (TriggerKeys[i] > 0) {
        PushColors();
        SetColorTo(FGTrig,BGTrig,FGTrig,BGTrig);
        schar[0] = MenuChoices[Start + TriggerKeys[i]-1];
        At(ColNo + TriggerKeys[i] - 1,LineNo,schar);
        PopColors();
      }
    ++LineNo;
    strcpy(buffer, &MenuChoices[Start]);
    schar[0] = MenuSeparatorChar;
    Start += PosOf(1, schar, buffer) + 1;
  }
  if (NStrings == 1) {  // paint the Trigger Keys in the horizontal menu
    PushColors();
    --LineNo;
    SetColorTo(FGTrig, BGTrig, FGTrig, BGTrig);
    for(i = 0; i < (int)Keys; i++) {
      schar[0] = MenuChoices[TriggerKeys[i]];
      At(ColNo + TriggerKeys[i], LineNo, schar);
    }
    PopColors();
  }
  //  Now, Recompute the Top, Bottom, Left & Right sides for CreateMenu
  TopSide = FirstLine;
  BottomSide = TopSide + NStrings - 1;
  if (CenterChoices)
    if (ULCol == CenterHoriz)
      LeftSide = (MaxCols - LongestChoice) / 2 + (NoMenuBox ? 1 : 0);
    else {
      if (!NoMenuBox) {
        pos = RightSide- LeftSide - LongestChoice;
        pos += pos & 1;
        LeftSide += pos / 2;
      }
    }
  else
    if (NoMenuBox)
      LeftSide = StartCol;
    else
      if (StartCol > 1)
        LeftSide = StartCol - 1;
      else
        LeftSide = 1;
  RightSide = LeftSide + LongestChoice + (NoMenuBox ? -1 : 1);
  if (RightSide > MaxCols)
    RightSide = MaxCols;
  CreateMenu(LeftSide, TopSide, RightSide, BottomSide, FGBar, BGBar);
  //  FINISHED!... Restore whatever needs to be restored & return.
  dBASEOrder = saveOrder;
  if (ResetTrigger)
    BGTrig = FGTrig = 0U;
  if (ResetColors)
    BGBar = BGBox = FGBar = FGBox = 0U;
  else
    PopColors();
  if (ResetHeading)
    strcpy(MenuHeading, OldHeading);
  if (!LeaveMenusDisplayed && !MenuStayOn)
    PopWindow();
#ifdef _MSC_VER
  _settextwindow(wr1, wc1, wr2, wc2);
#else
  window(ti.winleft, ti.wintop, ti.winright, ti.winbottom);
#endif
  gotoxy(saveX,saveY);
  RestoreCursor(CursorVariable);
}
