/* filename: LLEDIREC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <stdio.h>
#include <string.h>
#ifdef _MSC_VER
 #include <graph.h>
#endif
#include <dbf.h>
#include <sayget.h>
#include <dbfedit.h>

void (*UsersAutoHelp)(void) = NULL;

extern char DBFEditLineChar;

BOOL DBFEditNoStatus = FALSE;
int OldDbaseOrder=0;

static unsigned char StartingField = 0;
static unsigned char sfg = 0, sbg = 0, gfg = 0, gbg = 0;

void SetCursor(void)
{
  if (StartingField > 0) {
    SGNextField = StartingField;
    ExitField = TRUE;
    StartingField = 0;
  }
  else
    if (UsersAutoHelp)
      UsersAutoHelp();
}

void ClearEditArea(void)
{
#ifdef _MSC_VER
  short left, top, right, bottom;

  _gettextwindow(&top, &left, &bottom, &right);
  _settextwindow(DbfEditBox.r1 + 2,DbfEditBox.c1 + 2,DbfEditBox.r2,DbfEditBox.c2);
  _clearscreen(_GWINDOW);
  _settextwindow(top, left, bottom, right);
#else
  struct text_info ti;

  gettextinfo(&ti);
  window(DbfEditBox.c1 + 2,DbfEditBox.r1 + 2,DbfEditBox.c2,DbfEditBox.r2);
  clrscr();
  window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
#endif
  CurrentColors(&sfg, &sbg, &gfg, &gbg);
}

static void ClearDefinition(int i)
{
  unsigned char *dummy = NULL;
  char buf[STRSIZ];

  if (!DataDefinition)
    SetError(InternalError, 1, " [ClearDefinition]");
  else {
    strcpy(DataDefinition->DBFAlias, Alias());
    strcpy(DataDefinition->FieldName, Field(i));
    DataDefinition->Row = 0xFF;
    DataDefinition->Column = 0xFF;
    sprintf(buf,"%s%s",Field(i),Space(10));
    buf[10]=0;
    strcpy(DataDefinition->Prompt, buf);
    strcpy(DataDefinition->Picture,"");
    strcpy(DataDefinition->LoRange,"");
    strcpy(DataDefinition->HiRange,"");
    DataDefinition->Required = FALSE;
    DataDefinition->BlankField = FALSE;
    DataDefinition->NoEdit = FALSE;
    DataDefinition->ValidatePtr = NULL;
    DataDefinition->AutoHelpPtr = NULL;
    CurrentColors(&(DataDefinition->PromptForeGround),&(DataDefinition->PromptBackGround),dummy,dummy);
  }
}

void LowLevelEditRecord(void)
{
  char Len, NumberOfSayGetFields;
  unsigned char CurrentRow, DeleteColumn, len;
  int FirstField, LastField, MaxFields, MaxLen, i = 0;
  void *p;
  VarTypes t;
  DataDefinitionType DD;

  DataDefinition = &DD;
  DeleteColumn = DbfEditBox.c1 + ((DbfEditBox.c2 - DbfEditBox.c1) / 2) - 2;
  MaxLen = DbfEditBox.c2 - DbfEditBox.c1 - 13; // largest field width we can display, assume a 10 char prompt
  if (LeftDelimiter)
    ++MaxLen;
  if (RightDelimiter)
    ++MaxLen;
  MaxFields = DbfEditBox.r2 - DbfEditBox.r1 - 1; // largest number of fields that can be shown in the window
  FirstField = 1;
  LastKey = '\x0';
  do {
    ClearEditArea(); // clear the box for the next set of saygets
    LastField = FirstField + MaxFields - 1;
    if (LastField > FieldCount())
      LastField = FieldCount();
    if (LastKey == '\x18')
      StartingField = LastField - FirstField + 1;
    else
      StartingField = 0;
    CurrentRow = DbfEditBox.r1 + 1;
    NumberOfSayGetFields = 0;
    for (i = FirstField; i <= LastField; i++) {
      switch (FieldType(i)) {
        case 'C': t = _S; break;
        case 'D': t = _D; break;
        case 'L': t = _L; break;
        case 'M': t = _M; break;
        case 'N':
        case 'F': t = FieldDec(i) ? _DF: _LI; break;
      }
      p = FieldAddress(i);
      Len = FieldLen(i);
      if ((Len > MaxLen) && (FieldType(i) == 'C'))
        Len = MaxLen;
      // if the user has a data definition, ask for it now
      ClearDefinition(i);
      len = strlen(DD.Prompt);
      UsersAutoHelp = NULL;
      if (WorkArea[Selected]->DataDef) {
        SGFieldCode = i;
        WorkArea[Selected]->DataDef();
        if ((i == FirstField) && (MaxFields < FieldCount()))
          UsersAutoHelp = DD.AutoHelpPtr;
      }
      // if a row and column were not specified by the user, fill in those
      // field with the default values. If row and column were filled in,
      // adjust for coordinate systems
      if ((DD.Row == 0xFF) || (DD.Column == 0xFF)) {
        DD.Row = CurrentRow;
        if (Trim(DD.DBFAlias))
          ++CurrentRow;
        DD.Column = DbfEditBox.c1 + 2;
      }
      else
        if (!OldDbaseOrder) {
          --DD.Row;
          --DD.Column;
        }
      // the user may have specified a long prompt..we need to compute
      // how much of the edit window is available for the width of the field
      if ((DbfEditBox.c2 - DD.Column - len - 1) < Len)
        Len = DbfEditBox.c2 - DD.Column - len - 1;
      // by setting DBFAlias to the empty string, the user can ignore a field
      if (Trim(DD.DBFAlias)) {
        // split up the prompt and the get, so the user can specify different
        // colors, even when the process ends with a ClearGets
        At(DD.Row,DD.Column,DD.Prompt);
        Paint(DD.Row,DD.Column,len,DD.PromptForeGround,DD.PromptBackGround);
        SayGet(wherey() - 1,wherex(),"",p,t,Len,FieldDec(i));
        ++NumberOfSayGetFields;
        if (*DD.Picture)
          Picture(DD.Picture);
        if (*DD.LoRange && *DD.HiRange)
          Range(DD.LoRange,DD.HiRange);
        if (DD.Required)
          Required();
        if (DD.NoEdit)
          NoEdit();
        if (DD.BlankField)
          BlankField();
        SetValidateTo(DD.ValidatePtr);
        if ((i == FirstField) && (MaxFields < FieldCount()))
          SetAutoHelpTo(SetCursor);
        else
          SetAutoHelpTo(DD.AutoHelpPtr);
      }
    }
    if(!DBFEditNoStatus) {
      if (Deleted()) {
        At(DbfEditBox.r2,DeleteColumn," Del ");
        Paint(DbfEditBox.r2,DeleteColumn,5,gfg,gbg);
      }
      else {
        At(DbfEditBox.r2,DeleteColumn,Replicate(DBFEditLineChar,5));
        Paint(DbfEditBox.r2,DeleteColumn,5,sfg,sbg);
      }
    }
    if (!NumberOfSayGetFields)
      return; // user's data definition ignored every field!
    if (!DBFEditPlain)
      ReadGets();
    else
      ClearGets();
    if (EditResult > 0)
      return; // escape key pressed
    if (DBFEditPlain && DBFEditNoScroll)
      return;
    if (EditResult < 1)
      for (i = 1; i <= FieldCount(); i++)
        if (FieldType(i) == 'C') {
          p = FieldAddress(i);
        }
    // handle going to more fields, or previous fields
    if (NumberOfSayGetFields < MaxFields)
      return;
    if ((MaxFields < FieldCount())) { // handle scrolling fields in a window
      if ((EditResult == -2) && (LastKey != '\x05')) // Page Up
        FirstField -= MaxFields;
      if ((EditResult == -1) && (LastKey != '\x18')) // Page Down
        FirstField += MaxFields;
      if (LastKey == '\x05')
        --FirstField;  // Up Arrow
      // if (LastKey = ^X) ++FirstField; // Down Arrow
      if (!EditResult) { // exited last field with ^W, or filled
        // the last field, or press Enter, or pressed
        if (LastKey != '\x17') { // down arrow or pressed right arrow
          ++FirstField;
          LastKey = '\x18';
        }
        else
          FirstField = 0; // editresult=0 and lastkey is ^W
      }
    }
    else // fields do not fill window..no scrolling is necessary
      FirstField = 0; // signal to leave repeat loop
  }  while (!((FirstField < 1) || (FirstField > FieldCount())));
}
