/* filename: ZAP.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <errno.h>
#include <conio.h>
#include <io.h>
#include <string.h>
#include <ctype.h>
#ifdef WINDOWS
#include <windows.h>
#endif
#include <dbf.h>

void FlushAfterAppend(dbfRecord * d);
void SyncRelations(void);

void Zap(void)
{
  char control_z  = '\x1A';
  WorkAreaType *wa;
  dbfRecord    *r;
#ifdef WINDOWS
  char buf[STRSIZ];
#else
  char yesno[] = { "YyNn" };
  char answer;
#endif

  wa = WorkArea[Selected];
  r = &wa->Handle;
  DBFError = errno = 0;
  if (NotInUseError("Zap"))
    return;

#ifdef NET
  if (MultiUser && !wa->Exclusive) {
    SetError(5, 3, File_must_be_open_exclusive, r->FileName, " [ZAP]");
    return;
  }
#endif

  if (SafetyOn) {
    // ask for confirmation
#ifdef WINDOWS
    sprintf(buf, "ZAP %c", r->FileName);
    if (WDialogBox(buf,"",MB_OKCANCEL | MB_ICONQUESTION) == IDCANCEL)
      return;
#else
    printf("\nZAP %s%s", r->FileName, question_y_n);
    do {
      answer = getch();
    }  while (strchr(yesno, (char) answer) == NULL);
    if (toupper(answer) == 'N')
      return;
#endif
  }
  if (r->v.strue.LinkedList)  {
    r->v.strue.Action = doZapLL;
    LLRoutines(r);
    return;
  }
  if (lseek(r->v.dFile, r->HeadLen, SEEK_SET) != -1L) {
    write(r->v.dFile, &control_z, 1);
    chsize(r->v.dFile, r->HeadLen+1);
  }
  r->dStatus = Appended;
  DBFError = errno;
  if (DBFError) {
    SetError(DBFError,2, Error_zapping, r->FileName);
    return;
  }
  r->NumRecs = 0;
  FlushAfterAppend(r); // write the header data to file
  ClearRecord();
  r->BOFile = r->EOFile = TRUE;

  // Need to "zap" the memo file too
  if (r->HasMemo) {
    if (MemoRoutines._CloseMemoFile == NULL) {
      SetError(InvalidParameter, 4, Memo_unit_not_linked_into_program,
      " [ZAP ", r->FileName, "]");
      return;
    }
    MemoRoutines._CloseMemoFile();
    MemoRoutines._CreateMemoFile(r->FileName);
    MemoRoutines._OpenMemoFile(r->FileName);
  }
  // reindex any open indexes for this file
  if (IndexPresent)
    if (IndexRoutines.IndexOpenFunc())
      IndexRoutines.ReindexProc();
  SyncRelations();
}
