/* filename: USE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#ifdef _MSC_VER
#include <direct.h>
#else
#include <dir.h>
#endif
#include <string.h>
#include <sayget.h>
#include <dbf.h>

int  CheckSize(dbfRecord * d);
void CutSubstring(char * dest, char * substr);
int  DbfAlreadyInUse(char * x, char * procname);
void OpenLinkedList(char * name, char * buffer, unsigned size);
void CloseHighLevel(void);

void Use(const char * filename, void * buffer, unsigned size)
{ // does a GoTop to make sure that SetDeletedOn is observed
  char LocalAlias[11] = { 0 };
  dbfRecord LocalHandle, *r;
  DirStr dir;
  char Mfilename[STRSIZ];
  NameStr Name;
  ExtStr Ext;
  char *p;
  char  buf[80];
  WorkAreaType *wa;
  unsigned recsize;
#ifdef NET
  int LocalExclusive;
  unsigned SaveDbFileMode, savefilemode;
#endif

  if (!CheckRegisteredUnits("Use", REGTZCOMMON+REGTZDBF))
    return;
  strcpy(Mfilename, filename);
  DBFError = 0;
  CloseHighLevel();
  // exit if just closing the file and not opening a new one
  if (!*Mfilename)
    return;
  // prep the string parameter for parsing.
  sprintf(Mfilename,"%s ", Upper(Ltrim(Trim(Mfilename)))); // get rid of leading/trailing blanks
  while ((p = strstr(Mfilename, "  ")) != NULL)
    strcpy(p, p+1); // get rid of double spaces
  if (strstr(Mfilename,"LINKED LIST") || strstr(Mfilename,"VIRTUAL FILE")) {
    OpenLinkedList(Mfilename,(char *)buffer,size);
    return;
  }
  if ((!buffer && size) || (buffer && !size)) {
    SetError(InvalidParameter, 3,
    Buffer_is_NULL_or_Size_is_Zero_attempting_to_open, Mfilename, " [USE]");
    return;
  }
  // check for exclusive clause
#ifdef NET
  LocalExclusive = (strstr(Mfilename, " EXCLUSIVE") != NULL);
#endif
  // check for Alias Clause.
  p = strstr(Mfilename, " ALIAS ");
  if (p) {
    strncpy(LocalAlias, p+7, 10);
    LocalAlias[10] = 0;
    p = strchr(LocalAlias, ' ');
    if (p)
      *p = 0;
  }
  // get rid of any clauses from the filename string:
  p = strchr(Mfilename, ' ');
  if (p)
    *p = 0;
  memset(&LocalHandle, 0, sizeof(LocalHandle));
  // convert to fully expanded filename
  if (_fullpath(buf, Mfilename, sizeof(buf)))
    strcpy(LocalHandle.FileName, buf);
  else {
    SetError(220, 3, " [USE(", Mfilename, ", ...)]");
    return;
  }
  if (!*LocalAlias) {
    FSplit(Mfilename,dir,Name,Ext);
    strcpy(LocalAlias, Upper(Name));
  }
  // add extension if possible
  strcpy(LocalHandle.FileName, AddExt(LocalHandle.FileName,"DBF"));
  if (DbfAlreadyInUse(LocalHandle.FileName,"USE"))
    return;
#ifdef NET
  savefilemode = FileMode;
  SaveDbFileMode = DbfFileMode;
  if (DbfFileMode == NonSharableReadWrite)
    LocalExclusive = TRUE;
  // deny all other users
  FileMode = LocalExclusive ? NonSharableReadWrite : DbfFileMode;
  if (!MultiUser) {
    // if we are running on a single user system, fake the rest of the
    // code into opening everything EXCLUSIVE with good old filemode of 2
    LocalExclusive = TRUE;
    FileMode = DefaultReadWriteMode;
  }
#endif
  OpenDbf(&LocalHandle); // handles file-not-found errors
  LocalHandle.HighLevel = TRUE;
#ifdef NET
  DbfFileMode = SaveDbFileMode;
  FileMode = savefilemode;
#endif
  if (!DBFError) {
    if ((WorkArea[Selected] = (WorkAreaType *)malloc(sizeof(WorkAreaType))) == NULL)
      goto NOMEM;
    else
      memset(WorkArea[Selected], 0, sizeof(WorkAreaType));
    wa = WorkArea[Selected];
    r = &wa->Handle;
    memcpy(r, &LocalHandle, sizeof(dbfRecord));
    SetAliasTo(LocalAlias);
    r->v.strue.LinkedList = FALSE;
#ifdef NET
    wa->Exclusive = LocalExclusive;
#endif
    // check size of record after conversion to turbo var types
    recsize = CheckSize(r);
    if (!buffer) { // this getting is an "untyped" buffer for the user
      size = recsize;
      if ((p = malloc(recsize)) == NULL)
        goto NOMEM;
      wa->Deallocate = TRUE;
    }
    else
      p = buffer;
    wa->UserRec = p;
    if (recsize == size) {
      wa->UserRecSize = size;
      r->EncryptProc = UsersEncryptProc;
      r->DecryptProc = UsersDecryptProc;
      if (r->NumRecs > 0)
        GoTop(); // deals with set_deleted_on
      else { // empty dbf file, fill user record with zeros
        memset(p, 0, size);
        ClearRecord();
        r->BOFile = r->EOFile = TRUE;
      }
    }
    else {
      sprintf(Mfilename, "%s [Use()]\n Record Size = %d Buffer Size = %d",
      r->FileName, recsize, size);
      SetError(BadSize, 2, Database_record_buffer_size_mismatch, Mfilename);
      return;
    }
#ifdef NET
    if ((wa->SwapBuffer = malloc(wa->UserRecSize)) == NULL)
      goto NOMEM;
#endif
    if (r->HasMemo && MemoRoutines._OpenMemoFile)
      MemoRoutines._OpenMemoFile(LocalHandle.FileName);
  }
  return;

NOMEM:
  SetError(InsufficientMemory, 3, "[USE(", Mfilename, ",<&Buffer>,<size>)]");
}

void UseEncrypted(const char * filename, void * buffer, unsigned size,
                  void (*EncryptProc)(char * rec, unsigned len),
                  void (*DecryptProc)(char * rec, unsigned len))
{
  UsersEncryptProc = EncryptProc;
  UsersDecryptProc = DecryptProc;
  Use(filename, buffer, size);
  UsersEncryptProc = 0;
  UsersDecryptProc = 0;
}
