/* filename: SKIP.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dbf.h>

#define ON  TRUE
#define OFF FALSE

extern long (*UsersSkipFunc)(long v, int i);

void CheckActualRecCount(void);
void SyncRelations(void);
void ExportData(void);
int  ValidRec(void);

void Skip(long n)
{
  long newrecno, saverecno, x;
  int indexisopen, edgeoffile;
  int InWhileRange;
  long LastValidRecNo;
  WorkAreaType *wa;
  dbfRecord    *r;

  wa = WorkArea[Selected];
  r = &wa->Handle;
  DBFError = 0;
  if (NotInUseError("Skip"))
    return;

  if (!n) { // skip(0) is OK on an empty database
    if ((r->NumRecs > 0) && !r->EOFile) {
      GetDbfRecord(r, r->CurRecNo); // now re-reads for network access
      if (!DBFError)
        ExportData();
      else
        return;
    }
    else
      ClearRecord(); // refresh the buffer
    goto sync;  // skip zero used to sync up related databases
  }
  if (r->EOFile && (n > 0)) {
    SetError(OutOfRange,4,Database_quote,DBF(),Past_EOF," [Skip]");
    return;
  }
  if (!r->NumRecs) { // deal with an empty database
    r->BOFile = TRUE;
    r->EOFile = TRUE;
    SetError(OutOfRange,4,Database_quote,DBF(),is_empty," [Skip]");
    return;
  }
  if (r->BOFile && (n < 0))
    return;
  r->BOFile = r->EOFile = FALSE;
  newrecno = r->CurRecNo;
  // determine if an index is open
  indexisopen = IndexPresent ? IndexRoutines.IndexOpenFunc() : FALSE;
#ifdef NET
  if (indexisopen)
    IndexRoutines.SetReadSemaphoreProc(ON);
#endif

  // step through the index until the number of
  // records skipped is the same as the number requested
  x = 0; // record counter
  edgeoffile = FALSE;
  InWhileRange = TRUE;
  if (UsersSkipFunc == NULL) {
    do {
      if (n > 0) { // forward skipping
        if (indexisopen) {
          saverecno = newrecno;
          newrecno = IndexRoutines.FindNextRecFunc();
          if (newrecno == saverecno)
            edgeoffile = TRUE;
        }
        else {
          newrecno = r->CurRecNo+1;
#ifdef NET
          CheckActualRecCount();
#endif
          if (newrecno > r->NumRecs) {
            edgeoffile = TRUE;
            newrecno = r->NumRecs;
          }
        }
        GetDbfRecord(r,newrecno);
        if (!DBFError)
          ExportData();
        else {
#ifdef NET
          if (indexisopen)
            IndexRoutines.SetReadSemaphoreProc(OFF);
#endif
          return;
        }
        if (ValidRec())
          ++x; // increment record counter
      }
      else { // backward skipping
        if (ValidRec())
          LastValidRecNo = r->CurRecNo;
        if (indexisopen) {
          saverecno = newrecno;
          newrecno = IndexRoutines.FindPriorRecFunc();
          if (newrecno == saverecno)
            edgeoffile = TRUE;
        }
        else {
          newrecno = r->CurRecNo-1;
          if (!newrecno) {
            edgeoffile = TRUE;
            newrecno = 1;
          }
        }
        GetDbfRecord(r,newrecno);
        if (!DBFError)
          ExportData();
        else {
#ifdef NET

          if (indexisopen) // clear the semaphore before exiting
            IndexRoutines.SetReadSemaphoreProc(OFF);
#endif
          return;
        }
        if (ValidRec())
          --x;
      }
      // a record has been read in. if there is a WHILE function, determine
      // if we are still in the WHILE range.
      if (wa->WhileFunc)
        InWhileRange = wa->WhileFunc();
      if (wa->WhileExprHandle) {
        if (ParserRoutines.EvaluateFunc) 
          InWhileRange = *(BOOL *)ParserRoutines.EvaluateFunc(wa->WhileExprHandle);
        else
          SetError(254, 1, " [Skip]");  // this should not ever happen
      }
    }  while (!((x == n) || edgeoffile || (!InWhileRange)));
  }
  else { // if there is a users SKIP function instead
    newrecno = UsersSkipFunc(n,edgeoffile);
    GetDbfRecord(r, newrecno);
    if (!DBFError)
      ExportData();
    else {
#ifdef NET
      if (indexisopen) // clear the semaphore before exiting
        IndexRoutines.SetReadSemaphoreProc(OFF);
#endif
      return;
    }
  }
  if (edgeoffile) {
    if (n > 0) { // going forward
      // set record number to one past eof and export blanks to userrec
      r->CurRecNo = r->NumRecs+1;
      r->EOFile = TRUE;
      ClearRecord(); // show a blank record when at end-of-file
      if (indexisopen) {
        IndexRoutines.SyncIndexProc();
      }
    }
    if (n < 0) { // going backwards
      GoTop();
      r->BOFile = TRUE;
      // set the index bof flag to TRUE
      if (indexisopen)
        IndexRoutines.SetBofFlagProc();
    }
  }
  // if we skipped past the WHILE range, we want to set EOF or BOF, but
  // we dont't want to change the current record we are on.
  if (!InWhileRange) {
    if (n > 0) {
      r->EOFile = TRUE;
      if (indexisopen)
        IndexRoutines.SetEofFlagProc();
    }

    if (n < 0) { //set BOF TRUE, but go back to the last ok record
      GetDbfRecord(r, LastValidRecNo);
      if (!DBFError) {
        ExportData();
        r->BOFile = TRUE;
        if (indexisopen) {
          IndexRoutines.SyncIndexProc();
          IndexRoutines.SetBofFlagProc();
        }
      }
      else {
#ifdef NET  //  clear the semaphore before exiting
        if (indexisopen)
          IndexRoutines.SetReadSemaphoreProc(OFF);
#endif
        return;
      }
    }
  }
#ifdef NET
  if (indexisopen)
    IndexRoutines.SetReadSemaphoreProc(OFF);
#endif
  if (indexisopen)
    IndexRoutines.StoreCurrentKeys();
sync:
  SyncRelations();
}
