/* filename: SETWHIL2.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <parser.h>
#include <dbf.h>

void SetWhileToCB(int (* UsersWhilePtr)(void))
{
  WorkAreaType *wa;
  dbfRecord    *r;

  wa = WorkArea[Selected];
  r = &wa->Handle;
  if (NotInUseError("SetWhileToCB"))
    return;
  if (wa->WhileFunc && !UsersWhilePtr) {
    wa->WhileFunc = NULL;
    r->EOFile = (r->CurRecNo > r->NumRecs);
    r->BOFile = FALSE;
    if (IndexPresent && IndexRoutines.IndexOpenFunc())
      IndexRoutines.SyncIndexProc();
  }
  wa->WhileFunc = UsersWhilePtr;

  // cannot call DisposeExpr directly here...
  if (ParserRoutines.DisposeExprProc)
    ParserRoutines.DisposeExprProc(&wa->WhileExprHandle);
}

static void CleanUp(WorkAreaType *wa)
{
  dbfRecord *r = &wa->Handle;

  wa->WhileFunc = NULL;
  r->EOFile = (r->CurRecNo > r->NumRecs);
  r->BOFile = FALSE;
  if (IndexPresent && IndexRoutines.IndexOpenFunc())
      IndexRoutines.SyncIndexProc();
}

void SetWhileTo(const char *expr)
{
  WorkAreaType *wa;
  int          ErrorID=0;

  if (!CheckRegisteredUnits("SetWhileTo", REGTZCOMMON+REGTZDBF+REGTZPARSER))
    return;

  wa = WorkArea[Selected];
  if (NotInUseError("SetWhileTo"))
    return;

  if (!expr) { // if expr is NULL, we want to turn off the "while" condition
      DisposeExpr((ExprHandle *)(&wa->WhileExprHandle));
      CleanUp(wa);
      return;
  }

  if (!*Trim(expr)) { // if expr is empty, we want to turn off the "while" condition
    DisposeExpr((ExprHandle *)(&wa->WhileExprHandle));
    CleanUp(wa);
    return;
  }

  // to get here, a filter expression has been specified
  wa->WhileExprHandle = (void *) AssignExpr(expr);
  if (wa->WhileExprHandle) { // check if AssignExpr() failed
    // we have a good expression, but it must be logical for a "while" condition
    if (((ExprHandle)(wa->WhileExprHandle))->ReturnType == 'L')
      wa->WhileFunc = NULL;
    else
      ErrorID = NotLogicalExpr;
  }
  else
    ErrorID = ErrorInDBaseExpression;

  if (ErrorID)
    SetError(ErrorID,3," [SetWhileTo(", expr, ")]");
}
