/* filename: SEARCH.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <string.h>
#ifdef _MSC_VER
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <stdlib.h>
#ifdef WINDOWS
#include <windows.h>
#endif
#include <sayget.h>
#include <dbf.h>

extern void (*ScanRoutine)(void);

int ValidRec(void);
int PosOf(int n, const char *s2, const char *s1);
unsigned pascal BlkSearch(void far *pattern, void far *target,
unsigned Plen, unsigned Tlen);

void Search(const char *s, int *fieldno, BOOL startattop)
{
  int  count, lastspace, thisspace, largestlen;
  long buffersize, offsetofdata, foundrec, lastpos, originalrec;
  long BytesToScan, PosInFile;
  char LongestWord[STRSIZ], tmp_s[STRSIZ], TempString[STRSIZ], *buffer;
  int  ExitOK, LWlength, slength, i, targetfield;
  dbfRecord *h;
  unsigned WordOffset = 0;
  unsigned BytesRead, BytesToSearch, BufferOffset, found, offset;
#ifndef WINDOWS
  char c;

  LastKey = 0;
#endif
  h = &WorkArea[Selected]->Handle;
  strcpy(tmp_s, Upper(s));
  targetfield = *fieldno;
  *fieldno = 0;
  if (NotInUseError("Search"))
    return;
  if (h->v.strue.LinkedList) {
    SetError(InvalidLLOperation, 2,
    Operation_cannot_be_used_on_virtual_files, " [Search]");
    return;
  }
  if (!*Trim(tmp_s))
    return;
  if (targetfield > FieldCount())
    targetfield = 0;
  // determine if there is enough memory
#ifdef WINDOWS
  buffersize = (long) GetFreeSpace(0);
#else
  buffersize = (long) coreleft();
#endif
  if (ScanRoutine)
    buffersize /= 2;
  // always leave 1/2 of the remaining heap for the scan routine
  // size buffer to maximum buffer size (MSC 7.0)
  if (buffersize > 0xFFE8)
    buffersize = 0xFFE8;
  if (buffersize < 0x1000)
    goto Errors;
  // make buffer fit the record size of file
  // but what about the file size...if its less than 64K (or whatever
  // BufferSize is, we really don't need to getmem that much
  BytesToScan = h->RecLen * h->NumRecs;
  if (!startattop) // subtract the size of file above us
    BytesToScan -= (h->RecLen * h->CurRecNo);
  if (buffersize > BytesToScan) // don't getmem bigger than data
    buffersize = BytesToScan;
  // if we were on the last record, or past EOF, BufferSize is now Zero
  // or less. So nothing to search
  if (buffersize <= 0)
    return;
  buffersize -= (buffersize % h->RecLen);
  if ((buffer = (char *)malloc((size_t) buffersize)) == NULL)
    goto Errors;
  // start just past the header
  // or go to one record past current record
  lseek(h->v.dFile, h->HeadLen + (startattop ? 0: h->CurRecNo*h->RecLen), SEEK_SET);
  found = BytesToSearch = 0;
  BufferOffset = 1;
  ExitSearch = FALSE;
  originalrec = h->CurRecNo;
  PosInFile = 0;

  // now get the biggest word in the search string
  strcpy(LongestWord, Trim(tmp_s));
  if (strchr(tmp_s, ' ') != NULL) {
    strcat(LongestWord, " ");
    count = lastspace = largestlen = 0;

    for (i = 0; i < (int) strlen(LongestWord); i++) {
      if (LongestWord[i] == ' ')
        ++count;
    }
    for (i = 1; i <= count; i++) {
      thisspace = PosOf(i, " ", LongestWord);
      if ((thisspace - lastspace) > largestlen) {
        largestlen = thisspace - lastspace;
        WordOffset = lastspace;
      }
      lastspace = thisspace + 1;
    }
    strncpy(LongestWord, LongestWord + WordOffset, largestlen);
    LongestWord[largestlen] = 0;
  }
  LWlength = strlen(LongestWord);
  slength = strlen(tmp_s);

  do {
    do {
      ExitOK = TRUE;
#ifndef WINDOWS
      // check for <Esc> pressed
      if (EscapeEnabled) {
        if (KeyPressed()) {
          c = getch();
          if (c == '\x1B') { // escape was pressed
            *fieldno = 0;
            LastKey = '\x1B';
            goto Bailout;
          }
          else {
            while (KeyPressed())
              getch(); // clear the keyboard
          }
        }
      }
      AdvanceRotor();
#endif
      if (!found) {
        lastpos = tell(h->v.dFile);
        if (lastpos < PosInFile) {
          lseek(h->v.dFile, PosInFile, SEEK_SET);
          lastpos = PosInFile;
        }
        BytesRead = read(h->v.dFile, buffer, (unsigned) buffersize);
        PosInFile = tell(h->v.dFile);
        BytesToSearch = BytesRead;
        BufferOffset = 1;
      }
      else {
        // we found it but in wrong field
        lastpos += (LWlength - 1);
        BufferOffset += (found + LWlength - 1);
        BytesToSearch = BytesRead - BufferOffset + 1;
      }
      found = BlkSearch((char far *) LongestWord, (char far *) &buffer[BufferOffset],
      LWlength, BytesToSearch);
      offset = BufferOffset + found - WordOffset;
      if ((found > 0) && (LWlength != slength)) {
        // we didn't look for a sub-set of the search string
        if (found >= WordOffset) {
          memcpy(TempString, &buffer[offset-1], slength);
          TempString[slength] = 0;
          if (strcmp(Upper(TempString), tmp_s)) {
            lastpos += found;
            ExitOK = FALSE;
          }
          else {
            // we have a match...
            // determine if the string we found bridges a record boundary
            if ((offset/h->RecLen) != ((offset+slength)/h->RecLen)) {
              lastpos += found;
              ExitOK = FALSE;
            }
          }
        }
      }
    }  while (!((ExitOK && (found > 0)) || (BytesToSearch == 0)));
    lastpos += found;
    if (!found) {
      if (originalrec <= RecCount())
        Go(originalrec);
    }
    else {
      foundrec = ((lastpos - h->HeadLen) / h->RecLen) + 1;
      if (foundrec > h->NumRecs) {
        *fieldno = 0;
        goto Bailout;
      }
      else
        Go(foundrec); // THE record
      if (DBFError)
        goto Bailout;
      if (ValidRec()) {
        //  check to see if the record we found fits the
        // filter or the deleted status
        // now calculate the field number where the data was found
        offsetofdata = ((lastpos - h->HeadLen) % h->RecLen);
        for (i = 0; i < h->NumFields; ++i)
          if (h->Fields[i+1].Off > (unsigned) offsetofdata)
            break;
        if (((unsigned)(offsetofdata+slength) > (h->Fields[i].Off+h->Fields[i].Len)) ||
          ((targetfield > 0) && (targetfield != i+1)) ||
          (FieldType(i+1) == 'M'))
          // Who needs a MEMO hit ?!
          *fieldno = 0;
        else {
          *fieldno = i+1;
          if (ScanRoutine) {
            ScanRoutine();
            if (!ExitSearch)
              *fieldno = 0;
          }
        }
      }
    }
  }  while (!(!found || (*fieldno > 0) || ExitSearch));

Bailout:
  free(buffer);
  return;

Errors:
  SetError(217, 1, " [Search]");
  return;
}
