/* filename: REPLACE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <dbf.h>

#define ON  TRUE
#define OFF FALSE

void SyncRelations(void);
void ImportData(void);
void ExportData(void);

static char funcname[] = { " [Replace]" };

void Replace(void)
{
  int indexopen, error = OutOfRange;
  WorkAreaType *wa;
  dbfRecord    *r;
  char *errptr;

  DBFError = 0;
  if (NotInUseError(funcname))
    return;
  wa = WorkArea[Selected];
  r = &wa->Handle;
  if ((r->CurRecNo > 0)) {
    if (r->CurRecNo <= r->NumRecs) {
      indexopen = IndexPresent ? IndexRoutines.IndexOpenFunc() : FALSE;
#ifdef NET
      if (!wa->Exclusive && (wa->LockStatus != FileLocked)) {
        if (!IsLocked(wa->LockList, r->CurRecNo)) {
          error = RecordNotLocked;
          errptr = "";
          goto bailout;
        }
      }
      if (indexopen && !r->v.strue.LinkedList) {
        /*  first we must move the contents of the userrec into a buffer.
        Then call a special getrec routine and put the data from the current
        record into the userrec. Now we can call the syncindex routine. Once
        the index is synced up on the current record, we can swap the
        buffered userrec contents back and do the replace normally.  */
        if (!wa->SwapBuffer) {
          error = 254;
          errptr = Swap_buffer_NIL;
          goto bailout;
        }
        // wait for index to be locked before updating file on disk
        IndexRoutines.SetLockSemaphoreProc(ON);
        memcpy(wa->SwapBuffer,wa->UserRec,wa->UserRecSize);
        GetDbfRecord(r, r->CurRecNo);
        if (!DBFError) // move data to users record structure
          ExportData();
        else
          return;
        SyncAll = TRUE;
        IndexRoutines.SyncIndexProc();
        SyncAll = FALSE;
        IndexRoutines.StoreCurrentKeys();
        memcpy(wa->UserRec,wa->SwapBuffer,wa->UserRecSize);
      }
#endif
      ImportData(); // move (with padding) users data into our buffer
      PutDbfRecord(r, r->CurRecNo);
      ExportData(); // insures that data in users buffer is padded
      if (indexopen) { // update any index(s) if open
        // update any indexes and store the new keys
        IndexRoutines.CompareKeys();
#ifndef NET  // don't bother if we are on a network
        IndexRoutines.StoreCurrentKeys();
#else
        // unlock the index after it has been updated
        IndexRoutines.SetLockSemaphoreProc(OFF);
#endif
      }
    }
    else { // error is OutOfRange by default
      errptr = is_at_eof;
      goto bailout;
    }
  }
  else {
    errptr = is_empty;
    goto bailout;
  }
  if (DBFError && AutoHalt)
    OnErrorHalt();
  SyncRelations();
  return;

bailout:
  SetError(error, 4, Database_quote, DBF(), errptr, funcname);
  return;
}
