/* filename: OPENLLST.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dbf.h>

int DbfAlreadyInUse(char * x, char * procname);

void CutSubstring(char * s, char * target)
{
  char *p;

  p = strstr(s, target);
  if (p)
    strcpy(p, p + strlen(target));
}

static void Find_Strip(char *name, char * s, int flag, int type)
{
  if (strstr(name, s)) {
    if (flag)
      WorkArea[Selected]->Handle.v.strue.LStatus = (LStatusType) type;
    else
      WorkArea[Selected]->Handle.v.strue.DataLoc = (DataStorageType) type;
    CutSubstring(name, s);
  }
}

void OpenLinkedList(char * name, char * buffer, unsigned size)
{
  char mname[STRSIZ], buf[STRSIZ], *p;
  char mAlias[11];
  int i;
  WorkAreaType *wa;
  dbfRecord        *h;

  if (!CheckRegisteredUnits("OpenLinkedList", REGTZCOMMON+REGTZDBF))
    return;

  if (LLRoutines == NULL) {
    SetError(LLUnitNotThere, 3, "[USE(", name, ",<@Buffer>,<size>)]");
    return;
  }
  if (buffer == NULL) {
    SetError(InvalidParameter, 3, "NULL buffer pointer [USE(",
    name, ", NULL, <size>)]");
    return;
  }
  // strip off the LINKED LIST or VIRTUAL FILE clause
  CutSubstring(name," LINKED LIST");
  CutSubstring(name," VIRTUAL FILE");
  strcpy(mname,name);
  if (DbfAlreadyInUse(mname,"USE"))
    return;
  // now establish the alias
  p = strstr(name, " ALIAS ");
  if (p) {
    strncpy(mAlias, p + 7, 10);
    mAlias[10] = 0;
    p = strchr(mAlias, ' ');
    if (p)
      *p = 0;
  }
  else {
    strcpy(buf,name);
    if ((p = strchr(buf, ' ')) != NULL)
      *p = 0;
    if ((p = strchr(buf, '.')) != NULL)
      *p = 0;
    buf[10] = 0;
    strcpy(mAlias, buf);
  }
  // what if alias is already in use?
  for (i = 0; i < MaxWorkAreas; i++) {
    if ((i != Selected) && WorkArea[i] &&
    (!strcmp(WorkArea[i]->Alias, mAlias))) {
      SetError(InvalidParameter, 4, Alias_name_quote, mAlias,
      already_in_use, " [USE]");
      return;
    }
  }
  memset(buffer, 0, size); // initialize UserRec to zeros
  if ((WorkArea[Selected] = (WorkAreaType *)malloc(sizeof(WorkAreaType))) == NULL) {
    SetError(InsufficientMemory, 3, "[USE(", name, ",<@Buffer>,<size>)]");
    return;
  }
  wa = WorkArea[Selected];
  h = &wa->Handle;
  memset(wa, 0, sizeof(WorkAreaType));
  strcpy(h->FileName, mname);
  strcpy(wa->Alias, mAlias);
  h->v.strue.LinkedList = TRUE;
  h->RecLen = size;
  h->BOFile = TRUE;
  h->EOFile = TRUE;
  wa->UserRec = buffer;
  wa->UserRecSize = size;
  h->CurRecord = (char *) buffer;
  h->v.strue.Action = doOpenLL;
  h->NumFields = 0;
  h->Fields = NULL;
  h->v.strue.DataLoc = Heap;
  Find_Strip(name, " TO EMS", 0, Ems);
  Find_Strip(name, " TO EXT", 0, Ext);
  Find_Strip(name, " TO XMS", 0, Ext);
  Find_Strip(name, " TO HEAP", 0, Heap);
  Find_Strip(name, " TO BIGGEST", 0, Biggest);
  LLRoutines(h);
  Find_Strip(name, " FIFO", 1, FIFO);
  Find_Strip(name, " LIFO", 1, LIFO);
  Find_Strip(name, " INSERTION", 1, INSERTION);
  Find_Strip(name, " ASCENDING", 1, ASCENDING);
  Find_Strip(name, " DESCENDING", 1, DESCENDING);
  strcpy(wa->Handle.FileName, name);
#ifdef NET
  wa->Exclusive = TRUE;
#endif
}
