/* filename: LIST.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <sayget.h>
#include <dbf.h>
#include <tzprint.h>
  
static char nl[2] = { "\n" };
  
#ifndef WINDOWS
  
static int EscKeyPressed(void)
{
  if (!KeyPressed())
    return FALSE;
  return (getch() == '\x1B');
}
  
#endif
  
void List(const char * str)
// current clauses:  OFF, PLAIN, NEXT <n>
// future clauses:  TO PRINT, PAUSE, CLIP, FIELDS
{
  int OffFlag, i;
  char *ptr, Command[STRSIZ];
  long NextNo;
#ifndef WINDOWS
  int SaveConsoleOn = ConsoleOn;
#endif
  
  // some error checking:
  if (!*DBF())
    return;
  if (!RecCount())
    return;
  // parse out clauses
  sprintf(Command," %s ", Upper(Ltrim(Trim(str))));
  OffFlag = (strstr(Command, " OFF ") != NULL);
  // The following clause is reserved for future use
  // Plain = (strstr(Command, " PLAIN ") != NULL);
  ptr = strstr(Command, " NEXT ");
  NextNo = ptr ? atol(ptr + 6) : 0x7FFFFFFFL;
  
#ifndef WINDOWS
  if (!ConsoleOn && !PrintOn && !AlternateOn)
    ConsoleOn = TRUE;
#endif
  
  WriteToAlt(nl);
  while (!dEOF() && (NextNo > 0)) {
    if (!OffFlag)
      WriteToAlt("%6ld ", RecNo());
    if (Deleted())
      WriteToAlt("* ");
    else
      WriteToAlt("  ");
    for (i = 1; i <= FieldCount(); i++)
      WriteToAlt("%s ", SField(i));
    WriteToAlt(nl);
#ifndef WINDOWS
    if (EscapeEnabled && EscKeyPressed())
      break;
#endif
    if (--NextNo > 0)
      Skip(1);
  }
#ifndef WINDOWS
  ConsoleOn = SaveConsoleOn;
#endif
}
