/* filename: IMPDATA.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <dbf.h>

void ImportData(void) // get data from Userrec and put in CurRecord
{
  void * address;
  char S[31]; // this should accomodate 30 digit numbers
  char tmp[22], *cur_field, tmp1[4];
  int n, flen, i;
  dbfRecord     *h;
  WorkAreaType *wa;
  FieldRecord  *f;

  wa = WorkArea[Selected];
  h =  &wa->Handle;

  if (h->v.strue.LinkedList)
    return;
  address = wa->UserRec;
  h->CurRecord[0] = (*((int *) address)) ? '*' : ' '; // deleted flag
  ++((int *) address);
  for (i = 0; i < h->NumFields; i++) {
    f = &h->Fields[i];
    cur_field = &h->CurRecord[f->Off];
    flen = (int) f->Len;
    switch (f->Typ) {
      case 'C': // move contents of string field to field
        n = strlen((char *) address);
        memset(cur_field, ' ', flen);
        if (n > 0) { // don't move garbage bytes
          if (n > (int) flen)
            n = flen;
          memcpy(cur_field, address, n);
        }
        (char *) address += (flen + 1);
        break;
      case 'D': // convert SayGet date var to dBASE Date field
        n = CenturyOn ? 4 : 2;
        if ((*(char *)address == 0) ||
          ((*(int*)address == 0x2020) &&
          (*(int*)((char*)address + 3) == 0x2020) &&
          (*(int*)((char*)address + 6) == 0x2020)))
          memcpy(cur_field, "        ", 8);
        else {
          // converting to the dbase ANSI-like format of yyyymmdd depends
          // on the what the current date format is set to: gbr
          if (CenturyOn)
            *(long*) tmp = *(long*) ((char *)address +
            ((DateFormat != Ansi) ? 6 : 0));
          else
            *(int*) tmp = *(int*) ((char *)address +
            ((DateFormat != Ansi) ? 6 : 0));
          switch (DateFormat) {
            case American:
              *((int*) (tmp+n)) = * (int*) address;
              *((int*) (tmp+n+2)) = * ((int*) ((char *)address+3));
              break;
            case Ansi:
              *((int*) (tmp+n)) = *((int*) ((char *)address+n+1));
              *((int*) (tmp+n+2)) = *((int*) ((char *)address+n+4));
              break;
            default:
              *((int*) (tmp+n)) = *((int*) ((char *)address+3));
              *((int*) (tmp+n+2)) = * (int*) address;
          }
          tmp[n+4] = 0;
          if (!CenturyOn) {
            * ((int *) tmp1) = * ((int *) tmp);
            tmp1[2] = 0;
            * ((int *) cur_field) = * ((int *) DefaultCentury(tmp1));
            memcpy(cur_field+2, tmp, 6);
          }
          else
            memcpy(cur_field, tmp, 8);
        }
        (char*) address  += 11;
        break;
      case 'L': // convert Boolean to dBASE Logical
        *cur_field = (*((int *) address)) ? 'T' : 'F';
        ++((int *) address);
        break;
      case 'N':
      case 'F':
        if (f->Dec > 0) {
          sprintf(S, "%*.*f", flen, f->Dec, *((double *) address));
          ++((double *) address);
        }
        else { // no decimals, so it must be an int
          sprintf(S, "%*ld", flen, *((long *) address));
          ++((long *) address);
        }
        if (strlen(S) > (size_t) flen) // overflow!
          memset(cur_field, '*', flen);
        else
          memcpy(cur_field, S, flen);
        break;
      case 'M':
        sprintf(S, "%*ld", flen, *((long *) address));
        memcpy(cur_field, S, flen);
        ++((long *) address);
        break;
    }
  }
}
