/* filename: ERASEFIL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#ifdef _MSC_VER
#include <direct.h>
#else
#include <dir.h>
#endif
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include <dbf.h>

typedef struct FailedRec {
#ifdef _MSC_VER
  struct _find_t s;
#else
  struct ffblk s;
#endif
  struct FailedRec * NextPtr;
} FailedRec;

static struct FailedRec *  FailedHead  = NULL;


void * NotErased(void)
// repeated calls return void * to info on files that did not erase, NULL if done
{
  if (FailedHead) {
    free(FailedHead);
    FailedHead = FailedHead->NextPtr;
  }
  return FailedHead;
}

void EraseFile(const char * FileName)
{
#ifdef _MSC_VER
  struct _find_t s;
#else
  struct ffblk s;
#endif
  struct FailedRec * NextLink;
  char SFailed[STRSIZ];
  struct FailedRec *  Failed;
  unsigned FilesErased;
  unsigned FilesFailed;


  if (FailedHead) {
    NextLink = FailedHead->NextPtr;
    do {
      free(FailedHead);
      FailedHead = NextLink;
    }  while (FailedHead);
  }
  if (strchr(FileName, '*') || strchr(FileName, '?')) {
    // deal with wildcard situation, initialize some vars
    FilesErased = 0;
    FilesFailed = 0;
    // find first occurance of name + extension
#ifdef _MSC_VER
    _dos_findfirst(FileName, FA_ARCH, &s);
#else
    findfirst(FileName, &s, FA_ARCH); // 0 attribute means normal files only,
    // r/o, hidden, system, volumeid, and directories will be ignored
#endif
    while (!errno) {
#ifdef _MSC_VER
      unlink(s.name);
#else
      unlink(s.ff_name);
#endif
      DBFError = errno;
      if (!DBFError)
        ++FilesErased;
      else {
        ++FilesFailed;
        // attached a link to the head of the list..it's easiest that way
        if ((Failed = (FailedRec *)malloc(sizeof(*Failed))) != NULL) {
          Failed->NextPtr = FailedHead;
          memcpy(&Failed->s, &s, sizeof(s));
          FailedHead = Failed;
        }
        DBFError = 0;
      }
#ifdef _MSC_VER
      _dos_findnext(&s);
#else
      findnext(&s);
#endif
    }
    if (DBFError) {
      SetError(DBFError, 3, " [EraseFile(", FileName, ")]");
      return;
    }
    if (FilesFailed > 0) {
      itoa(FilesFailed, SFailed, 10);
      SetError(5, 4, Could_not_erase, SFailed, files_like, FileName);
    }
  }
  else {
    DBFError = 0;
    if (unlink(FileName))
      SetError(errno, 2, Error_erasing, FileName);
  }
}
