/* filename: DELREC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dbf.h>

#define RECALL 0
#define DELETE 1

void CheckActualRecCount(void);
void PutDbfField(dbfRecord * d, long RecNum, char FieldNo);

static char delfname[] = { "[DeleteRec]" };
static char recfname[] = { "[RecallRec]" };

static void setflag(int flag)
{
  WorkAreaType *wa;
  dbfRecord *r;
  char *func;

  DBFError = 0;
  func = flag ? delfname : recfname;
  if (NotInUseError(func))
    return;
  wa = WorkArea[Selected];
  r = &wa->Handle;

#ifdef NET
  if (!wa->Exclusive && (wa->LockStatus != FileLocked)) { // test to see that record or file is locked
    if ((wa->LockStatus == AppendLocked) ||
    !IsLocked(wa->LockList, r->CurRecNo)) {
      SetError(RecordNotLocked, 2, Record_not_locked, func);
      return;
    }
  }
  if (flag == RECALL)
    CheckActualRecCount(); // because we reference numrecs
#endif

  if ((r->CurRecNo > 0) && (r->CurRecNo < (r->NumRecs+1))) {
    if (r->v.strue.LinkedList) {
      r->v.strue.Action = (flag ? doDeleteLL : doRecallLL);
      LLRoutines(r);
    }
    else {
      *((char *) wa->UserRec) = flag; // put it in the user's record
      r->CurRecord[0] = (flag ? 0x2A : 0x20); // set deleted flag
      PutDbfField(r, r->CurRecNo, 0); // write deleted flag to disk
      // field 0 = deleted flag byte
    }
  }
}

void DeleteRec(void)
{
  setflag(DELETE);
}

void RecallRec(void)
{
  setflag(RECALL);
}
