/* filename: DBF4LOW3.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dbf.h>

void UpdateHeader(dbfRecord * d);

int CheckSize(dbfRecord * d)
{
  int total, i;
  FieldRecord *f;

  total = 2; // all records have a deleted flag, in user's record
             // it MUST be declared as int !
  for (i = 0; i < d->NumFields; i++) {
    f = &d->Fields[i];
    switch (f->Typ) {
      case 'C':
        total += f->Len + 1;
        break;
      case 'D':
        total += 11;
        break;
      case 'N':
      case 'F':
        total += (f->Dec > 0) ? sizeof(double) : sizeof(long);
        break;
      case 'M':
        total += sizeof(long); 
        break;
      case 'L':
        total += 2; // user MUST declare a logical var as int !
        break;
    }
  }
  return total;
}

BOOL NotInUseError(const char *FuncName)
{
  char S[6]; // 32767

  if (WorkArea[Selected]) 
    return FALSE;
  itoa(Selected, S, 10);
  SetError(NotInUse, 5, No_database_in_use, " [", FuncName, "]  WorkArea = ", S);
  return TRUE;
}

void ExportData(void) // export data from dbfrecord to users rec
{
  void * address;
  char S[21], ch;
  int n, i;
  WorkAreaType *wa;
  dbfRecord*h;
  FieldRecord *f;

  wa = WorkArea[Selected];
  h = &wa->Handle;

  if (h->v.strue.LinkedList)
    return;
  address = wa->UserRec;
  *(int *) address = (*h->CurRecord == '*');
  ++((int *) address); // advance the pointer
  f = &h->Fields[0];
  for (i = 0; i < h->NumFields; i++, f++) {
    switch (f->Typ) {
      case 'C': // character field -- convert to string
        memcpy(address, &h->CurRecord[f->Off], f->Len);
        *((char*) address + f->Len) = 0;
        (char*) address += (f->Len + 1);
        break;
      case 'D': // date field -- convert to string[10]
        memcpy(S, &h->CurRecord[f->Off], 8);
        // dates are stored in dbase files in ANSI form: yyyymmdd, we need to
        // convert it to whatever the current date format that is in effect:
        n = CenturyOn ? 4 : 2;
      switch (DateFormat) {
        case American:
          *((int*) address) = *((int*) (S + 4));
          *((int*) ((char*) address +3)) = *((int*) (S + 6));
          break;
        case Ansi:
          *((int*) ((char*) address + n + 1)) = *((int*) (S + 4));
          *((int*) ((char*) address + n + 4)) = *((int*) (S + 6));
          break;
        default:
          *(int*) address = *((int*) (S + 6));
          *((int*) ((char*) address + 3)) = *((int*) (S + 4));
      }
      switch (DateFormat) { // define a delimiter...
        case Italian:
          ch = '-';
          break;
        case Ansi:
        case French:
        case German:
        case Spanish:
          ch = '.';
          break;
        default:
          ch = '/';
          break;
      }
        if (CenturyOn) // now copy a year
          *((long*) ((char*) address + ((DateFormat == Ansi) ? 0 : 6))) =
          *((long*)(S + 4 - n));
        else
          *((int*) ((char*) address + ((DateFormat == Ansi) ? 0 : 6))) =
          *((int*) (S + 4 - n));
        *((char*) address + n + 6) = 0;
        if (DateFormat != Ansi)
          n = 2;//for non-Ansi case delimiters are always at pos.2 and 5
        *((char*) address+n) = *((char*) address+n+3) = ch;
        (char*) address += 11;
        break;
      case 'L':
      switch (h->CurRecord[f->Off]) {
        case  'Y':  case  'y':
        case  'T':  case  't':
          n = TRUE;
          break;
        default:
          n = FALSE;
          break;
      }
        *(((int *) address)++) = n;
        break;
      case 'M':
        memcpy(S, &h->CurRecord[f->Off], f->Len);
        S[f->Len] = 0;
        *(((long *) address)++) = atol(S);
        break;
      case 'N': // "numeric" and "float"  fields
      case 'F':
        memcpy(S, &h->CurRecord[f->Off], f->Len);
        S[f->Len] = 0;
        if (f->Dec > 0) // convert to a real
          *(((double *) address)++) = strtod(S, NULL);
        else // no decimals, so it must be a longint
          *(((long *) address)++) = atol(S);
        break;
    }
  }
}

void ClearRecord(void)
{
  void * address;
  int  i, n;
  WorkAreaType *wa;
  dbfRecord*h;
  FieldRecord *f;
  char ch;

  wa = WorkArea[Selected];
  h = &wa->Handle;

  if (NotInUseError("ClearRecord"))
    return;
  if (h->v.strue.LinkedList && (h->Fields == NULL)) {
    memset(h->CurRecord, 0, h->RecLen);
    return;
  }
  address = wa->UserRec;
  *(int *) address = FALSE; // deleted record flag
  ++((int *) address);
  for (i = 0; i < h->NumFields; i++) {
    f = &h->Fields[i];
    switch (f->Typ) {
      case 'C': // character field -- convert to string
        memset(address, ' ', f->Len);
        *((char  *) address + f->Len) = 0;
        (char  *) address += (f->Len + 1);
        break;
      case 'D': // date field -- convert to string[10]
        strcpy((char *)address, CenturyOn ? "          " : "        ");
      switch (DateFormat) {
        case Italian:
          ch = '-';
          break;
        case French:
        case German:
        case Spanish:
        case Ansi:
          ch = '.';
          break;
        default:
          ch = '/';
      }
        n = CenturyOn ? 4 : 2;
        if (DateFormat != Ansi)
          n = 2;//for non-Ansi case delimiters are always at pos.2 and 5
        *((char*) address+n) = *((char*) address+n+3) = ch;
        (char*) address += 11;
        break;
      case 'L':
        *(((int *) address)++) = FALSE;
        break;
      case 'N':
      case 'F':
        if (!f->Dec)
          *(((long *) address)++) = 0;
        else
          *(((double *) address)++) = 0;
        break;
      case 'M':
        *(((long *) address)++) = 0;
        break;
    }
  }
}
