/* filename: COPYTO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>

#ifdef WINDOWS
#include <windows.h>
#endif
#include <dbf.h>

int AskToOverwrite(const char *filename);
void ImportData(void);

void CopyTo(const char * newfile)
// uses gotop and skip which both deal with deleted records and filters
{
  dbfRecord dDest, *r;
  unsigned char FromFile, ToFile;
  void * FromMemoPointer;
  char s[95], *p, buf[80];
  int i;
#ifndef WINDOWS
  char SaveX, SaveY;
  long counter;
#endif

  r = &WorkArea[Selected]->Handle;
  DBFError = 0;
  if (NotInUseError("CopyTo"))
    return;
  if ((r->v.strue.LinkedList) && (r->Fields == NULL)) {
    p = Virtual_file_has_no_structure_to_copy;
    goto bailout;
  }
  if (r->HasMemo) {
    if (MemoRoutines._CopyMemo == NULL) {
      p = Memo_unit_not_linked_into_program;
      goto bailout;
    }
  }
  strncpy(buf, Trim(newfile), 80);
  buf[79] = 0;
  p = strchr(buf, ' ');
  if (p)
    *p = 0; // fix for filenames with imbedded spaces
  _fullpath(buf, AddExt(buf,"DBF"), sizeof(buf));
  // cannot use _fullpath(buf, buf, sizeof(buf)) !!!
  strupr(buf);
  if (!AskToOverwrite(buf))
    return;
#ifndef WINDOWS
  SaveX = (char)wherex();
  SaveY = (char)wherey();
#endif

  CreateDbf(&dDest,buf, r->NumFields, r->Fields);
  if (DBFError)
    return;
  FromFile = (unsigned char)Selected;
  ToFile = AbsoluteMaxWorkareas-2;
  Selected = ToFile; // hidden WorkArea
  sprintf(s,"%s ALIAS ?COPYTO?", buf);
  Use(s, NULL, 0);
  Selected = FromFile;
#ifndef WINDOWS
  counter = 0;
  if (TalkEnabled) {
    gotoxy(SaveX,SaveY);
    printf("%0ld%d",counter,Records_copied);
  }
#endif // NOT WINDOWS

  // CopyTo() always starts copying records from the top of the From file,
  // *unless* the From file has an active "while" function. In that case,
  // CopyTo() starts with the current record

  if ((WorkArea[FromFile]->WhileFunc == NULL) &&
     (WorkArea[FromFile]->WhileExprHandle == NULL)) 
     GoTop();

  while (!dEOF()) {
    Selected = FromFile;
    if (WorkArea[Selected]->Handle.HasMemo) {
      for (i = 0; i < WorkArea[Selected]->Handle.NumFields; i++) {
        if (WorkArea[Selected]->Handle.Fields[i].Typ == 'M') {
          Selected = FromFile;
          FromMemoPointer = FieldAddress(i+1);    // Fields array is zero based, but FieldAddress is 1 based
          Selected = ToFile;
          MemoRoutines._CopyMemo(&FromFile, (long *) FromMemoPointer);
        }
      }
    }
    memcpy(WorkArea[ToFile]->UserRec,WorkArea[FromFile]->UserRec,
    WorkArea[ToFile]->UserRecSize);
    Selected = ToFile;
    ImportData(); // move users data to currecord--padded
    AppendDbf(&WorkArea[ToFile]->Handle);
    if (DBFError)
      return;
#ifndef WINDOWS
    ++counter;
    if (TalkEnabled) {
      gotoxy(SaveX,SaveY);
      printf("%0ld%s",counter,Records_copied);
    }
#endif
    Selected = FromFile;
    Skip(1);
  }
#ifndef WINDOWS
  if (TalkEnabled)
    printf("\n");
#endif
  Selected = ToFile;
  Use("",NULL,0);
  Selected = FromFile;
  return;

bailout:
  SetError(InvalidLLOperation, 4, p, " [CopyTo(", buf, ")]");
}
