/* filename: APPNDFRM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
//  provides the append-from syntax
//  If the file to append from is already open then we will just select it
//  and if not we have to open it first.
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <dbf.h>

int CheckSize(dbfRecord * d);
double RealVal(char * S);
long LongVal (char * s);
int ValidDate(const char *s);

static char far funcname[] = {" [AppendFrom]"};

static unsigned char TypeID(char c)
{
  char s[6] = {" CNLDM"};

  if (c == 'F')
    c = 'N'; // Float is handled the same as Numeric
  return (unsigned char) (strchr(s, c) - s);
}

static int CheckStructure(unsigned char ToFile, unsigned char FromFile)
// determines if we are appending from a file with exactly the same
// structure..if so, appending can be done more efficiently..
// unless of course there are memo fields involved
{
  int temp, n, i;
  unsigned char ToLen;
  char ToName[11], ToType, ToDec;

  if (WorkArea[ToFile]->Handle.HasMemo)
    return FALSE;
  Selected = ToFile;
  n = FieldCount();
  Selected = FromFile;
  if (FieldCount() != n) {
    Selected = ToFile;
    return FALSE; // can't be the same structure if FieldCount doesn't match
  }
  temp = FALSE;
  for (i = 1; i <= n; i++) {
    Selected = ToFile;
    strcpy(ToName, Field(i));
    ToType = FieldType(i);
    ToLen = FieldLen(i);
    ToDec = FieldDec(i);
    Selected = FromFile;
    temp |= ((strcmp(ToName, Field(i)) != 0) || (ToType != FieldType(i)) ||
    (ToLen != FieldLen(i)) || (ToDec != FieldDec(i)));
  }
  Selected = ToFile;
  return !temp; // returns TRUE if the structures are identical
}

void AppendFrom(const char * FileName)
{
  unsigned char ToFile, FromFile, MAP[MaxFieldCount];
  void *ToBuffer, *FromBuffer, *ToPtr, *FromPtr;
  dbfRecord d;
  int FromBufferSize, IdenticalStructure, i, t;
  char ToName[11]; // field name storage
  unsigned char ToType, FromType, ToLen, FromLen, ToDec, FromDec;
  char TempString[128], buf[80];
  unsigned savedDBFError = 0;

  if (!*(DBF())) {
    SetError(215,3, "[AppendFrom(", FileName, ")]"); // no database open to append to
    return;
  }
  FromBuffer = NULL;
  memset(&d, 0, sizeof(dbfRecord));

  strncpy(buf, Trim(FileName), 80);
  buf[79] = 0;
  _fullpath(buf, AddExt(buf,"DBF"), sizeof(buf));
  // cannot use _fullpath(buf, buf, sizeof(buffer)) !!!
  strupr(buf);

  ToFile = Selected;
  FromFile = 255; // a very big number...
  // check to see if file is already open in another workarea
  for (i = 0; i < MaxWorkAreas; i++) {
    if (WorkArea[i] && // file is already open
      (strcmp(WorkArea[i]->Handle.FileName, buf) == 0))
      FromFile = i;
  }
  if (FromFile == 255)
    if (!FileExists(buf)) {
      SetError(2, 3, "[AppendFrom(", buf, ")]"); // from file not found
      return;
    }
  if (FromFile == ToFile) {
    SetError(214, 4, Attempting_to_append_file_to_itself, " [AppendFrom(", buf, ")]");
    return;
  }
  Selected = ToFile;
  // if the ToFile has memo fields, then MEMO had better be linked in
  if (WorkArea[ToFile]->Handle.HasMemo && !MemoRoutines._AddMemo) {
    SetError(InvalidParameter,2, Memo_unit_not_linked_into_program, funcname);
    return;
  }
  ToBuffer = WorkArea[Selected]->UserRec;
  FromBufferSize = WorkArea[Selected]->UserRecSize; // default to same as ToFile
  if (FromFile == 255) { // file not already open
    strcpy(d.FileName, buf);
    OpenDbf(&d);
    if (DBFError)
      return;
    FromBufferSize = CheckSize(&d);
    CloseDbf(&d);
    if (DBFError)
      return;
    if ((FromBuffer = malloc(FromBufferSize)) == NULL) {
      SetError(217, 1, funcname);
      return;
    }
    Selected = AbsoluteMaxWorkareas - 1; // use the hidden workarea that is always available
    FromFile = Selected;
    sprintf(TempString, "%s ALIAS *FROMFILE", buf);
    Use(TempString, FromBuffer, FromBufferSize);
    if (DBFError)
      return;
  }
  else // file is already open in another workarea
    FromBuffer = WorkArea[FromFile]->UserRec;
  // both files are now open..we are ready to append
  // first, we construct a map, where MAP[i] is the field number in the From
  // File with the same field name as the ith field in the To File
  memset(MAP, 0, sizeof(MAP));
  Selected = ToFile;
  for (i = 1; i <= FieldCount(); i++) { // for all the fields in the "TO" file
    strcpy(ToName,Field(i));
    Selected = FromFile;
    for (t=1; ((strcmp(Field(t), ToName)) && (t <= FieldCount())); ++t)
      ;
    if (!strcmp(Field(t), ToName))
      MAP[i-1] = t; // each element contains the field number 1..MAX
    Selected = ToFile;
  }
  IdenticalStructure = CheckStructure(ToFile, FromFile);
  Selected = FromFile;
  t = FALSE;
  for (i = 0; i < MaxFieldCount; i++)
    t |= MAP[i];
  if (t) {
    while (!dEOF()) {
      Selected = ToFile;
      if (IdenticalStructure) // copy the whole record
        memcpy(ToBuffer,FromBuffer,FromBufferSize);
      else {
        ClearRecord();
        memcpy(ToBuffer,FromBuffer,1); // copy the deleted byte!
        for (i = 1; i <= FieldCount(); i++) { // number of fields in the "to" file
          if (MAP[i-1] == 0)
            continue; // no cooresponding field
          ToType = TypeID(FieldType(i));
          ToLen = FieldLen(i);
          ToDec = FieldDec(i);
          ToPtr = FieldAddress(i);
          Selected = FromFile;
          FromType = TypeID(FieldType(MAP[i-1]));
          FromLen = FieldLen(MAP[i-1]);
          FromDec = FieldDec(MAP[i-1]);
          FromPtr = FieldAddress(MAP[i-1]);
          Selected = ToFile;
          switch(10 * ToType + FromType) {
            case 11:
            case 44:
            case 14: // string-> string, date->date, date->string
              if (FromLen <= ToLen)
                strcpy((char *)ToPtr, (const char *)FromPtr);
              else {
                strncpy((char *)ToPtr, (const char *)FromPtr, ToLen);
                ((char *) ToPtr)[ToLen] = 0;
              }
              break;
            case 33: // logical -> logical
              *((char *) ToPtr) = *((char *) FromPtr);
              break;
            case 55: // memo -> memo
              *((long *) ToPtr) = (long) MemoRoutines._CopyMemo(&FromFile, (long *) FromPtr);
              break;
            case 41: // string -> date
              if (FromLen >= ToLen) { // if shorter, it cannot be a valid date
                strcpy(TempString, (const char *)FromPtr);
                // don't tamper with FROM data
                if (FromLen > ToLen)
                  TempString[ToLen] = 0;
                if (ValidDate(TempString))
                  strcpy((char *)ToPtr, TempString);
              }
              break;
            case 22: // numeric -> numeric
              // there are 4 possibilities
              switch(10 * (ToDec ? 2 : 1) + (FromDec ? 2 : 1)) {
                case 11:
                  *((long *) ToPtr) = *((long *) FromPtr); // longint to longint
                  break;
                case 12:
                  *((long *) ToPtr) = (long) floor(*((double *) FromPtr)); // Real to LongInt
                  break;
                case 21:
                  *((double *) ToPtr) = 1.0F * (*((long *) FromPtr)); // LongInt to real
                  break;
                case 22:
                  *((double *) ToPtr) = *((double *) FromPtr); // real to real
                  break;
              }
              break;
              // case 15:    case 23:    case 24: // processed as default
              // case 25:    case 42:    case 43:
              // case 45:    case 52:    case 53:
              // case 54: // leave the To Field alone, rather than blank the data
              //    break;
            case 51: // string -> memo
              *((long *) ToPtr) = MemoRoutines._AddMemo((char *) FromPtr);
              break;
            case 31: case 32:
            case 34: case 35:
              *((char *) ToPtr) = FALSE;
              break;
            case 13: // logical -> string
              *(int *)ToPtr = (* (char *) FromPtr) ? 'T\0' : 'F\0';
              break;
            case 12: // Numeric -> String
              if (FromDec == 0) // longint to string
                sprintf(TempString,"%*ld", ToLen, *((long *) FromPtr));
              else
                sprintf(TempString,"%*.*f", ToLen, FromDec, *((double *) FromPtr)); // real to string
              if (strlen(TempString) > ToLen) { // overflow!
                memset(TempString, '*', ToLen);
                TempString[ToLen] = 0; // return "*******"
              }
              strcpy((char *)ToPtr, TempString);
              break;
            case 21: // string -> numeric
              if (!ToDec) // string to Longint
                *((long *) ToPtr) = LongVal((char *)FromPtr);
              else
                *((double *) ToPtr) = RealVal((char *)FromPtr); // string to real
              break;
          }
        }
      }
      Append();
      if (DBFError) {
        savedDBFError = DBFError;
        break;
      }
      Selected = FromFile; // possibly AbsoluteMaxWorkArea
      Skip(1);
    }
  }
  if (FromFile == (AbsoluteMaxWorkareas - 1)) {
    Selected = FromFile; // possibly AbsoluteMaxWorkArea
    Use("",NULL,0); // close the file
    free(FromBuffer);
  }
  DBFError = savedDBFError;
  Selected = ToFile;
}
