/* filename: APPEND.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dbf.h>

#define ON  TRUE
#define OFF FALSE

void CheckActualRecCount(void);
void SyncRelations(void);
void ExportData(void);
void ImportData(void);

static char _tzfar funcname[] = { " [Append]" };

void Append(void)
{
  int indexopen;
  WorkAreaType *wa;
  dbfRecord    *r;

  wa = WorkArea[Selected];
  r = &wa->Handle;
  DBFError = 0;
  if (NotInUseError(funcname))
    return;
#ifdef NET
  if (!wa->Exclusive) {
    if (MultiUser &&
    ((wa->LockStatus == NotLocked) || (wa->LockStatus == RecordLocked))) { // access denied
      SetError(5, 4, File_must_be_locked, to_append, r->FileName, funcname);
      return;
    }
  }
  CheckActualRecCount(); // file is locked
#endif
  indexopen = FALSE;
  ImportData(); // move users data to currecord--padded
  if (IndexPresent)
    indexopen = IndexRoutines.IndexOpenFunc();
#ifdef NET
  if (indexopen)
    IndexRoutines.SetLockSemaphoreProc(ON);
#endif
  AppendDbf(r);
  ExportData(); // move new padded data back to users record
  if (indexopen) { // append key(s) to index(s) if open
    IndexRoutines.AppendNewKey(); // no parameter
    IndexRoutines.StoreCurrentKeys();
#ifdef NET
    IndexRoutines.SetLockSemaphoreProc(OFF);
#endif
  }
  r->CurRecNo = r->NumRecs;
  r->EOFile = FALSE;
  r->BOFile = FALSE;
  if (DBFError && AutoHalt)
    OnErrorHalt();
  SyncRelations();
}
