/* filename: ALL_LOCK.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <dos.h>
#include <stdlib.h>
#include <dbf.h>

#define FLOCK   1
#define ALOCK   2
#define RLOCK   3

extern char retrycount;
extern char retrydelay;

static char funcname[10] = {"[xLOCK]"};

#ifdef NET

static int try2unlock(long offset, long size)
{
  char s[8];

  DBFError = 0;
  if (LockUnlock(1, WorkArea[Selected]->Handle.v.dFile, offset, size)) {
    itoa(Selected, s, 10);
    SetError(33, 4, Error_attempting_to_UNLOCK_file,
    WorkArea[Selected]->Handle.FileName, in_Area, s);
  }
  return DBFError;
}

static int UnlockRecord(long n)
{
  dbfRecord *r = &WorkArea[Selected]->Handle;

  return try2unlock(LockOffset+r->HeadLen + (n-1) * r->RecLen, r->RecLen);
}

#endif

BOOL AddLock(void)
{ // add a linked list element at the head of the list
  WorkAreaType *wa = WorkArea[Selected];
  LockListRec *tmp;

  if ((tmp = (LockListRec *) malloc(sizeof(LockListRec))) == NULL) {
#ifdef NET
    UnlockRecord(wa->Handle.CurRecNo);
#endif
    SetError(InsufficientMemory, 1, " [RLock]");
    return 0;
  }
  tmp->RecNo = wa->Handle.CurRecNo;
  tmp->NextLock = wa->LockList;
  wa->LockList = tmp;
  wa->LockStatus = RecordLocked;
  ++wa->LockCount;

  return 1;
}

void DelLock(LockListRec **link, LockListRec *locktodel)
{
  WorkAreaType *wa = WorkArea[Selected];

  *link = locktodel->NextLock;
  free(locktodel);
  if (!--wa->LockCount)
    wa->LockStatus = NotLocked;
}

long LockList(long n)
{
  LockListRec *tmp;
  long count = 0;
  WorkAreaType *wa = WorkArea[Selected];

  if (NotInUseError("LockList"))
    return 0;
  tmp = wa->LockList; // start at the head
  switch (n) {
    case LastLock:
      n = 1;
      break;
    case FirstLock:
      n = wa->LockCount;
      break;
    default:
      n = wa->LockCount - n + 1;
  }
  while (tmp) {
    count++;
    if (count == n)
      return tmp->RecNo;
    tmp = tmp->NextLock;
  }
  return 0;
}

BOOL UnlockRec(long n)
{
  LockListRec  *Link;
  LockListRec  *Temp;
  LockListRec  **Previous;
  int  Error;
  BOOL DeletedOne;
  WorkAreaType *wa;

  DBFError = 0;
  if (NotInUseError("UnlockRec"))
    return 0;
  wa = WorkArea[Selected];
  Error = 0;
  if (n > 0) {
    Link = NULL;
    Temp = wa->LockList;
    Previous = &wa->LockList;
    DeletedOne = 0;
    while (Temp) {
      if (Temp->RecNo == n) {
#ifdef NET
        UnlockRecord(n);
#endif
        DelLock(&Link,Temp);
        DeletedOne = 1;
        *Previous = Link;
        Temp = NULL; // force exit from while loop
        if (DBFError)
          return 0;
      }
      else {
        *Previous = Temp;
        Temp = Temp->NextLock;
      }
    }
    if (!DeletedOne) {
      DBFError = InvalidParameter;
      sprintf(ErrorMessage,"Record not locked. [UnlockRec(%ld)]",n);
      return 0;
    }
    return 1;
  }
  else {
    switch (n) {
      case LastLock: // newest lock
#ifdef NET
        UnlockRecord(wa->LockList->RecNo);
#endif
        DelLock(&Link,wa->LockList);
        wa->LockList = Link;
        if (DBFError)
          return 0;
        break;
      case FirstLock: // oldest lock
        *Previous = wa->LockList;
        Temp = wa->LockList;
        Link = NULL;
        while (Temp->NextLock) { // find the end of the chain
          *Previous = Temp->NextLock;
          Temp = Temp->NextLock;
        }
#ifdef NET
        UnlockRecord(Temp->RecNo);
#endif
        DelLock(&Link,Temp); // deletes element pointed to by Temp
        *Previous = Link; // update NextLock pointer
        if (DBFError)
          return 0;
        break;
      case AllLocks:
        while (wa->LockList) {
#ifdef NET
          UnlockRecord(wa->LockList->RecNo);
          if (DBFError)
            Error = DBFError;
#endif
          DelLock(&Link,wa->LockList);
          wa->LockList = Link;
        }
        if (Error) {
          DBFError = Error;
          return 0;
        }
        break;
      default:
        DBFError = InvalidParameter;
        sprintf(ErrorMessage,"[UnlockRec(%ld)]", n);
        return 0;
    }
    return 1;
  }
}

BOOL IsLocked(LockListRec *ListPtr, long n)
{ // ListPtr may be changed since it's a value parameter
  while (ListPtr) {
    if (ListPtr->RecNo == n)
      return TRUE;
    ListPtr = ListPtr->NextLock;
  }
  return 0;
}

static int wmLock(int which)
{
  WorkAreaType *wa;
  dbfRecord  *r;
#ifdef NET
  int success;
  char count;
  long offset, size;
#endif

  switch (which) {
    case FLOCK: funcname[1] = 'F'; break;
    case ALOCK: funcname[1] = 'A'; break;
    case RLOCK: funcname[1] = 'R'; break;
  }
  if (NotInUseError(funcname))
    return 0;
  wa =  WorkArea[Selected];
  r = &wa->Handle;
#ifdef NET
  if (which == RLOCK) {
    if (MaxRecordLocks) {
      if (wa->LockCount == MaxRecordLocks) {
        SetError(212, 2, TopazRecordLockLimitExceeded, funcname);
        return FALSE;
      }
    }
  }
  if (!MultiUser)
    return  TRUE;
  if (r->v.strue.LinkedList) {
    SetError(InvalidLLOperation, 1, funcname);
    return 0;
  }
  if (wa->Exclusive)
    return TRUE;
  switch (which) {
    case RLOCK:
      if (wa->LockStatus == RecordLocked)
        if (IsLocked(wa->LockList, r->CurRecNo))
          return TRUE; // already locked
      if ((wa->LockStatus == AppendLocked) ||
        (wa->LockStatus == FileLocked))
        return FALSE;
      break;
    case FLOCK:
      if (wa->LockStatus == FileLocked)
        return TRUE;
      if (wa->LockStatus != NotLocked) // some other lock exists
        return FALSE;
      break;
    case ALOCK:
      if (wa->LockStatus == AppendLocked)
        return TRUE;
      if (wa->LockStatus != NotLocked) // some other lock exists
        return FALSE;
      break;
  }
  offset = LockOffset + 1;
  switch (which) {
    case FLOCK:
      size = FLockSize; // Foxbase compatible
      break;
    case RLOCK:
      offset += r->HeadLen + (r->CurRecNo-1)*r->RecLen - 1;
      size = r->RecLen;
      break;
    case ALOCK:
      size = 1;
      break;
  }
  count = 0;
  do {
    success = (LockUnlock(0, r->v.dFile, offset,size) == 0);
    if (!success) {
#ifndef WINDOWS
      if (count < retrycount)
        delay(retrydelay);
#endif
      ++count;
      if ((count > retrycount) && NetErrorProc)
        if (NetErrorProc())
          count = 0;
    }
  } while (!(success || (count > retrycount)));
#ifndef WINDOWS
  AdvanceRotor();
#endif
  if (success) {
    switch (which) {
      case RLOCK:
        return AddLock();
      case FLOCK:
        wa->LockStatus = FileLocked;
        return TRUE;
      case ALOCK:
        wa->LockStatus = AppendLocked;
        return TRUE;
      default:
        return TRUE;
    }
  }
  else
    return FALSE;
#else
  if (which != RLOCK)
    return TRUE; // single user dummy result for FLock and ALock
  if ((wa->LockStatus == RecordLocked) && IsLocked(wa->LockList,r->CurRecNo))
    return TRUE; // current record already in linked list ("locked")
  else
    return AddLock();
#endif // NET
}

BOOL FLock (void)
{
  return wmLock(FLOCK);
}

BOOL ALock(void)
{
  return wmLock(ALOCK);
}

BOOL RLock(void)
{
  return wmLock(RLOCK);
}

long LockCount(void)
{
  if (NotInUseError("LockCount"))
    return 0;
  return WorkArea[Selected]->LockCount;
}

#ifdef NET

int SLock(void)
{
  int success;
  char count;

  if (!MultiUser)
    return TRUE;   // single user dummy result
  count = 0;
  do {
#ifndef WINDOWS
    AdvanceRotor();
#endif

    success = !LockUnlock(0, WorkArea[Selected]->Handle.v.dFile, LockOffset, 1);
    if (!success) {
#ifndef WINDOWS
      if ((count < retrycount))
        delay(retrydelay);
#endif
      ++count;
      if ((count > retrycount) && NetErrorProc)
        if (NetErrorProc())
          count = 0;
    }
  }  while (!(success || (count > retrycount)));
  return success;
}

void SUnlock(void)
{
  try2unlock(LockOffset, 1); //  unlock the semaphore-lock byte
}

#endif

void Unlock(void)
{
#ifdef NET
  WorkAreaType *wa;

  wa =  WorkArea[Selected];

  if (NotInUseError("Unlock"))
    return;
  if (!MultiUser)
    return;
  if (wa->Handle.v.strue.LinkedList)
    return;
  if (wa->Exclusive)
    return;
  switch (wa->LockStatus) {
    case NotLocked:
      return;
    case FileLocked:
      try2unlock(LockOffset+1, FLockSize);
      break;
    case AppendLocked:
      try2unlock(LockOffset+1, 1);
      break;
    case RecordLocked:
      UnlockRec(AllLocks);
      break;
  }
  wa->LockStatus = NotLocked;
#endif // single user dummy procedure just returns, doing nothing
}
