/* filename: VECTORS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <common.h>
  
unsigned char AddISRVector(void (interrupt _far * vector)())
{
  unsigned char i;
  
  for( i=1; (((VectorTable[i].Vector != NULL) && (i != MAX_VECTORS-1))); i++ );
  if (VectorTable[i].Vector == NULL) {
    VectorTable[i].Vector = vector;
    VectorTable[i].Handle = VectorTable[i-1].Handle + 1;
    _dos_setvect(TIMER_INTERRUPT,VectorTable[i].Vector);
    return VectorTable[i].Handle;
  }
  else { // error
    //ListVectorTable(0);
    SetError(212, 2, Vector_table_full, "[AddISRVector]");
    return 0;
  }
}
  
#ifdef _MSC_VER
# pragma check_stack(off)
# pragma check_pointer(off)
#else
# pragma option -N- -r-
#endif
  
void (interrupt _far *ChainISRAddress(unsigned char MyHandle))()
{
  unsigned char i;
  
  for( i=1; (((VectorTable[i].Handle != MyHandle) && (i != MAX_VECTORS-1))); i++);
  if (VectorTable[i].Handle == MyHandle)
    return VectorTable[i-1].Vector;
  else {
    SetError(212, 2, Handle_not_found, "[ChainISRAddress]");
    return NULL;
  }
}
  
void RemoveISRVector(unsigned char MyHandle)
{
  unsigned char i;
  
  for (i=1; (((VectorTable[i].Handle != MyHandle) && (i != MAX_VECTORS-1))); i++);
  if (VectorTable[i].Handle == MyHandle) {
    if ((i == MAX_VECTORS-1) || (VectorTable[i+1].Vector == NULL)) { // last vector in chain
      _dos_setvect(TIMER_INTERRUPT,VectorTable[i-1].Vector);
      VectorTable[i].Vector = NULL;
      VectorTable[i].Handle = 0;
    }
    else {
      memmove(&VectorTable[i+1],&VectorTable[i], sizeof(VectorTable[i])*MAX_VECTORS-1-i);
      VectorTable[MAX_VECTORS-1].Vector = NULL;
      VectorTable[MAX_VECTORS-1].Handle = 0;
    }
  }
  else
    SetError(212, 2, Handle_not_found, "[RemoveISRVector]");
}
  
void SuspendISRs(void)
{
  _dos_setvect(TIMER_INTERRUPT, VectorTable[0].Vector);
}
  
void ResumeISRs(void)
{
  unsigned char i;
  
  for (i=1; (((VectorTable[i].Vector != NULL) && (i != MAX_VECTORS-1))); i++);
  if (VectorTable[i].Vector == NULL)
    _dos_setvect( TIMER_INTERRUPT, VectorTable[i-1].Vector );
  else
    _dos_setvect( TIMER_INTERRUPT, VectorTable[i].Vector );
}
#endif
