/* filename: KEYPRESD.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS
#include <stdio.h>
#include <conio.h>
#include <bios.h>
#include <dos.h>
#include <string.h>
#include <ctype.h>
#include <sayget.h>
#ifdef _MSC_VER
#define bioskey _bios_keybrd
#endif

extern char _tzfar Password[41];
extern unsigned char PWIndex;

int ReadKeySecPass = FALSE;
unsigned char NextScanCode = '\0';
char NextKey = '\0';

void CheckForPassword(void)
{
  int Key;

  if (bioskey(_KEYBRD_READY)) {
    Key = bioskey(_KEYBRD_READ) & 0xFF;
    if (Key) {
      if (!CaseSensitivePassword)
        Key = UpCase(Key);
      if (Key != Password[PWIndex++])
        PWIndex = 0;
      if (PWIndex == strlen(Password)) {
        *Password = 0; // we got it so turn it off
        PWIndex = 0;
      }
    }
  }
}

BOOL KeyPressed(void)
{
  int SaveDbaseOrder, ret;
  unsigned char SaveX, SaveY;
  struct REGPACK cpu;

  if (bioskey(_KEYBRD_READY) == -1)// Special case: CTRL/BREAK was pressed
    bioskey(_KEYBRD_READ); // clean the keyboard buffer
  if (ReadKeySecPass)
    return 1;
  ret = 0;
  memset(&cpu, 0, sizeof(cpu));
  if (*Password)
    CheckForPassword();
  else {
    if (!bioskey(_KEYBRD_READY)) { // no key waiting
      if (PollRoutine) {
        SaveDbaseOrder = dBASEOrder;
        SaveX = wherex();
        SaveY = wherey();
        PollRoutine();
        gotoxy(SaveX, SaveY);
        dBASEOrder = SaveDbaseOrder;
      }
    }
    else { // key was pressed
      cpu.r_ax = 0x0100;
      intr( 0x16, &cpu );
      NextKey = cpu.r_ax & 0x00ff; // ah=scancode, al=character
      if (NextKey == '\xE0') // extended key
        NextKey = 0;
      NextScanCode = cpu.r_ax >> 8;
      ret = 1;
      if (HelpEnabled) {
        if ((Activity == _None) || (Activity == _Edit) ||
          (Activity == _Memo))
          return 1;
        // help is enabled, but we are in the middle of edit or memo
        if (NextKey)
          return 1;
        // help is enabled, but this is not an extended key
        if (!((NextScanCode == (unsigned char)HelpContextHotKey) ||
          (NextScanCode == (unsigned char)HelpAuthoringHotKey) ||
          (NextScanCode == (unsigned char)HelpTopicHotKey)))
          return 1;
        // this is a help key..clear the keyboard and call help
        while (bioskey(_KEYBRD_READY))
          bioskey(_KEYBRD_READ); // clear the keyboard
        ret = 0;
        if (HelpRoutines.DoHelpProc)
          HelpRoutines.DoHelpProc(NextScanCode);
        else
          SetError(254, 1, " NULL Help Proc");
      }
    }
  }
  return ret;
}
#endif // not WINDOWS
