;/* filename: FONTCODE.ASM
;
;: T O P A Z for C :Ŀ
;                          Version 4.5  05/16/93                              
;                                                                             
; Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
; Unauthorized distribution or disclosure of this source code or modification 
;  or removal of this notice  constitutes a breach of the license agreement.  
;
;*/
; Writes a character to the character generator for EGA/VGA/Herc cards
;
; prototype: PutFont(void _far *FontPtr,       
;                    unsigned   StartingChar,    
;                    unsigned   Count,           
;                    BOOL       Primary);  
;
;   FontPtr is a pointer to the first byte of a font table
;   StartingChar is the first character in the ASCII table to be 
;                re-defined on the card
;   Count is the number of characters to be sent to the card
;
.model LARGE
.data
  SegA000         dW     0A000H  ; These two variables are added to keep
  Seg0040         dW     0040H   ; synced Pascal and C versions of TOPAZ
.code

PUBLIC  _PutFont

FontPtr         EQU  DWORD PTR [BP+6]
StartingChar    EQU  WORD  PTR [BP+10]
Count           EQU  WORD  PTR [BP+12]
Primary         EQU  WORD  PTR [BP+14]

;BIOS_Equipment  EQU     0487H ; Type of equipment in system, prehistoric way
BIOS_Equipment  EQU     0087H ; Type of equipment in system, new way:
                              ; Seg0040:[BIOS_Equipment]

_PutFont PROC    FAR

        PUSH    BP
        MOV     BP,SP
        PUSH    ES
        PUSH    DS
        PUSH    DI
        PUSH    SI

        ;--- Enable memory for write into plane 2

        MOV     DX,03C4h      ; sequencer enable map 2 for write
        MOV     AL,2
        OUT     DX,AL
        INC     DX
        MOV     AL,4
        OUT     DX,AL

        DEC     DX            ; sequencer no chaining
        MOV     AL,4
        OUT     DX,AL
        INC     DX
        MOV     AL,6
        OUT     DX,AL

        MOV     DX,03CEh      ; graphics use data from processor
        MOV     AL,1
        OUT     DX,AL
        INC     DX
        MOV     AL,0
        OUT     DX,AL

        DEC     DX            ; graphics read and write modes
        MOV     AL,5
        OUT     DX,AL
        INC     DX
        MOV     AL,0
        OUT     DX,AL

        DEC     DX            ; graphics address mapped to A000
        MOV     AL,6
        OUT     DX,AL
        INC     DX
        MOV     AL,04h
        OUT     DX,AL

        DEC     DX            ; graphics enable 8 bits per write
        MOV     AL,8
        OUT     DX,AL
        INC     DX
        MOV     AL,0FFh
        OUT     DX,AL

        ;--- load the character generator into plane 2

        MOV     AX, Primary   ; primary?
        CMP     AX,0          ; set zero flag
        JZ      Secondary     ; not primary
;        MOV     AX,0A000H    ; then point to segment A000 (first 8K of plane 2)
        MOV     AX,SegA000    ; The new way: SegA000:BX
        XOR     BX,BX         ;
        JMP     SHORT OverSecondary 

Secondary:

;        MOV AX, 0A200H     ; else point to segment A200 (second 8K of plane 2)
        MOV AX, SegA000     ; The new way: SegA000:BX
        MOV BX, 2000H       ; 

OverSecondary:
        MOV     ES,AX
        MOV     AX,StartingChar   ;Compute offset into char gen plane
        AND     AX,0FFH
        MOV     CL,5              ;as index * bytes_per_char
        SHL     AX,CL             ;which is index * 32
        MOV     DI,AX             ;Copy offset in char gen plane into DI
        ADD     DI,BX
        PUSH    DS
        LDS     SI,FontPtr        ;Fetch pointer to new characters
        MOV     AX,Count          ;Fetch number of characters to copy
        SHL     AX,CL             ;Compute how many bytes to copy
        SHR     AX,1              ;Divide by two so we can use MOV WORD
        MOV     CX,AX             ;Copy count into CX

        REP     MOVSW             ;Copy the data
        POP     DS

        ;--- Enable second set (for EGA)

        MOV     DX, 3C4H
        MOV     AL, 3
        OUT     DX,AL
        INC     DX
        MOV     AL, 4
        OUT     DX,AL

        ;--- Restore Sequencer and Graphics Controller

        MOV     DX,03C4h          ; Enable plane 0 & 1 for write
        MOV     AL,2
        OUT     DX,AL
        INC     DX
        MOV     AL,03H
        OUT     DX,AL

        DEC     DX                ; sequencer even/odd & text
        MOV     AL,4
        OUT     DX,AL
        INC     DX
        MOV     AL,3
        OUT     DX,AL

        MOV     AX, Primary       ; Primary?
        CMP     AX,0              ; Set zero flag
        JNZ     SkipAttrBitSelect ; Is Primary, don't set bit select

        DEC     DX
        MOV     AL,3              ; redefine attribute bit to switch
        OUT     DX,AL             ; from primary and secondary fonts
        INC     DX
        MOV     AL,20H
        OUT     DX,AL
        JMP     SHORT FinishedAttrBitSelect

SkipAttrBitSelect:

        DEC     DX
        MOV     AL,3
        OUT     DX,AL
        INC     DX
        MOV     AL,0
        OUT     DX,AL

FinishedAttrBitSelect:

        DEC     DX
        MOV     AL,3
        MOV     DX,3CEH           ; graphics read and write modes
        MOV     AL,5
        OUT     DX,AL
        INC     DX
        MOV     AL,10H
        OUT     DX,AL
        DEC     DX

;        XOR     AX,AX
        MOV     AX,Seg0040
        MOV     ES,AX
        TEST    BYTE PTR ES:[BIOS_Equipment],2
        JNZ     WCG_Set_B000

        MOV     DX,3CEH           ;Map display buffer to B800
        MOV     AL,6
        OUT     DX,AL
        INC     DX
        MOV     AL,0EH
        OUT     DX,AL
        JMP     SHORT WCG_Done

WCG_Set_B000:
        MOV     DX,3CEH           ;Map display buffer to B000
        MOV     AL,6
        OUT     DX,AL
        INC     DX
        MOV     AL,0AH
        OUT     DX,AL

        ;--- Clean up and exit
WCG_Done:
        POP     SI
        POP     DI
        POP     DS
        POP     ES
        MOV     SP,BP
        POP     BP
        RET

_PutFont ENDP

        END
