/* filename: ERRORHLT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <common.h>
#ifdef _MSC_VER
#include <graph.h>
#endif
#ifdef WINDOWS
#include <windows.h>
#endif

struct wm_Error {
  unsigned No;
  char * Msg;
};

static char _tzfar msg_1[] =  Invalid_DOS_function_code;
static char _tzfar msg_2[] =  File_not_found;
static char _tzfar msg_3[] =  Path_not_found;
static char _tzfar msg_4[] =  Too_many_open_files;
static char _tzfar msg_5[] =  File_access_denied;
static char _tzfar msg_6[] =  Invalid_file_handle;
static char _tzfar msg_8[] =  Not_enough_memory;
static char _tzfar msg_9[] =  Memory_block_address_invalid;
static char _tzfar msg_10[] = Environment_invalid;
static char _tzfar msg_11[] = Format_invalid;
static char _tzfar msg_12[] = Invalid_file_access_code;
static char _tzfar msg_13[] = Data_invalid;
static char _tzfar msg_15[] = Invalid_drive_number;
static char _tzfar msg_16[] = Cannot_remove_current_directory;
static char _tzfar msg_17[] = Cannot_rename_across_drives;
static char _tzfar msg_19[] = Disk_write_protected;
static char _tzfar msg_20[] = Unknown_unit;
static char _tzfar msg_21[] = Drive_not_ready;
static char _tzfar msg_22[] = Unknown_command;
static char _tzfar msg_23[] = CRC_error_in_data;
static char _tzfar msg_24[] = Bad_drive_request_structure_length;
static char _tzfar msg_25[] = Disk_seek_error;
static char _tzfar msg_26[] = Unknown_media_type;
static char _tzfar msg_27[] = Disk_sector_not_found;
static char _tzfar msg_28[] = Printer_out_of_paper;
static char _tzfar msg_29[] = Device_write_fault;
static char _tzfar msg_30[] = Device_read_fault;
static char _tzfar msg_31[] = General_failure;
static char _tzfar msg_32[] = Sharing_violation;
static char _tzfar msg_33[] = Lock_violation;
static char _tzfar msg_34[] = Disk_change_invalid;
static char _tzfar msg_35[] = FCB_unavailable;
static char _tzfar msg_36[] = Sharing_buffer_exceeded;

static char _tzfar msg_50[] = Unsupported_network_request;
static char _tzfar msg_51[] = Remote_machine_not_listening;
static char _tzfar msg_52[] = Duplicate_name_on_network;
static char _tzfar msg_53[] = Network_name_not_found;
static char _tzfar msg_54[] = Network_busy;
static char _tzfar msg_55[] = Device_no_longer_exists_on_network;
static char _tzfar msg_56[] = NetBios_command_limit_exceeded;
static char _tzfar msg_57[] = Error_in_network_adapter_hardware;
static char _tzfar msg_58[] = Incorrect_response_from_network;
static char _tzfar msg_59[] = Unexpected_network_error;
static char _tzfar msg_60[] = Remote_adapter_incompatible;

static char _tzfar msg_210[] = Not_a_dBASE_data_file;
static char _tzfar msg_211[] = Invalid_field_type_encountered;
static char _tzfar msg_212[] = Request_beyond_range;
static char _tzfar msg_213[] = End_of_file_found_unexpectedly;
static char _tzfar msg_214[] = Database_already_in_use;
static char _tzfar msg_215[] = No_database_in_use;
static char _tzfar msg_216[] = Invalid_size;
static char _tzfar msg_217[] = Insufficient_memory;
static char _tzfar msg_218[] = Invalid_pointer_specified;
static char _tzfar msg_219[] = Cannot_duplicate_file_handle;
static char _tzfar msg_220[] = Invalid_parameter ;
static char _tzfar msg_221[] = Index_file_not_open;
static char _tzfar msg_222[] = Corrupted_index_file;
static char _tzfar msg_223[] = Index_version_mismatch;
static char _tzfar msg_224[] = Cyclical_relation_detected;
static char _tzfar msg_225[] = Exclusive_use_required;
static char _tzfar msg_226[] = Browse_not_active;
static char _tzfar msg_227[] = Insufficient_disk_space;
static char _tzfar msg_229[] = dBASE_IV_Memos_Not_Supported;
static char _tzfar msg_230[] = No_memory_vars_loaded;

static char _tzfar msg_239[] = Missing_colon_in_time;
static char _tzfar msg_240[] = Non_numeric_character_in_time;
static char _tzfar msg_241[] = Invalid_time_specified;
static char _tzfar msg_242[] = Negative_time_specified;
static char _tzfar msg_243[] = TimeDiff_result_negative;
static char _tzfar msg_254[] = Topaz_internal_error;

static char _tzfar msg_350[] = Error_while_parsing;
static char _tzfar msg_351[] = Error_in_dBASE_expression;
static char _tzfar msg_352[] = Semantic_stack_overflow;
static char _tzfar msg_353[] = Working_stack_overflow;
static char _tzfar msg_354[] = Working_pool_overflow;
static char _tzfar msg_355[] = Working_stack_empty;
static char _tzfar msg_356[] = Unknown_data_type;
static char _tzfar msg_357[] = Error_during_evaluation_Divide_by_0;
static char _tzfar msg_358[] = Key_Expression_Too_Long;
static char _tzfar msg_359[] = Empty_Key_Expression;
static char _tzfar msg_360[] = Key_Expression_Is_NULL;
static char _tzfar msg_361[] = Not_Logical_Expression;
static char _tzfar msg_362[] = Not_Valid_Key_Expression;

static char _tzfar msg_1003[] = Invalid_memo_address;
static char _tzfar msg_1004[] = Disk_full;
static char _tzfar msg_1005[] = Memo_write_error;
static char _tzfar msg_1007[] = Memo_is_already_open;
static char _tzfar msg_1012[] = Insufficient_diskspace_memoPack;
static char _tzfar msg_1017[] = Cannot_lock_memo_file;
static char _tzfar msg_1018[] = Cannot_unlock_memo_file;
static char _tzfar msg_1019[] = Invalid_memo_operation;
static char _tzfar msg_1100[] = Not_a_valid_operation_on_linked_list;
static char _tzfar msg_1101[] = Virtual_file_manager_unit_not_linked_in;
static char _tzfar msg_1102[] = Virtual_file_memory_management_error;
static char _tzfar msg_1103[] = Invalid_operation;
static char _tzfar msg_1200[] = Record_not_locked;
static char _tzfar msg_1201[] = File_not_locked;
static char _tzfar msg_1202[] = Semaphore_file_error;
static char _tzfar msg_1300[] = File_format_not_supported;

static char _tzfar msg_network_err[]   = Network_error;
static char _tzfar msg_undefined_err[] = Undefined_error;

static struct wm_Error _tzfar wmError[] = {
  { 1, msg_1 },
  { 2, msg_2 },
  { 3, msg_3 },
  { 4, msg_4 },
  { 5, msg_5 },
  { 6, msg_6 },
  { 8, msg_8 },
  { 9, msg_9 },
  { 10, msg_10 },
  { 11, msg_11 },
  { 12, msg_12 },
  { 13, msg_13 },
  { 15, msg_15 },
  { 16, msg_16 },
  { 17, msg_17 },
  { 19, msg_19 },
  { 20, msg_20 },
  { 21, msg_21 },
  { 22, msg_22 },
  { 23, msg_23 },
  { 24, msg_24 },
  { 25, msg_25 },
  { 26, msg_26 },
  { 27, msg_27 },
  { 28, msg_28 },
  { 29, msg_29 },
  { 30, msg_30 },
  { 31, msg_31 },
  { 32, msg_32 },
  { 33, msg_33 },
  { 34, msg_34 },
  { 35, msg_35 },
  { 36, msg_36 },

  // 37..49 = reserved by DOS
  // NetBios errors

  { 50, msg_50 },
  { 51, msg_51 },
  { 52, msg_52 },
  { 53, msg_53 },
  { 54, msg_54 },
  { 55, msg_55 },
  { 56, msg_56 },
  { 57, msg_57 },
  { 58, msg_58 },
  { 59, msg_59 },
  { 60, msg_60 },

  //  61..88  these DOS error messages can be looked up in the DOS
  // Tech Ref manual and added here if deemed necessary.

  // DBF/INDEX - Topaz error codes
  { 210, msg_210 },
  { 211, msg_211 },
  { 212, msg_212 },
  { 213, msg_213 },
  { 214, msg_214 },
  { 215, msg_215 },
  { 216, msg_216 },
  { 217, msg_217 },
  { 218, msg_218 },
  { 219, msg_219 },
  { 220, msg_220 },
  { 221, msg_221 },
  { 222, msg_222 },
  { 223, msg_223 },
  { 224, msg_224 },
  { 225, msg_225 },
  { 226, msg_226 },
  { 227, msg_227 },
  { 229, msg_229 },
  { 230, msg_230 },

  // TIMEDATE error codes
  { 239, msg_239 },
  { 240, msg_240 },
  { 241, msg_241 },
  { 242, msg_242 },
  { 243, msg_243 },
  { 254, msg_254 },

  // Parser error codes
  { 350, msg_350 },
  { 351, msg_351 },
  { 352, msg_352 },
  { 353, msg_353 },
  { 354, msg_354 },
  { 355, msg_355 },
  { 356, msg_356 },
  { 357, msg_357 },
  { 358, msg_358 },
  { 359, msg_359 },
  { 360, msg_360 },
  { 361, msg_361 },
  { 362, msg_362 },

  { 1003, msg_1003 },
  { 1004, msg_1004 },
  { 1005, msg_1005 },
  { 1007, msg_1007 },
  { 1012, msg_1012 },
  { 1017, msg_1017 },
  { 1018, msg_1018 },
  { 1019, msg_1019 },
  { 1100, msg_1100 },
  { 1101, msg_1101 },
  { 1102, msg_1102 },
  { 1103, msg_1103 },
  { 1200, msg_1200 },
  { 1201, msg_1201 },
  { 1202, msg_1202 },
  { 1300, msg_1300 },

  { 0, NULL } // this unique line is obligatory to stop the search
};

char *tzErrorDescription(int error)
{
  int i;

  if ((error > 1202) && (error < 1300))
    return msg_network_err;
  else {
    for (i = 0; wmError[i].No; ++i)
      if ((unsigned) error == wmError[i].No)
        return wmError[i].Msg;

    return msg_undefined_err;
  }
}

void OnErrorHalt(void)
// standard error reporting routine or optionally calls
// a user-defined error routine
{
#ifdef WINDOWS
  char strbuf[400];
#else
  int i;
  int MessageLines;
#endif

  if (UserErrorHandler) { // call users error handler routine
    UserErrorHandler();
    return;
  }
  if (!DBFError)
    return; // no error occurred

#ifdef WINDOWS
  sprintf(strbuf,"%s (%s%d) %s", tzErrorDescription(DBFError), Error_number, DBFError, Message());
  WDialogBox(strbuf, Program_halted, MB_OK | MB_ICONSTOP);
#else
  printf("\a\n");
  MessageLines = 1;
  for (i = 0; i < (int) strlen(ErrorMessage); i++)
    if (ErrorMessage[i] == '\n')
      MessageLines++;
  if (WaitOnError)
    MessageLines++;
#ifdef _MSC_VER
  _settextwindow(1,1,MessageLines + 5,80);
  _settextcolor(YELLOW);
  _setbkcolor(BLACK);
#else
  window(1, 1, 80, MessageLines + 5);
  textcolor(YELLOW);
  textbackground(BLACK);
#endif
  ClrScr();
  printf("\n%s\n%s %d (%s)\n%s\n",
     Program_halted, Error_number, DBFError, tzErrorDescription(DBFError), Message());
  if (WaitOnError) {
    printf("%s\n", press_any_key);
    for (i = 0; i < 80; i++)
      printf("\xC4");
    while (kbhit())
      getch();
    while (!kbhit());
    getch(); // Get rid of it after it's read
  }
  else
    for (i = 0; i < 80; i++)
      printf("\xC4");
#ifdef _MSC_VER
  _settextwindow(1,1,25,80);
#else
  window(1, 1, 80, 25);
#endif
  gotoxy(1, MessageLines + 6);
#endif // not windows
  exit(DBFError); // set dos errorlevel to error number
}

void FreePtrClear(void **p)
{
  if (*p) {
    free(*p);
    *p = NULL;
  }
}
