/* filename: BUTTONS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS
#include <stdio.h>
#include <dos.h>
#include <common.h>
  
static void SwapButtons(unsigned int * bx)
{
  unsigned int temp;

  if (LeftHandedMouse) {
    temp = *bx & 0xFC;
    if (*bx & 1)
      temp |= 0x02;
    if (*bx & 2)
      temp |= 0x01;
    *bx = temp;
  }
}
  
static unsigned char GetMouseButtonStatus(void)
{
  struct REGPACK cpu;
  
  if (MouseDriverPresent) {
    cpu.r_ax = 3;
    intr(0x33,&cpu);
    SwapButtons(&cpu.r_bx);
    return (unsigned char)(cpu.r_bx & 0xff);
  }
  else
    return 0;
}

int IsLeftButtonDown(void)
{
  return GetMouseButtonStatus() & 1;
}
  
int IsRightButtonDown(void)
{
  return GetMouseButtonStatus() & 2;
}
  
int IsCenterButtonDown(void)
{
  return GetMouseButtonStatus() & 4;
}
#endif
