/* filename: PRCSSKEY.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <calc.h>

void CalcProcessKey(CommandKeys key)
{
  CommandKeys priorcmd;

  if ((key == EnterCmd) && !Register[0] && ((LastOperation==AddCmd)
    || (LastOperation==SubtractCmd) || (LastOperation==MultiplyCmd)
  || (LastOperation==DivideCmd) || (LastOperation==EqualsCmd))) {
    LastOperation = EqualsCmd;
    UpdateTape();
    LastOperation = AddCmd;
    if(DoubleEnter)
      CalcDone = TRUE;
    DoubleEnter = TRUE;
    DisplayAllRegisters();
    return;
  }
  if((key == EqualsCmd) && !Register[0]) {
    priorcmd = LastOperation;
    LastOperation = EqualsCmd;
    UpdateTape();
    LastOperation = priorcmd;
    DisplayAllRegisters();
    UpdateOperationFlag = FALSE;
    return;
  }
  if (UpdateOperationFlag) {
    if ( (key==AddCmd) || (key==SubtractCmd) || (key==MultiplyCmd)
    || (key==DivideCmd) || (key==EqualsCmd) ) {
      LastOperation = key;
      DisplayAllRegisters();
      // since LastOperation changed
      return;
    }
    if ((key == EnterCmd) && !DoubleEnter) {
      LastOperation = key;
      return;
    }
  }
  switch (key) {
    case AddCmd:
    case SubtractCmd:
    case MultiplyCmd:
    case DivideCmd:
    case EqualsCmd:     FourFunction(key); break;
    case ClearCmd:      ClearCalculator(); break;
    case ClearEntryCmd: ClearRegister(); break;
    case ChangeSignCmd: ChangeSign(); break;
    case MemoryCmd:     CalcProcessMemory(&key); break;
    case ImportCmd:     strcpy(Register,ImportRegister()); break;

    case EnterCmd:
      if (DoubleEnter) {
        CalcDone = TRUE;
        strcpy(CalcResult, Accumulator);
      }
      else
        FourFunction(EnterCmd);
      break;
    case AbandonCmd:
      CalcDone = TRUE;
      CalcResult[0] = 0;
      break;
    case BackSpaceCmd:
      if (strlen(Register) > 0 )
        Register[strlen(Register)-1]=0;
      break;
    case DecimalCmd: AppendDecimal();  break;
    case DigitCmd:   AppendDigit();    break;
    case MoveCmd:    MoveCalculator(); break;
  }
  // if Key <> NoCmd then
  DisplayAllRegisters();
  if ( (key==AddCmd) || (key==SubtractCmd)
    || (key==MultiplyCmd) || (key==DivideCmd) || (key==EqualsCmd)
    || (key==EnterCmd) || (key==MemoryCmd) )
    UpdateOperationFlag = TRUE;
  else
    UpdateOperationFlag = FALSE;
}
