/* filename: MOVECALC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include <sayget.h>
#include <calc.h>

extern char _tzfar TzCalcVar[128];

static void RestoreRow(unsigned char Y)
{
  int Left, Right, i, j;

  if ((Y+1 > 0) && (Y <= MaxAvailRows())) {
    Left = CalcX1;
    Right = CalcX2+TapeWidth;
    if (CalcShade && (Right < 79))
      Right += 2;
    HideMouse();
    for (i = Left; i <= Right; i++)
      for (j = 0; j <= 1; j++)
        (*CalcScreen)[Y-1][i-1][j] = (*CalcBufPtr)[Y-1][i-1][j];
    ShowMouse();
  }
}

static void RestoreLLShadowPiece(unsigned char n)
{
  unsigned char i, j;

  if (CalcShade && ((unsigned char)(CalcY2+1) <= MaxAvailRows())) {
    HideMouse();
    for (i = 0; i <= n; i++)
      for (j = 0; j <= 1; j++)
        (*CalcScreen)[CalcY2+i][CalcX1+1][j] = (*CalcBufPtr)[CalcY2+i][CalcX1+1][j];
    ShowMouse();
  }
}

static void RestoreURShadowPiece(unsigned char n)
{
  unsigned char i, j;

  if (CalcShade)
    for (i = 0; i <= n; i++)
      if ((CalcX2 + i) < 81)
        for (j = 0; j <= 1; j++)
          (*CalcScreen)[CalcY1-1][CalcX2+TapeWidth+i-1][j] = (*CalcBufPtr)[CalcY1-1][CalcX2+TapeWidth+i-1][j];
}

static void DimRow(unsigned char Y)
{
  int Right, i;

  if (CalcShade && (Y > 0) && (Y <= MaxAvailRows())) {
    Right = CalcX2+TapeWidth+2;
    if (Right > 80)
      Right = 80;
    for (i = CalcX1 + 2; i <= Right; i++)
      (*CalcScreen)[Y-1][i-1][1] = ShadowColor;
  }
}

static void BrightenRow(unsigned char Y)
{
  int i, j, Right;

  if (CalcShade && (Y > 0) && (Y <= MaxAvailRows())) {
    Right = CalcX2+TapeWidth+2;
    if (Right > 80)
      Right = 80;
    for (i = CalcX1 + 2; i <= Right; i++)
      for (j = 0; j <= 1; j++)
        (*CalcScreen)[Y-1][i-1][j] = (*CalcBufPtr)[Y-1][i-1][j];
  }
}

static void RestoreColumn(unsigned char X)
{
  int i, j;
  int Top, Bottom;

  if ((X+1 > 0) && (X < 81)) {
    Top = CalcY1;
    Bottom = CalcY2;
    if (CalcShade && ((unsigned char) Bottom < MaxAvailRows()))
      ++Bottom;
    for (i = Top; i <= Bottom; i++)
      for (j = 0; j <= 1; j++)
        (*CalcScreen)[i-1][X-1][j] =(*CalcBufPtr)[i-1][X-1][j];
  }
}

static void DimColumn(unsigned char X)
{
  int Bottom, i;
  unsigned char XPlusOne;

  if (CalcShade && (X > 0) && (X < 81)) {
    Bottom = CalcY2 + 1;
    if ((unsigned char) Bottom > MaxAvailRows())
      Bottom = MaxAvailRows();
    XPlusOne = X+1;
    if (XPlusOne > 80)
      XPlusOne = 80;
    for (i = CalcY1+1; i <= Bottom; i++) {
      (*CalcScreen)[i-1][X-1][1] = ShadowColor;
      (*CalcScreen)[i-1][XPlusOne-1][1] = ShadowColor;
    }
  }
}

static void BrightenColumn(unsigned char X)
{
  int i, j, Bottom;
  unsigned char XPlusOne;

  if (CalcShade && (X > 0) && (X < 81)) {
    Bottom = CalcY2;
    if ((unsigned char) Bottom < MaxAvailRows())
      ++Bottom;
    XPlusOne = X+1;
    if (XPlusOne > 80)
      XPlusOne = 80;
    for (i = CalcY1+1; i <= Bottom; i++)
      for (j = 0; j <= 1; j++) {
        (*CalcScreen)[i-1][X-1][j] = (*CalcBufPtr)[i-1][X-1][j];
        (*CalcScreen)[i-1][XPlusOne-1][j] = (*CalcBufPtr)[i-1][XPlusOne-1][j];
      }
  }
}

static void DimLLShadowPiece(void)
{
  if (CalcShade && ((unsigned char) (CalcY2 + 1) <= MaxAvailRows()) && (CalcX1 + 1 <= 80))
    (*CalcScreen)[CalcY2][CalcX1][1] = ShadowColor;
}

static void DimURShadowPiece(void)
{
  if (CalcShade && ((unsigned char) CalcY1 <= MaxAvailRows())) {
    if (CalcX2 + 1 < 81)
      (*CalcScreen)[CalcY1-1][CalcX2+TapeWidth][1] = (char)(ShadowColor);
    if (CalcX2+TapeWidth+2 < 81)
      (*CalcScreen)[CalcY1-1][CalcX2+TapeWidth+1][1] = (char)(ShadowColor);
  }
}

void MoveCalculator(void)
{
  char buf[STRSIZ-1];
  WindowRec w;

  // don't move unless underlying screen has been saved
  if (CalcScreenSaved && (coreleft() > (unsigned long) ((((CalcX2+TapeWidth) - CalcX1) + 1) << 1) * ((CalcY2 - CalcY1) + 1)))
    // enough memory for snapshot
  {
    DestX = 0;
    DestY = 0;
    PushMouse();
    EnableMouse();
    SetColorTo(CalcColors.lcdFG,CalcColors.lcdBG,0,0);
    strcpy( buf, MOVE_MODE);
    strcat(buf,"        ");
    At(CalcX1 + 10,CalcY1 + 1,buf);
    if(!IsLeftButtonDown())
      At(CalcX1 + 3,CalcY1 + 2,CopyCharNull(TzCalcVar,24));
    FillWindow((unsigned char) CalcX1, (unsigned char) CalcY1,
    (unsigned char) (CalcX2+TapeWidth),(unsigned char) CalcY2,&w);
    CalcTurnNumLock(OFF);
    CalculatorState = MoveState;
    do {
      switch (MoveCalc_k(TzCalcVar)) {
        case UpperArrow:   //  Move calculator up
          if (CalcY1 > 1) {
            RestoreRow((unsigned char) CalcY2);
            BrightenRow((unsigned char) (CalcY2+1));
            DimRow((unsigned char) CalcY2);
            RestoreLLShadowPiece(2);
            DimURShadowPiece();
            --CalcY1;
            --CalcY2;
          }
          break;
        case DnArrow:   //  Move calculator down
          if ((unsigned char) CalcY2 < MaxAvailRows()) {
            RestoreRow((unsigned char) CalcY1);
            BrightenRow((unsigned char) (CalcY1+1));
            DimRow((unsigned char) (CalcY2+2));
            RestoreURShadowPiece(2);
            ++CalcY1;
            ++CalcY2;
          }
          break;
        case LtArrow:   //  Move calculator left
          if (CalcX1 > 1) {
            RestoreColumn((unsigned char) (CalcX2+TapeWidth));
            BrightenColumn((unsigned char) (CalcX2+TapeWidth+1));
            DimColumn((unsigned char) (CalcX2+TapeWidth));
            RestoreURShadowPiece(1);
            DimLLShadowPiece();
            --CalcX1;
            --CalcX2;
          }
          break;
        case RtArrow:   //  Move calculator right
          if (CalcX2+TapeWidth < 80) {
            RestoreColumn((unsigned char) CalcX1);
            DimColumn((unsigned char) (CalcX2+TapeWidth+2));
            RestoreLLShadowPiece(1);
            ++CalcX1;
            ++CalcX2;
          }
          break;
        case Esc:      // turns off scroll Lock
          *KeyboardFlags = *KeyboardFlags & 0xEF;
          break;
      }
      w.c1 = (char) CalcX1;
      w.c2 = (char) CalcX2+TapeWidth;
      w.r1 = (char) CalcY1;
      w.r2 = (char) CalcY2;
      w.SaveBuffer = TRUE;
      DisplayWindow(&w); // compute new coordinates
      DispRow = CalcY1 + 2;
      DispCol = CalcX1 + 25;
    }      while (CalcScrollLock());
    CalculatorState = NormalState;
    w.SaveBuffer = FALSE;
    DisplayWindow(&w);
    CalcTurnNumLock(ON);
    SetColorTo(CalcColors.lcdFG,CalcColors.lcdBG,0,0);
    At(CalcX1 + 3,CalcY1 + 1,Space(24)); // erase the "move mode" message
    At(CalcX1 + 3,CalcY1 + 2,Space(24)); // erase the "move mode" message
    PopMouse();
    BuildMouseTargetList();
  }
}
