/* filename: TOGGLEDL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <browse.h>
#include <brwsvars.h>

void ToggleDelete(void)
{
  if(br_priv.Switch.NoDelete || br_priv.Switch.NoModify)
    SayNotPermitted(Deleted() ? Recalling_Records : Deleting_Records);
  else {
#ifdef NET
    if(!WorkArea[Selected]->Exclusive)
      if(!RLock()) {
        AnnounceLockFailure("Cannot lock record for deleting. Press any key...");
        return;
      }
#endif

    if(Deleted())
      RecallRec();
    else
      DeleteRec();

#ifdef NET
    if(!WorkArea[Selected]->Exclusive)
      Unlock();
#endif

    if(Deleted() && IgnoreDel)
      HandleDisplayAfterDelete();
    else
      DisplayRecordData();

    DisplayRecordNumber();
    br_priv.CellWasEdited = TRUE;
    LastKey = '\x15';
    DoUsersCalculations();
    br_priv.CellWasEdited = FALSE;
  }
}
