/* filename: STBWINTO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <browse.h>
#include <brwsvars.h>

void SetBrowseWindowTo(int lc, int tr, int rc, int br, int _LineStyle, char * _Header)
{
  unsigned char i;
  int tmp;

  if((br < tr + 4) || (lc == rc))
    return; // window is too small, just exit

  // set the header and linestyle
  strcpy(br_priv.BrowseBox.Header, _Header);
  br_priv.BrowseBox.LineStyle = _LineStyle;

  // browse is in dBASE coordinates, but the user has a choice of coordinate systems
  if(dBASEOrder) {
    tmp = lc; // reverse the order of coordinates
    lc  = tr;
    tr  = tmp;

    tmp = rc;
    rc  = br;
    br  = tmp;
  } else { // TOPAZ coordinates
    tr--;
    br--;
    rc--;
    lc--;
  }
  // have to allow 43/50 line screens
  tmp = (int) MaxAvailRows();
  if(br > tmp - 1)
    br = tmp - 1;
  if(rc > 79)
    rc = 79;

  br_priv.BrowseBox.c1 = lc;
  br_priv.BrowseBox.c2 = rc;
  br_priv.BrowseBox.r1 = tr;
  br_priv.BrowseBox.r2 = br;

  i = br_priv.BrowseBox.LineStyle & 0xF;
  if((i >= 1) && (i <= 5)) {
    // browse area needs to fit into the box that will be drawn
    tr++;
    br--;
    lc++;
    rc--;
  } else
    if(!*Trim(br_priv.BrowseBox.Header))
      tr++; // no line
  br_priv.FieldListRow = br_priv.MenuRow = tr;
  br_priv.TopRow       = br_priv.FieldListRow + 2;
  br_priv.StatusRow    = br_priv.ConversationRow = br;
  br_priv.BottomRow    = br_priv.StatusRow - 2;
  br_priv.FirstColumn  = lc;
  br_priv.LastColumn   = rc;
  br_priv.bScreenWidth = br_priv.LastColumn - br_priv.FirstColumn + 1;
  br_priv.BrowseRows   = br_priv.BottomRow - br_priv.TopRow + 1;
}
