/* filename: PARSECMD.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <utils.h>
#include <browse.h>
#include <brwsvars.h>

extern char _tzfar browse_str[STRSIZ];

static int CmdHas(char *s)
{
  return Pos(s, browse_str) >= 0;
}

void ParseCommand(char *CommandStr)
{
  int  i, i2, j, k;
  char Temp[STRSIZ], Temp2[STRSIZ];
  char NameOfField[STRSIZ];
  int  len;
  int  EditFlag;
  int  NewName;
  int  LeaveCaseAlone;
  int  Plain;
  DataDefinitionType DD;
  unsigned char StartingArea;

  strcpy(browse_str, CommandStr);
  // upper case everything except what is between quote marks
  LeaveCaseAlone = FALSE;
  len = strlen(browse_str);
  for(i = 0; i <= len; i++) {
    if(browse_str[i] == '\'')
      LeaveCaseAlone = !LeaveCaseAlone;
    if(!LeaveCaseAlone)
      browse_str[i] = toupper(browse_str[i]);
    else // replace all spaces between " " with 0x01 as a place keeper
      if(browse_str[i] == ' ')
        browse_str[i] = 0x1;
  }
  // Release any memory that may have been taken by the list of alias field names:
  ReleaseAliasMemory();
  if((br_priv.RootAlias = malloc(10)) == NULL) { // Restart the alias pointer chain
    SetError(InsufficientMemory, 1, "[Browse/ParseCommand]");
    return;
  }
  br_priv.RootAlias->NextAlias    = NULL;
  br_priv.RootAlias->ColumnNumber = 0;
  br_priv.RootAlias->AreaNumber   = 0;
  br_priv.RootAlias->fieldnumber  = 0;
  br_priv.RootAlias->FieldName[0] = 0;
  br_priv.FieldAliasPtr = br_priv.RootAlias;

  while(CmdHas("  ")) // remove all occurances of double spaces
    Delete(browse_str, Pos("  ", browse_str), 1);

  if((i = Pos("FIELDS [", browse_str)) >= 0)
    Delete(browse_str, i + 6, 1); // remove space before bracket

  if(CmdHas("FIELDS[")) {
    strcpy(Temp, browse_str); // examples:
    i = Pos("FIELDS[", Temp); // Temp= NODELETE FIELDS [ sadf sadf asdf ] NOMODIFY
    strcpy(Temp, Copy(Temp, i + 7, STRSIZ-1)); // Temp=  sadf safd asdf ] NOMODIFY
    if((i2 = Pos("]", Temp)) >= 0) {
      strcpy(Temp, Copy(Temp, 0, i2));   // Temp = safds asdf sadf
      Delete(browse_str, i, i2 - i + 8); // Command = NODELETE NOMODIFY
    } else
      Delete(browse_str, i, STRSIZ-1);
    // Temp is now a list of space- or comma-delimited fieldnames,
    // and the FIELDS command and [] chars have been removed from
    // the command line
    // Replace commas with spaces:
    while((i = Pos(",", Temp)) >= 0)
      Temp[i] = ' ';

    strcpy(Temp, Ltrim(Trim(Temp)));
    strcat(Temp, " ");

    while((i = Pos("  ", Temp)) >= 0)
      Delete(Temp, i, 1);

    while((i = Pos("\x1", Temp)) >= 0)
      Temp[i] = ' ';

    j = 0;
    while((i = Pos(" ",Temp)) >= 0) {
      strcpy(NameOfField, Copy(Temp, 0, i));
      if(*NameOfField == '-') { // determine if field can be edited
        Delete(NameOfField, 0, 1);
        EditFlag = FALSE;
      } else
        EditFlag = TRUE;
      i = FieldNo(NameOfField);
      if(i > 0) { // check that this field has not already been specified
        NewName = TRUE;
        for(k = 1; k <= j; k++)
          NewName = NewName && (br_priv.FMAP[k-1] != (unsigned char) i);
        if (NewName) {
          j++;
          br_priv.FMAP[j-1] = i;
          br_priv.EMAP[j-1] = EditFlag;
          br_priv.AMAP[j]   = CurrentArea();
          // has an alias (column name) been specified between double quote marks?
          strcpy(Temp2, Temp);
          Delete(Temp2, 0, Pos(" ", Temp2) + 1);
          if(*Temp2 == '\'') {
            Delete(Temp2, 0, 1);   //  Delete the first double quote
            if (Pos("\'", Temp2) >= 0) {
              strcpy(Temp2, Copy(Temp2, 0, Pos("\'", Temp2)));
              // Put the alias name on the heap
              if((br_priv.FieldAliasPtr->NextAlias = malloc(10 + strlen(Temp2))) == NULL) {
                SetError(InsufficientMemory, 1, "[Browse/ParseCommand]");
                return;
              }
              br_priv.FieldAliasPtr = br_priv.FieldAliasPtr->NextAlias;
              br_priv.FieldAliasPtr->NextAlias = NULL;
              br_priv.FieldAliasPtr->fieldnumber = br_priv.FMAP[j-1];
              br_priv.FieldAliasPtr->ColumnNumber = j;
              br_priv.FieldAliasPtr->AreaNumber = CurrentArea();
              strcpy(br_priv.FieldAliasPtr->FieldName, Temp2);
              // Delete the alias name from TEMP
              // up to and including first quote
              Delete(Temp, 0, Pos("\'", Temp) + 1);
              // up to and including second quote
              Delete(Temp, 0, Pos("\'", Temp) + 1);
            }
          }
        }
      }
      Delete(Temp, 0, Pos(" ", Temp) + 1);
    }
    br_priv.MaxFields = j;
  }

  if(WorkArea[Selected]->DataDef) { // get column info from data definition
    StartingArea = CurrentArea();
    DataDefinition = &DD;
    j = 1;
    do {
      memset(&DD, 0, sizeof(DD));
      DD.Column = j;
      Select(StartingArea); // always go back to the same work area!
      (*WorkArea[Selected]->DataDef)();
      // if the user has specified a field, but not an alias, fill in the alias now
      if(!*DD.DBFAlias && *DD.FieldName)
        strcpy(DD.DBFAlias, Alias());
      if((*DD.DBFAlias && *DD.FieldName) || *DD.VirtualField) {
        if(!*DD.VirtualField) {
          SelectAlias(DD.DBFAlias);
          br_priv.AMAP[j]   = CurrentArea();
          br_priv.FMAP[j-1] = (unsigned char) FieldNo(DD.FieldName);
          br_priv.EMAP[j-1] = !DD.NoEdit;
          br_priv.VMAP[j-1] = FALSE;
          if(!br_priv.FMAP[j-1]) {
            SetError(InvalidParameter, 2, Invalid_field_name_specified_in_DataDefinition_column, SInteger(j, 0));
            return;
          }
        } else {
          br_priv.AMAP[j]   = 0;
          br_priv.FMAP[j-1] = 0;
          br_priv.EMAP[j-1] = FALSE;
          br_priv.VMAP[j-1] = TRUE;
        }
        if((!*DD.VirtualField && *Trim(DD.Prompt)) || *DD.VirtualField) {
          // Put the alias name on the heap
          if((br_priv.FieldAliasPtr->NextAlias = malloc(10 + strlen(DD.Prompt))) == NULL) {
            SetError(InsufficientMemory, 1, "[Browse/ParseCommand]");
            return;
          }
          br_priv.FieldAliasPtr = br_priv.FieldAliasPtr->NextAlias;
          br_priv.FieldAliasPtr->NextAlias = NULL;
          br_priv.FieldAliasPtr->fieldnumber = br_priv.FMAP[j-1];
          br_priv.FieldAliasPtr->ColumnNumber = j;
          br_priv.FieldAliasPtr->AreaNumber = CurrentArea();
          strcpy(br_priv.FieldAliasPtr->FieldName, DD.Prompt);
        }
      }
      j++;
    } while((j <= MaxFieldCount) && (*DD.DBFAlias || *DD.FieldName || *DD.VirtualField));
    br_priv.MaxFields = (j > MaxFieldCount) ? MaxFieldCount : (j - 2);
  }
  br_priv.Switch.Freeze   = FALSE;
  br_priv.FreezeField     = 0;
  br_priv.Switch.NoModify = CmdHas("NOMODIFY");
  br_priv.Switch.NoAppend = CmdHas("NOAPPEND");
  br_priv.Switch.NoPack   = CmdHas("NOPACK");
  br_priv.Switch.NoDelete = CmdHas("NODELETE");
  br_priv.Switch.NoFollow = CmdHas("NOFOLLOW");
  br_priv.Switch.NoPrompt = CmdHas("NOPROMPT");
  br_priv.Switch.NoStatus = CmdHas("NOSTATUS");
  br_priv.Switch.NoMenu   = CmdHas("NOMENU");
  br_priv.Switch.Command  = CmdHas("COMMAND");
  br_priv.Switch.NoFunctionKeys = FALSE;
  Plain = CmdHas("PLAIN");
  if(Plain) {
    br_priv.Switch.NoMenu   = TRUE;
    br_priv.Switch.NoStatus = TRUE;
    br_priv.Switch.NoPrompt = TRUE;
    br_priv.Switch.NoModify = TRUE;
    br_priv.Switch.NoAppend = TRUE;
    br_priv.Switch.NoPack   = TRUE;
    br_priv.Switch.NoDelete = TRUE;
    br_priv.Switch.NoFunctionKeys = TRUE;
  }
  if(br_priv.Switch.NoModify) {
    br_priv.Switch.NoAppend = TRUE;
    br_priv.Switch.NoPack   = TRUE;
    br_priv.Switch.NoDelete = TRUE;
  }

  if(Plain || br_priv.Switch.NoStatus) {
    br_priv.BottomRow  = br_priv.ConversationRow; // move bottom row to conversation row
    br_priv.BrowseRows = br_priv.BottomRow - br_priv.TopRow + 1; // and recompute number of browse rows
  } else {
    br_priv.BottomRow = br_priv.StatusRow - 2;
    br_priv.BrowseRows = br_priv.BottomRow - br_priv.TopRow + 1; // and recompute number of browse rows
  }

  if(CmdHas("FREEZE ")) {
    strcpy(Temp, fBuildStr("%s ", browse_str));
    Delete(Temp, 0, Pos("FREEZE ", Temp) + 6);
    strcpy(Temp, Copy(Temp, 0, Pos(" ", Temp) - 1));
    br_priv.FreezeField = (unsigned char) FieldNo(Temp);
    br_priv.Switch.Freeze = br_priv.FreezeField > 0;
  }

  if(CmdHas("LOCK ")) {
    strcpy(Temp, Copy(browse_str, Pos("LOCK ", browse_str), STRSIZ-1));
    Delete(Temp, 0, 5);
    if (Pos(" ", Temp) >= 0)
      strcpy(Temp, Copy(Temp, 0, Pos(" ", Temp)));
    // what's left is the n parameter
    br_priv.LockNum = atoi(Temp);
    if((br_priv.LockNum < 0) || (br_priv.LockNum > FieldCount()))
      br_priv.LockNum = 0;
  } else
    br_priv.LockNum = 0;

  br_priv.FirstField = 0;

  if(CmdHas("FIRSTFIELD=")) {
    strcpy(Temp, Copy(browse_str, Pos("FIRSTFIELD=", browse_str), STRSIZ-1));
    Delete(Temp, 0, 11);
    if(Pos(" ",Temp) >= 0)
      strcpy(Temp, Copy(Temp, 0, Pos(" ", Temp) - 1));
    if(br_priv.FMAP[FieldNo(Temp)-1] > (unsigned char) br_priv.LockNum)
      br_priv.FirstField = br_priv.FMAP[FieldNo(Temp)-1];
  }
}
