/* filename: PANRIGHT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <browse.h>
#include <brwsvars.h>

void PanRight(DistanceType Distance) // this needs to deal with LOCK fields!
{
  int i, TotalWidth;
  int n;
  int width, sw;

  if(Distance == OneField)
    n = 1;
  else {
    if(br_priv.LastField == br_priv.MaxFields)
      return;
    width = 0;
    if(Distance == ScreensWorth) {
      n = br_priv.LastField;

      do {
        width += br_priv.ColumnWidth[n++];
      } while((width <= br_priv.bScreenWidth) || (n != br_priv.MaxFields));

      if(width > br_priv.bScreenWidth)
        n--;

      br_priv.FirstField   = br_priv.LastField + 1;
      br_priv.CurrentField = br_priv.FirstField;
      br_priv.LastField    = n;
    } else {        // Super pan
      n  = br_priv.MaxFields;
      sw = br_priv.bScreenWidth;
      if(br_priv.LockNum > 0)
        sw -= br_priv.Column[br_priv.LockNum];

      do {
        width += br_priv.ColumnWidth[--n];
      } while((width <= sw) && (n != 1));

      n++;
      if(width > sw)
        n++;

      br_priv.FirstField   = n;
      br_priv.CurrentField = br_priv.FirstField;
      br_priv.LastField    = br_priv.MaxFields;
    }
    PanPaintScreen();
    return;
  }

  br_priv.CurrentField += n;
  if(br_priv.CurrentField > br_priv.MaxFields)
    br_priv.CurrentField = br_priv.MaxFields;
  if(br_priv.CurrentField > br_priv.LastField) {
    br_priv.FirstField += n;
    if(br_priv.FirstField > br_priv.MaxFields)
      br_priv.FirstField = br_priv.MaxFields;
    // now that the first field is incremented, do we have sufficent width
    // on the screen to really increment the current field? The total width
    // is given by the sum of all the column widths plus n - 1 spaces
    TotalWidth = 0;

    for(i = br_priv.FirstField; i <= br_priv.CurrentField; i++)
      TotalWidth += br_priv.ColumnWidth[i-1] + 1;

    TotalWidth--;
    // if there is not enough room, decrement the current field
    if(!br_priv.LockNum) {
      if(TotalWidth > br_priv.bScreenWidth)
        br_priv.CurrentField -= n;
    } else {
      // handle locked fields
      if((int) (TotalWidth + br_priv.Column[br_priv.LockNum] - br_priv.FirstColumn) > br_priv.bScreenWidth)
        br_priv.CurrentField -= n;
    }
    PanPaintScreen();
  }
}
