/* filename: JOINLINE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <browse.h>
#include <brwsvars.h>

void JoinLines(unsigned char row, unsigned char col,
               unsigned char HLineStyle, unsigned char VLineStyle,
               OrientationType Orientation)
{
  char c[2] = { 0, 0 };
  BOOL RaisedFlag, RecessedFlag;

  RaisedFlag = ((Orientation == JLeft) || (Orientation == JRight) ||
               (Orientation == JBottom)) &&
               (VLineStyle & Raised) && (br_priv.Color.B != BLACK);
  RecessedFlag = ((Orientation == JLeft) || (Orientation == JRight) ||
                 (Orientation == JBottom)) &&
                 (VLineStyle & Recessed) && (br_priv.Color.B != BLACK);

  VLineStyle = VLineStyle & 0x0F; // remove any reference to shadow or explode
  HLineStyle = HLineStyle & 0x0F; // ditto

  if((VLineStyle == NoLine) || (VLineStyle == SolidLine))
    return;
  if((HLineStyle == NoLine) || (VLineStyle == SolidLine))
    return;
  if(col > br_priv.BrowseBox.c2)
    return;

  switch(Orientation) {
    case JTop:
    case JBottom:
      switch(HLineStyle) {
        case DoubleTopSingleSide:
          HLineStyle = DoubleLine;
          break;

        case SingleTopDoubleSide:
          HLineStyle = SingleLine;
          break;
      }
      break;

    case JLeft:
    case JRight:
      switch(VLineStyle) {
        case DoubleTopSingleSide:
          VLineStyle = SingleLine;
          break;

        case SingleTopDoubleSide:
          VLineStyle = DoubleLine;
          break;
      }
      break;
  }
  switch(Orientation) {
    case JTop:
      switch(VLineStyle) { // single vertical line to top horizontal line
        case SingleLine:
          switch(HLineStyle) {
            case SingleLine:
              *c = '\xC2';
              break;

            case DoubleLine:
              *c = '\xD1';
              break;
          }
          break;

        case DoubleLine:
          switch(HLineStyle) {
            case SingleLine:
              *c = '\xD2';
              break;

            case DoubleLine:
              *c = '\xCB';
              break;
          }
          break;
      }
      break;

    case JBottom:
      switch(VLineStyle) { // single vertical line to top horizontal line
        case SingleLine:
          switch(HLineStyle) {
            case SingleLine:
              *c = '\xC1';
              break;

            case DoubleLine:
              *c = '\xCF';
              break;
          }
          break;

        case DoubleLine:
          switch (HLineStyle) {
            case SingleLine:
              *c = '\xD0';
              break;

            case DoubleLine:
              *c = '\xCA';
              break;
          }
          break;
      }
      break;

    case JLeft:
      switch(VLineStyle) { // single vertical line to top horizontal line
        case SingleLine:
          switch(HLineStyle) {
            case SingleLine:
              *c = '\xC3';
              break;

            case DoubleLine:
              *c = '\xC6';
              break;
          }
          break;

        case DoubleLine:
          switch(HLineStyle) {
            case SingleLine:
              *c = '\xC7';
              break;

            case DoubleLine:
              *c = '\xCC';
              break;
          }
          break;
      }
      break;

    case JRight:
      switch(VLineStyle) { // single vertical line to top horizontal line
        case SingleLine:
          switch(HLineStyle) {
            case SingleLine:
              *c = '\xB4';
              break;

            case DoubleLine:
              *c = '\xB5';
              break;
          }
          break;

        case DoubleLine:
          switch(HLineStyle) {
            case SingleLine:
              *c = '\xB6';
              break;

            case DoubleLine:
              *c = '\xB9';
              break;
          }
          break;
      }
      break;
  }

  PushColors();

  if((RaisedFlag && (Orientation == JLeft)) ||
     (RecessedFlag && ((Orientation == JRight) || (Orientation == JBottom))))
    SetColorTo((unsigned char) (br_priv.Color.B + 8), br_priv.Color.B, 0, 0);
  else {
    if((RecessedFlag && (Orientation == JLeft)) ||
       (RaisedFlag && ((Orientation == JRight) ||
       (Orientation == JBottom))))
      SetColorTo(BLACK, br_priv.Color.B, 0, 0);
    else
      SetColorTo(br_priv.Color.F, br_priv.Color.B, 0, 0);
  }
  At(row, col, c);
  PopColors();
}
