/* filename: INITBRWS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <utils.h>
#include <browse.h>
#include <brwsvars.h>

struct tagButton {
  unsigned char c1;
  unsigned char c2;
};

void InitializeBrowse(char *Command)
{
  int SaveX, SaveY;
  struct tagButton QuitButton, MenuButton;
  unsigned char LeftPan, RightPan;
  unsigned char DividerRow;
  unsigned char r1, r2;
  unsigned char EndTriangleRow;
#ifdef _MSC_VER
  int y1, x1, y2, x2;
#else
  struct text_info tinfo;
#endif
  int i;

  br_priv.IndexIsOpen = IndexPresent ? (*IndexRoutines.IndexOpenFunc)() : 0;
  br_priv.MaxFields = 0;
  for(i = 0; i < MaxFieldCount; i++)
    br_priv.FMAP[i] = i + 1;
  memset(br_priv.EMAP, 1, sizeof(br_priv.EMAP));
  memset(br_priv.AMAP, CurrentArea(), sizeof(br_priv.AMAP));
  memset(br_priv.VMAP, 0, sizeof(br_priv.VMAP));
  memset(br_priv.RecNoList, 0, sizeof(br_priv.RecNoList));
  if((br_priv.MenuList = malloc(sizeof(MenuListArray))) == NULL) {
    SetError(InsufficientMemory, 1, "[Browse/InitializeBrowse]");
    return;
  }
  ParseCommand(Command);
#ifdef NET // Inhibit packing unless database is open exclusive
  if (!WorkArea[Selected]->Exclusive)
    br_priv.Switch.NoPack = TRUE;
#endif
  br_priv.firsttime = TRUE;
  // Draw main Browse box
  Box(br_priv.BrowseBox.r1, br_priv.BrowseBox.c1, br_priv.BrowseBox.r2, br_priv.BrowseBox.c2, br_priv.BrowseBox.LineStyle, br_priv.BrowseBox.Header);
  if(MouseDriverPresent && TopazMouseEnabled && br_priv.BrowseBox.LineStyle) {
    // draw the mouse buttons and define the mouse targets
    QuitButton.c1 = br_priv.BrowseBox.c1 + 1;
    QuitButton.c2 = QuitButton.c1 + strlen(_Quit) + 1;
    MenuButton.c1 = br_priv.BrowseBox.c2 - strlen(b_Menu) - 3;
    MenuButton.c2 = MenuButton.c1 + strlen(b_Menu) + 3;
    At(br_priv.BrowseBox.r1, QuitButton.c1, fBuildStr("[\xFE%s]", Trim(Copy(_Quit, 0, STRSIZ-1))));
    AddTarget(br_priv.BrowseBox.r1, QuitButton.c1, br_priv.BrowseBox.r1, QuitButton.c2, -1, LeftButtonReleased);
    if(!br_priv.Switch.NoMenu) {
      At(br_priv.BrowseBox.r1, MenuButton.c1, fBuildStr("[\xFE%s]", b_Menu));
      AddTarget(br_priv.BrowseBox.r1, MenuButton.c1, br_priv.BrowseBox.r1, MenuButton.c2, -2, LeftButtonReleased);
    }
    LeftPan = br_priv.BrowseBox.c1 + 1;
    RightPan = br_priv.BrowseBox.c2 - 11;
    // now add targets and display symbols for panning,
    // but only if there is enough room
    if (RightPan + 9 - LeftPan + 1 >= 21) {
      At(br_priv.BrowseBox.r2, LeftPan, "\x11\x11\x11");
      At(br_priv.BrowseBox.r2, LeftPan + 5, "\x11\x11");
      At(br_priv.BrowseBox.r2, LeftPan + 9, "\x11");
      At(br_priv.BrowseBox.r2, RightPan, "\x10");
      At(br_priv.BrowseBox.r2, RightPan + 3, "\x10\x10");
      At(br_priv.BrowseBox.r2, RightPan + 7, "\x10\x10\x10");
      AddTarget(br_priv.BrowseBox.r2, LeftPan, br_priv.BrowseBox.r2, LeftPan + 2, -3, LeftButtonReleased);
      AddTarget(br_priv.BrowseBox.r2, LeftPan + 5, br_priv.BrowseBox.r2, LeftPan + 6, -4, LeftButtonReleased);
      AddTarget(br_priv.BrowseBox.r2, LeftPan + 9, br_priv.BrowseBox.r2, LeftPan + 9, -5, LeftButtonReleased);
      AddTarget(br_priv.BrowseBox.r2, RightPan, br_priv.BrowseBox.r2, RightPan, -6, LeftButtonReleased);
      AddTarget(br_priv.BrowseBox.r2, RightPan + 3, br_priv.BrowseBox.r2, RightPan + 4,-7, LeftButtonReleased);
      AddTarget(br_priv.BrowseBox.r2, RightPan + 7, br_priv.BrowseBox.r2, RightPan + 9,-8, LeftButtonReleased);
    }
    // now add targets and display symbols for vertical scrolling,
    // but only if there is enough room
    EndTriangleRow = br_priv.BrowseBox.r2 - 3;
    if (br_priv.Switch.NoPrompt || br_priv.Switch.NoStatus)
      EndTriangleRow += 2;
    if (EndTriangleRow - (br_priv.BrowseBox.r1 + 3) + 1 >= 5) {
      At(br_priv.BrowseBox.r1 + 3, br_priv.BrowseBox.c2, "\x1E");
      AddTarget(br_priv.BrowseBox.r1 + 3, br_priv.BrowseBox.c2, br_priv.BrowseBox.r1 + 3, br_priv.BrowseBox.c2, -9, LeftButtonReleased);
      At(EndTriangleRow, br_priv.BrowseBox.c2, "\x1F");
      AddTarget(EndTriangleRow, br_priv.BrowseBox.c2, EndTriangleRow, br_priv.BrowseBox.c2, -10, LeftButtonReleased);
      r1 = br_priv.BrowseBox.r1 + 3;
      r2 = br_priv.BrowseBox.r2 - 3;
      if(br_priv.Switch.NoStatus)
        r2 += 2;
      DividerRow = (r1 + r2) >> 1;
      At(DividerRow, br_priv.BrowseBox.c2, "\xF7");
      for(i = br_priv.BrowseBox.r1 + 4; i < (int) DividerRow; i++)
        At(i, br_priv.BrowseBox.c2, "\xB0");
      AddTarget(br_priv.BrowseBox.r1 + 4, br_priv.BrowseBox.c2, DividerRow - 1, br_priv.BrowseBox.c2, -11, LeftButtonDown);
      for(i = DividerRow + 1; i < (int) EndTriangleRow; i++)
        At(i, br_priv.BrowseBox.c2, "\xB0");
      AddTarget(DividerRow + 1, br_priv.BrowseBox.c2, EndTriangleRow + 1, br_priv.BrowseBox.c2, -12, LeftButtonDown);
      AddTarget(r1, br_priv.BrowseBox.c1 + 1, r2, br_priv.BrowseBox.c2 - 1, -13, LeftButtonReleased);
    }
  }
  if(!br_priv.MaxFields)
    br_priv.MaxFields = FieldCount();
  GetColumns();
#ifdef _MSC_VER
  _gettextwindow(&y1, &x1, &y2, &x2);
  br_priv.OldWinLeft   = x1;
  br_priv.OldWinTop    = y1;
  br_priv.OldWinRight  = x2;
  br_priv.OldWinBottom = y2;
#else
  gettextinfo(&tinfo);
  br_priv.OldWinLeft   = tinfo.winleft;
  br_priv.OldWinTop    = tinfo.wintop;
  br_priv.OldWinRight  = tinfo.winright;
  br_priv.OldWinBottom = tinfo.winbottom;
#endif
  window(1, 1, 80, MaxAvailRows());
  if(br_priv.FirstField == 0) { // begin with field #1
    br_priv.CurrentField = 1;
    br_priv.FirstField = br_priv.LockNum + 1;
  } else
    br_priv.CurrentField = br_priv.FirstField;
  RedefineLRecNo();
  if(BrowseCursorOn)
    SetCursorOn();
  br_priv.AppendInProgress = FALSE;
  SaveX = wherex();
  SaveY = wherey();
  LastKey = 0;
  br_priv.CellWasEdited = FALSE;
  ExitBrowse = FALSE;
  br_priv.BrowseActive = TRUE;
  DoUsersCalculations();
  gotoxy(SaveX,SaveY);
  EnableMouse();
}
