/* filename: GETCLMNS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <browse.h>
#include <brwsvars.h>

void GetColumns(void)
{
  int width;
  int i;
  int NonLockedScreenWidth;

  // compute the relative column locations for each field:
  memset(br_priv.Column, 0, sizeof(br_priv.Column));
  br_priv.Column[0] = br_priv.FirstColumn; // things start in the first column. e.g. 0

  for(i = 0; i < br_priv.MaxFields; i++) {
    if(br_priv.VMAP[i])
      width = strlen(VirtualData(i+1));
    else {
      Select(br_priv.AMAP[i+1]);
      width = FieldLen(br_priv.FMAP[i]);
      if(FieldType(br_priv.FMAP[i]) == 'M') // shorten memo fields to 4 chars
        width = 4;
    }
    // compare width with the width of the field name
    if(strlen(_Field(i+1)) > (unsigned int) width)
      width = strlen(_Field(i+1));
    // never let the width exceed the screen or window width. If there are
    // locked fields, the width cannot exceed the amount of screen that
    // remains after the locked fields:
    if(width > br_priv.bScreenWidth)
      width = br_priv.bScreenWidth;

    if((br_priv.LockNum > 0) && (i > br_priv.LockNum)) {  // field is not locked
      NonLockedScreenWidth = br_priv.bScreenWidth - (br_priv.Column[br_priv.LockNum-1] + br_priv.ColumnWidth[br_priv.LockNum-1] - br_priv.FirstColumn + 1);
      if(width > NonLockedScreenWidth)
        width = NonLockedScreenWidth;
    }

    if(i < br_priv.MaxFields)
      br_priv.Column[i+1] = br_priv.Column[i] + width + 1;
    br_priv.ColumnWidth[i] = width;
    // return to the area we are working in
    Select(br_priv.AMAP[0]);
  }
}
