/* filename: EDITCELL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <utils.h>
#include <browse.h>
#include <brwsvars.h>

void EditCell(void)
// need to look at the NOFOLLOW flag. If we DO follow, then we need to repaint
// the screen whereever the new record is positioned in the index file. If
// NOFOLLOW, then we need to repaint the screen at the next record in index
// order.  This means that we need to know 1) if a primary index is open, and
// 2) whether the key changed
{
  char EmptyString[2] = "";
  char Stemp[STRSIZ];
  char SaveTemp[STRSIZ];
  char SaveKey[101];
  int  Ltemp;
  double Rtemp;
  long Itemp;
  long TopRecord;
  int  PositionChanged;
  long SavePriorRecNo, CurrentRecNo;
  int  r, c;
  DataDefinitionType DD;
  char *(*ptr)(void);

  if(br_priv.Switch.NoModify) {
    FlushKeyboard();
    return;
  }
  if(!br_priv.EMAP[br_priv.CurrentField-1]) {
    SayNotPermitted(Editing_this_field);
    return;
  }
  if(br_priv.Switch.Freeze && (br_priv.FMAP[br_priv.CurrentField-1] != br_priv.FreezeField)) {
    FlushKeyboard();
    return;
  }
  if(br_priv.VMAP[br_priv.CurrentField-1]) {
    // forbid editing fields in related dbfs, or on virtual fields
    SayNotPermitted(Editing_this_field);
    return;
  }

  // if a primary index is open, and we are permitted to edit,
  // then save the existing key and find out the record number
  // of the next record:
  if(br_priv.IndexIsOpen && (!br_priv.Switch.NoModify)) {
    ptr = (char * (*)(void))(*IndexRoutines.KeyMakerFunc)(0);
    strcpy(SaveKey, (*ptr)());
    TopRecord = br_priv.RecNoList[0];
    if((TopRecord == WorkArea[Selected]->Handle.CurRecNo) && br_priv.RecNoList[1])
      TopRecord = br_priv.RecNoList[1];
    // now save the record number of the prior and next records. we will
    // need these later to determine if the order of the record has changed
    // what is the prior record?
    CurrentRecNo = WorkArea[Selected]->Handle.CurRecNo;
    Skip(-1);
    if(dBOF()) {
      SavePriorRecNo = 0;
      Go(CurrentRecNo);
    } else {
      SavePriorRecNo = WorkArea[Selected]->Handle.CurRecNo;
      Skip(1);
    }
  }

#ifdef NET
  if(!WorkArea[Selected]->Exclusive)
    if(!RLock()) {
      AnnounceLockFailure("Cannot lock record for editing.  Press any key...");
      return;
    }
#endif

  strcpy(Stemp, SField(br_priv.FMAP[br_priv.CurrentField-1]));
  r = (int) (br_priv.LRecNo - br_priv.FirstRecord) + br_priv.TopRow;
  c = br_priv.Column[br_priv.CurrentField-1] - Offset();

  if(WorkArea[Selected]->DataDef != NULL) {
    DataDefinition = &DD;
    memset(&DD, 0, sizeof(DD));
    DD.Column = br_priv.CurrentField; // make sure i have this correct
    (*WorkArea[Selected]->DataDef)();
  }

  // next comes the SAYGET statement..preceed this with a PushMouse
  PushMouse();
  switch(FieldType(br_priv.FMAP[br_priv.CurrentField-1])) {

    case 'C':
      // next line is the old way...get rid of it when we have scrolling in sayget4
      // make a copy of Stemp, since we are editing a part that might be
      // smaller than Stemp
      strcpy(SaveTemp, Stemp);
      SayGet(r, c, "", Stemp, _S, (unsigned char) DataWidth(br_priv.CurrentField), 0);
      // now for the fun part: if there is a users data definition,
      // we want to use it to get a picture clause, validation pointers,
      // and the like:
      break;

    case 'D':
      SayGet(r, c, "", Stemp, _D, (unsigned char) DataWidth(br_priv.CurrentField), 0);
      break;

    case 'L':
      Ltemp = (*Stemp == SBoolean(1) ? TRUE : FALSE);
      SayGet(r, c, "", &Ltemp, _L, 1, 0);
      if(WorkArea[Selected]->DataDef && *Trim(DD.Picture))
        Picture(DD.Picture);
      break;

    case 'N':
    case 'F':
      if(!FieldDec(br_priv.FMAP[br_priv.CurrentField - 1])) {
        Itemp = LongVal(Stemp);
        SayGet(r, c, "", &Itemp, _LI, (unsigned char) DataWidth(br_priv.CurrentField), 0);
      } else {
        Rtemp = RealVal(Stemp);
        SayGet(r, c, "", &Rtemp, _DF, (unsigned char) DataWidth(br_priv.CurrentField), FieldDec(br_priv.FMAP[br_priv.CurrentField-1]));
      }
      break;

    case 'M': // memo field
      // call EditMemo directly here:
      if(EditMemoProc) {
        (*EditMemoProc)((long *) FieldAddress(br_priv.FMAP[br_priv.CurrentField-1]), EmptyString);
        if(*(long *) FieldAddress(br_priv.FMAP[br_priv.CurrentField-1]))
          strupr(Stemp);
        else
          strlwr(Stemp);
        At(r, c, Stemp);
      } else  {
        // don't GET the memo field, just say 'memo' or 'MEMO'
        At(r, c, Stemp);
        FlushKeyboard();
        LastKey = 0;
      }
      break;
  }

  if(br_priv.Key == 0x3C) // this is the F2 key
    Picture("@E"); // if F2 pressed, then position cursor at end of data in field

  if(WorkArea[Selected]->DataDef) {
    if(*Trim(DD.Picture))
      Picture(DD.Picture);

    if(*Trim(DD.LoRange) || *Trim(DD.HiRange))
      Range(DD.LoRange,DD.HiRange);

    if(DD.BlankField)
      BlankField();

    SetValidateTo(DD.ValidatePtr);
    SetAutoHelpTo(DD.AutoHelpPtr);
    if(DD.Required)
      Required();
  }

  ReadGets();
  PopMouse();

  if((FieldType(br_priv.FMAP[br_priv.CurrentField-1]) == 'C') && (strlen(Stemp) < strlen(SaveTemp)))
    // oops, the character string get truncated
    strcat(Stemp, Copy(SaveTemp, strlen(SaveTemp) - 1, STRSIZ-1));
/*
  when ReadGets exits, it paints the field back to the SAY color.
  Problem is, if the record is deleted, we need to paint with the
  delete color instead:

  if(Deleted())
    Paint((int)(br_priv.LRecNo - br_priv.FirstRecord) + br_priv.TopRow, br_priv.Column[br_priv.CurrentField-1], DataWidth(br_priv.CurrentField), br_priv.Color.DF, br_priv.Color.DB);
*/
  UnPaintCell();

  switch(FieldType(br_priv.FMAP[br_priv.CurrentField-1])) {

    case 'L':
      *(Stemp + 1) = 0;
      *Stemp = SBoolean(Ltemp);
      break;

    case 'N':
    case 'F':
      if(!FieldDec(br_priv.FMAP[br_priv.CurrentField - 1]))
        strcpy(Stemp, SInteger(Itemp, FieldLen(br_priv.FMAP[br_priv.CurrentField - 1])));
      else
        strcpy(Stemp, SReal(Rtemp, FieldLen(br_priv.FMAP[br_priv.CurrentField - 1]), FieldDec(br_priv.FMAP[br_priv.CurrentField - 1])));
      break;
  }

  if((FieldType(br_priv.FMAP[br_priv.CurrentField-1]) != 'M') ||
     ((FieldType(br_priv.FMAP[br_priv.CurrentField-1]) == 'M') && EditMemoProc)) {
    // rsm/mw allow editing foriegn fields
    Select(br_priv.AMAP[br_priv.CurrentField]);
    UpdateUserRec(br_priv.FMAP[br_priv.CurrentField-1], Stemp);
    Replace();
    Select(br_priv.AMAP[0]);
  }

#ifdef NET
  if(!WorkArea[Selected]->Exclusive)
    Unlock();
#endif

  // if an index is open, and editing is possible, and we want to FOLLOW the
  // record, then we need to know if the key has changed:
  if(IndexPresent)
    ptr = (char * (*)(void))(*IndexRoutines.KeyMakerFunc)(0);

  if(br_priv.IndexIsOpen && (!br_priv.Switch.NoModify) &&
     strcmp(SaveKey, (*ptr)())) {
    // key HAS changed.  But this does not necessarily mean the position in
    // the file has changed. We need to see if either the prior
    // record have changed as well.
    PositionChanged = FALSE;
    CurrentRecNo = WorkArea[Selected]->Handle.CurRecNo;
    Skip(-1);

    if(dBOF()) {
      if(SavePriorRecNo)
        PositionChanged = TRUE;
      Go(CurrentRecNo);
    } else {
      if(SavePriorRecNo != WorkArea[Selected]->Handle.CurRecNo)
        PositionChanged = TRUE;
      Skip(1);
    }

    if(PositionChanged) {
      // We need to repaint the screen. Decide which record to follow
      if(br_priv.Switch.NoFollow) {
        // repaint the same screen but with the edited record moved
        Go(TopRecord);
        RedefineLRecNo();
      } else
        FollowEditedRecord();
    }
  }

  if(br_priv.VirtualFieldsDisplayed)
    DisplayRecordData();

  // now let the user take over and make spreadsheet calculations, if they want
  br_priv.CellWasEdited = TRUE;
  DoUsersCalculations();
  br_priv.CellWasEdited = FALSE;

  // editing a cell kinda means that the user will want to proceed to the
  // next cell in the direction he leaves the edit:
  if(!strchr("ESXDM", LastKey + 0x40))
    LastKey = '\r';

  if(LastKey == '\r')
    switch((unsigned char) br_priv.EditDirection) {
        case 'R':
        LastKey = '\x04';
        break;

      case 'D':
        LastKey = '\x18';
        break;

      case 'S':
        LastKey = '\x0'; // do nothing
        break;
    }

  switch((unsigned char) LastKey) {
    case '\x05':
      Skip(-1);
      if(!dBOF()) {
        br_priv.LRecNo--;
        DisplayRecordNumber();
        if(br_priv.AppendInProgress) {
          br_priv.EditDirection = br_priv.SaveEditDirection;
          br_priv.AppendInProgress = FALSE;
        }
        // up arrow may mean we need to scroll down
        HandleScrollDown();
        // now let the user take over and make spreadsheet
        // calculations, if they want
        DoUsersCalculations();
      }
      LastKey = '\x0';
      break;

    case '\x18':
      Skip(1);
      if((!WorkArea[Selected]->Handle.EOFile)) {
        br_priv.LRecNo++;
        DisplayRecordNumber();
        if(br_priv.AppendInProgress) {
          br_priv.EditDirection = br_priv.SaveEditDirection;
          br_priv.AppendInProgress = FALSE;
        }
        // down arrow may mean we need to scroll up
        HandleScrollUp();
        // now let the user take over and make spreadsheet
        // calculations, if they want
        DoUsersCalculations();
      } else
        Skip(-1);
      LastKey = '\x0';
      break;

    case '\x13':
      PanLeft(OneField);
      break;

    case '\x04':
      PanRight(OneField);
      break;
  }
}
