/* filename: DOUSRCLC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <string.h>
#include <browse.h>
#include <brwsvars.h>

void DoUsersCalculations(void)
{
  unsigned char SaveArea;
  long          SaveRecNo, SaveRecCount;
  char          BeforeKey[101], AfterKey[101];
  int           BeforeDeleted;
  long          ReccountAfter;
  int           SaveIndexIsOpen;
  char         *(*ptr)(void);

  if(br_priv.UsersCalcProc) {
    if(!br_priv.OldDbaseOrder)
      dBASEOrder = FALSE;
    // save the RecNo, RecCount, and key (if an index is open):
    SaveArea = Selected;
    SaveRecNo = WorkArea[Selected]->Handle.CurRecNo;

    if(IndexPresent)
      br_priv.IndexIsOpen = (*IndexRoutines.IndexOpenFunc)();
    else
      br_priv.IndexIsOpen = FALSE;

    if(br_priv.IndexIsOpen) {
      ptr = (char * (*)(void))(*IndexRoutines.KeyMakerFunc)(0);
      strcpy(BeforeKey, (*ptr)());
    } else
      *BeforeKey = 0;

    BeforeDeleted = Deleted();
    EscapeEnabled = br_priv.OldEscape;
    SaveRecCount = RecCount();
    SaveIndexIsOpen = br_priv.IndexIsOpen;

    window(br_priv.OldWinLeft, br_priv.OldWinTop, br_priv.OldWinRight, br_priv.OldWinBottom);

    PushMouse();
    (*br_priv.UsersCalcProc)();
    PopMouse();

    window(1, 1, 80, MaxAvailRows());

    Selected = SaveArea;

    ReccountAfter = RecCount();
    EscapeEnabled = FALSE;

    if(!ReccountAfter || ExitBrowse) {
      ExitBrowse = TRUE;
      dBASEOrder = TRUE;
      return; // new way, just return
    }

    if(IndexPresent)
      br_priv.IndexIsOpen = (*IndexRoutines.IndexOpenFunc)();
    else
      br_priv.IndexIsOpen = FALSE;

    dBASEOrder = TRUE;
    br_priv.CellWasEdited = FALSE;   // reset the flag
    // if RecCount, RecNo, or the key has changed, we need to do
    // resync Browse:
    if(br_priv.IndexIsOpen && IndexRoutines.KeyMakerFunc) {
      ptr = (char * (*)(void))(*IndexRoutines.KeyMakerFunc)(0);
      strcpy(AfterKey, (*ptr)());
    } else
      *AfterKey = 0;

    if(BeforeDeleted != Deleted())
      DisplayRecordData();

    if((SaveRecNo != WorkArea[Selected]->Handle.CurRecNo) ||
       (SaveRecCount != ReccountAfter) ||
       strcmp(BeforeKey, AfterKey) ||
       (Deleted() && IgnoreDel)) {
      // something changed in the file, we need to repaint
      if(ReccountAfter < SaveRecCount)
        RedefineLRecNo();
      else {
        // reccount is not less than before
        if(WorkArea[Selected]->Handle.CurRecNo > ReccountAfter) {
          // file is beyond EOF, restore the prior position
          if(SaveRecNo <= ReccountAfter)
            Go(SaveRecNo);
          else
            GoTop();
          RedefineLRecNo();
        } else { // not eof
          // either the record number changed or the key changed,
          // or a record was added, or a record was deleted with
          // SET_DELETE_ON
          if(WorkArea[Selected]->Handle.CurRecNo - SaveRecCount == 1) {
            // a record was added
            SaveRecNo = WorkArea[Selected]->Handle.CurRecNo;
            Skip(-br_priv.BrowseRows + 1);
            RedefineLRecNo();
            while(WorkArea[Selected]->Handle.CurRecNo != SaveRecNo) {
              Skip(1);
              br_priv.LRecNo++;
            }
          } else {
            // record number changed or key changed or record was
            // deleted with SET_DELETE ON
            if(Deleted() & IgnoreDel)
              HandleDisplayAfterDelete();
            else
              FollowEditedRecord();
          }
        }
      }
    }
    if(SaveIndexIsOpen != br_priv.IndexIsOpen)
      DisplayHeadings();
    // check here for ExitBrowse flag..if the user sets it,
    // then we need to clean up and leave browse
    if(BrowseCursorOn)
      SetCursorOn();
  }
}
