/* filename: BRGETKEY.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <browse.h>
#include <brwsvars.h>

extern int  MouseNewField;
extern long MouseNewRecord;
extern long MouseNewLRecno;

int InSet(char *s, char c)
{
  int i;

  if((i = strlen(s)) == 0)
    return 0;

  return memchr(s, c, i) ? 1 : 0;
}

void BrowseGetKey(void)
{
  unsigned char ScanCode;
  ActivityType  SaveActivity;   //  for help system
  char          UmlautedChars[] = "";
  EventRec      e;
  char          Temp;

  SaveActivity = Activity;   //  help system
  Activity     = _Browse;
  while(!EventPending());
  Activity = SaveActivity;
  if (KeyPressed()) {
    // look at the keyboard buffer..do we have an editing key?
    ScanCode = NextScanCode;
    Temp = NextKey;
    // has a watch key been pressed? why wait for ReadGets to handle it?
    // intercept it now!
    // notice we look for character codes of 0 or $E0
    if(InSet(WatchKeys, Temp) ||
       ((!Temp || ((unsigned char)Temp == 0xE0)) &&
        InSet(WatchKeys, (char) (ScanCode + 128)))) {
      // this means we can pick up extended keyboard keys
      GetEvent(&e);
      LastKey = e.v.sKeyboard.Key;
      if(!InSet(WatchKeys, Temp))
        LastKey = e.v.sKeyboard.ScanCode + 128;
      // this makes BrowseEdit return false,
      // and Lastkey is the WatchKey
      br_priv.CellWasEdited = FALSE;
      DoUsersCalculations();
      LastKey = br_priv.Key = 0;
      return;
    }
    // has a BrowseExit key been pressed? we can just exit if that is the case
    if(InSet(BrowseExitKeys, Temp)) {
      br_priv.Key = Temp;
      br_priv.Key <<= 8; // Hi(Key) has the exit key
      FlushKeyboard();
      LastKey = Temp;
      return;
    }

    if(!Temp && InSet(BrowseExitKeys, (char)(ScanCode + 128))) {
      br_priv.Key = ScanCode + 128;
      br_priv.Key <<= 8;
      FlushKeyboard();
      LastKey = ScanCode + 128;
      return;
    }

    if(!Temp) {
      switch((unsigned int) ScanCode) {
        case 'R':
          Temp = 0x16; // Insert = ^V
          break;
        case 'S':
          Temp = 0x07; // Delete = ^G
          break;
        case 'w':
          if(!br_priv.VMAP[br_priv.CurrentField-1]) {  // Ctrl Home
            Select(br_priv.AMAP[br_priv.CurrentField]);
            if(FieldType(br_priv.FMAP[br_priv.CurrentField-1]) == 'M') {
              // if we are on a memo field,
              // control home is like F2
              br_priv.Key = (char)F2;
              Temp = ReadKey();
              Temp = ReadKey();
              return;
            }
            Select(br_priv.AMAP[0]);
          }
          break;
        case '\x0F':
          // shift tab is like a left arrow
          br_priv.Key = (int) 'K';
          Temp = ReadKey();
          Temp = ReadKey();
          return;
      }
    }

    // all control chars except ^U, ^X, ^M, ^I, ^V, ^G, and ^E will get us into edit
    if(!br_priv.VMAP[br_priv.CurrentField-1]) {
      Select(br_priv.AMAP[br_priv.CurrentField]);
      if(FieldType(br_priv.FMAP[br_priv.CurrentField-1]) != 'M')
        // not for memo fields
        // umlauted chars get us into edit, too
        if(((Temp >= ' ') && (Temp < '\x7F')) ||
           (((Temp >= '\x01') && (Temp <= '\x1A')) ||
           (Temp && strchr(UmlautedChars, Temp))) &&
           !(Temp && (strchr(BrowseExitKeys, Temp) ||
           strchr("UWEMIVG", Temp + 0x40)))) {

          // this leaves the keystroke in the buffer but we go into
          // SAYGET, the Pseudo nature of this means no @K picture
          // clause
          br_priv.Key = (unsigned char) bPseudoF2;
          Select(br_priv.AMAP[0]);
          return;
        }
      Select(br_priv.AMAP[0]);
    }
  }

  GetEvent(&e);
  switch(e.WhichEvent) {

    case Keyboard:
      Temp = e.v.sKeyboard.Key;
      if(Temp == '\x15') {
        br_priv.Key = (char) Temp;
        return;
      }
      if((Temp == '\r') && (!InSet(BrowseExitKeys, Temp)))
        // the Enter key will work like tab, if not an exit key
        Temp = '\t';
      if(Temp == '\t') { // tab is like a right arrow
        br_priv.Key = (int) 'M';
        return;
      }
      if(Temp == '\x05') { // ^E is like UpArrow
        br_priv.Key = (int) 'H';
        return;
      }
      if(Temp == '\x18') { // ^X is like DnArrow
        br_priv.Key = (int) 'P';
        return;
      }
      if((!br_priv.Switch.NoMenu) && (Temp == BrowseMenuKey)) {
        br_priv.Key = (char) F10;
        return;
      }
      if(Temp != '\x0') {
        br_priv.Key = (int) (Temp << 8);
        return;
      }
      br_priv.Key = e.v.sKeyboard.ScanCode;
      if((!br_priv.Switch.NoMenu) && (br_priv.Key == (unsigned int) (BrowseMenuKey - 128))) {
        br_priv.Key = (char) F10;
        return;
      }
      if(br_priv.Switch.NoFunctionKeys &&
         ((char) br_priv.Key >= ';') &&
         ((char) br_priv.Key <= 'D'))
        br_priv.Key = 0;
      break;

    case Mouse:
      if(ExitBrowse) {
        br_priv.Key = (0x1b << 8); // quit
        LastKey = '\x1B';
        return;
      }
      switch(e.v.sMouse.TargetID) {
        case -1:
          br_priv.Key = (0x1B << 8); // quit
          LastKey = '\x1B';
          break;
        case -2:
          br_priv.Key = (char) F10; // pop up menu
          break;
        case -3:
          br_priv.Key = (char) bCtrlHome; // pan left all the way
          break;
        case -4:
          br_priv.Key = (char) bCtrlLtArrow;
          break;
        case -5:
          br_priv.Key = (char) bLtArrow;
          break;
        case -6:
          br_priv.Key = (char) bRtArrow;
          break;
        case -7:
          br_priv.Key = (char) bCtrlRtArrow;
          break;
        case -8:
          // pan right all the way
          br_priv.Key = (char) bCtrlEnd;
          break;
        case -9:
          br_priv.Key = (char) bHome;
          break;
        case -10:
          br_priv.Key = (char) b_End;
          break;
        case -11:
          br_priv.Key = (char) bUpArrow;
          break;
        case -12:
          br_priv.Key = (char) bDnArrow;
          break;
        case -13:
          if(!e.v.sMouse.DoubleClick)
            br_priv.Key = (unsigned char) bGotoCell;
          else
            br_priv.Key = (unsigned char) bGotoCellThenEdit;
          MouseNewField  = FieldFromCol(e.v.sMouse.X);
          MouseNewRecord = RecordFromRow((unsigned char) (e.v.sMouse.Y - 1));
          break;
        default:
          FollowEditedRecord();
          LastKey = br_priv.Key = 0;
          break;
      }
      break;
  }
}
  
