/* filename: APPENDRC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <utils.h>
#include <browse.h>
#include <brwsvars.h>

void AppendRecord(void)
{
  int Confirm;
  int PanPaintSwitch;

  if(br_priv.Switch.NoAppend || br_priv.Switch.NoModify)
    SayNotPermitted(Appending_Records);
  else {
    if(br_priv.Switch.NoPrompt)
      Confirm = TRUE;
    else {
      Confirm = FALSE;
      SetColorTo(14, 0, 0, 7);
      SaveVideoLine();
      PushMouse();
      SayGet(br_priv.ConversationRow, br_priv.FirstColumn, Copy(Proceed_to_append_record, 0, br_priv.bScreenWidth - 1), &Confirm, _L, 1, 0);
      ReadGets();
      PopMouse();
      RestoreVideoLine();
      SetColorTo(br_priv.Color.F, br_priv.Color.B, br_priv.Color.HF, br_priv.Color.HB);
    }
    // There are two separate distinct situations when APPENDing.
    // if no index is active, then we want to visually place the appended
    // record at the bottom of the screen so that the record shows up
    // in its natural order. But, if an index is active, that is handled
    // differently.  The new, blank record needs to be displayed at the
    // top as it would be in its indexed order.
    if(Confirm) {
#ifdef NET
      if(!WorkArea[Selected]->Exclusive)
        if(!ALock()) {
          AnnounceLockFailure("Cannot lock file for appending. Press any key...");
          return;
        }
#endif
      ClearRecord();
      Append();
#ifdef NET
      if(!WorkArea[Selected]->Exclusive)
        Unlock();
#endif
      PanPaintSwitch = br_priv.FirstField > 1 ? TRUE : FALSE;
      br_priv.FirstField = 1;
      br_priv.CurrentField = 1;
      br_priv.firsttime = TRUE; // this will cause RedefineLRecNo to recompute LastField
      if(!br_priv.IndexIsOpen) {
        Skip(-br_priv.BrowseRows + 1);
        RedefineLRecNo();
        while(!WorkArea[Selected]->Handle.EOFile) {
          Skip(1);
          br_priv.LRecNo++;
        }
        Skip(-1);
        br_priv.LRecNo--;
      } else
        RedefineLRecNo();
      if(PanPaintSwitch)
        PanPaintScreen();
      br_priv.AppendInProgress = TRUE;
      br_priv.SaveEditDirection = br_priv.EditDirection;
      br_priv.EditDirection = 'R';
      EditCell();
    }
  }
}
