/* filename: TZMENU.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZMENU
#define _TZMENU
#define TZMENU

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#include <stdio.h>

#ifndef _TZCOMMON
#include <common.h>
#endif

#define TZSAYGET
#define TZVIDPOP

#include "rccomp.h"

#define HOTKEYSNO      129  // maximum target no

#define BORDERFG    1
#define BORDERBG    2
#define NORMALFG    3
#define NORMALBG    4
#define HILITEDFG   5
#define HILITEDBG   6
#define SELECTEDFG  7
#define SELECTEDBG  8
#define DISABLEDFG  9
#define DISABLEDBG 10
#define HELPFG     11
#define HELPBG     12
#define SHADOWFG   13
#define SHADOWBG   14
#define BORDER     15
#define NORMAL     16
#define HILITED    17
#define SELECTED   18
#define DISABLED   19
#define HELP       20
#define SHADOW     21

typedef struct
{
  int BorderFg;
  int BorderBg;
  int NormalFg;
  int NormalBg;
  int HiLitedFg;
  int HiLitedBg;
  int SelectedFg;
  int SelectedBg;
  int DisabledFg;
  int DisabledBg;
  int HelpFg;
  int HelpBg;
  int ShadowColorFg;
  int ShadowColorBg;
} MenuColors, *MenuColorsPtr;

typedef char *(*UDFPtr)(int); // pointer to a user defined function that takes
                              // a menu ID and that points to a string

////////////////////////////// Class MenuConst /////////////////////////////
class MenuConst
{
  public:
    MenuConst();
    ~MenuConst() {};
    virtual void Paint() {};    // pure virtual function
    virtual void UnPaint() {};  // pure virtual function

    static void SetLineStyle(unsigned LineStyle);
    static void SetColors(MenuColorsPtr colors);
    static void SetUDF(UDFPtr udf);
    static void SetCheckMark(unsigned char cm);
    static int  GetColor(int ID);
    static int  GetLineStyle() { return LineStyle; };
    static unsigned char GetCheckMark() { return CheckMark; };
    static void SetError(int errNo, const char *msg);

    BOOL  Visible;
    int   Row, Col;       // Item coordinates
    BOOL  WindowInStack;

    static void *Start;
    static void *Active;
    static int   TotalItemNo;
    static int   SelectedItem;
    static int   MenuRow, MenuCol, MenuWidth, MenuHeight;
    static int   hotkeys[HOTKEYSNO];
    static IdLinkType *IdLink;
    static int  IdLinkNo;
    static int  HelpRow;
    static char EmptyString[1];

  private:
    static MenuColors Colors;
    static int  LineStyle;
    static unsigned char CheckMark;
    static UDFPtr UDF;
};

inline void MenuConst::SetLineStyle(unsigned LStyle)
{
  LineStyle = LStyle;
}

inline void MenuConst::SetUDF(UDFPtr udf)
{
  UDF = udf;
}

inline void MenuConst::SetCheckMark(unsigned char cm)
{
  if (cm > 32)
    CheckMark = cm;
}

////////////////////////////// Class MenuItem //////////////////////////////

class MenuItem : public MenuConst
{
  public:
    MenuItem(PageType *type, MenuItem *parent, MenuItem *previous);
    ~MenuItem();
    virtual void RepaintItem() const;
    virtual void Paint();
    virtual void UnPaint(); // do nothing
    void SelectItem();
    void DeSelectItem();
    void EnableItem();
    void DisableItem();
    void CheckItem();
    void UnCheckItem();
    void SetItemCustomString(const char *init);
    BOOL IsChecked() const;
    BOOL IsEnabled() const;
    BOOL IsSelected() const;
    int  GetID() const;
    int  GetUserID() const;
    int  GetCustomStringLen() const;
    const char *GetName() const;
    const char *GetIDString() const;
    const char *GetCustomString() const;
    const char *GetHelp() const;

    const MenuItem *TopParent() const;
    MenuItem *ParentMenu;
    MenuItem *ChildMenu;
    MenuItem *PrevItem;
    MenuItem *NextItem;
    MenuItem *RememberLastSelected;

  private:
    BOOL Separator;       // just a single line separator between menu items
    int  ID;              // internal ID number

    char *Name;           // menu item name
    char *Help;           // help line
    char *IDString;       //
    char *CustomString;   //

    BOOL  Selected;       // currently highlighted?
    BOOL  Enabled;        // is the item enabled, or grayed out?
    BOOL  Checked;        // put a check mark next to the item?
    int   HotKeyOfs;      // offset to the character in the name that is the
                          // trigger key..if no hotkey then HotKeyOfs = -1
    int   UserID;         // what the menu system returns when a choice is made
    int   AcceleratorKey; // what accelerator key is associated with this item
    char *pool;
};

typedef MenuItem *PMenuItem;

inline int MenuItem::GetID() const
{
  return ID;
}

inline void MenuItem::CheckItem()
{
  Checked = TRUE;
}

inline void MenuItem::UnCheckItem()
{
  Checked = FALSE;
}

inline void MenuItem::EnableItem()
{
   Enabled = TRUE;
}

inline void MenuItem::DisableItem()
{
   Enabled = FALSE;
}

inline void MenuItem::SelectItem()
{
  Selected = TRUE;
}

inline void MenuItem::DeSelectItem()
{
  Selected = FALSE;
}

inline BOOL MenuItem::IsChecked() const
{
  return Checked;
}

inline BOOL MenuItem::IsEnabled() const
{
  return Enabled;
}

inline BOOL MenuItem::IsSelected() const
{
  return Selected;
}

inline const char *MenuItem::GetHelp() const
{
  return Help;
}

inline const char *MenuItem::GetName() const
{
  return Name;
}

inline const char *MenuItem::GetIDString() const
{
  return IDString;
}

inline const char *MenuItem::GetCustomString() const
{
  return CustomString;
}

inline int MenuItem::GetUserID() const
{
  return UserID;
}

/////////////////////////// Class MenuGroup ////////////////////////////////
////////////////////////////////////////////////////////////////////////////

class MenuGroup : private MenuItem
{
  public:
    MenuGroup(PageType *ptype, MenuItem *parent, MenuItem *previous);
    ~MenuGroup() {}; // destructor
    void Paint();
    void UnPaint();
    int  GetCursorWidth() const;
    void DisableMouse();

    int BTop,BLeft,BBottom,BRight; // Box coordinates
  private:
    int CursorWidth;               // menu cursor width
    int StartingItem;
};

inline int MenuGroup::GetCursorWidth() const
{
  return CursorWidth;
}

//////////////////////////////  tzMenu Class /////////////////////////////////

class tzMenu : private MenuConst
{
  public:
    tzMenu(const char *RCName, int width=0, int col=0, int row=0,
           const char *MenuName=NULL);
    ~tzMenu();
    void Paint();             // displays the menu
    void UnPaint();           // unpaints the menu
    int  GetChoice(int id=0); // processes the menu and returns a result

    void  Check(int id=0);     // set check mark to item with ID == id
    void  UnCheck(int id=0);
    BOOL  IsChecked(int id=0) const;
    void  Enable(int id=0);
    void  Disable(int id=0);
    BOOL  IsEnabled(int id=0) const;
    int   GetReturnID() const;
    const char *GetReturnIDString() const;
    const char *GetReturnName() const;
    void SetCustomString(const char *init, int id = 0);

    void SetLineStyle(unsigned LineStyle) { MenuConst::SetLineStyle(LineStyle); };
    void SetColors(MenuColorsPtr colors)  { MenuConst::SetColors(colors); };
    void SetUDF(UDFPtr udf)     { MenuConst::SetUDF(udf); };
    void SetCheckMark(unsigned char cm)  { MenuConst::SetCheckMark(cm); };
    int  GetColor(int ID) const { return MenuConst::GetColor(ID); };
    int  GetLineStyle() const   { return MenuConst::GetLineStyle(); };
    unsigned char GetCheckMark() const   { return MenuConst::GetCheckMark(); };

    void SetCallBack(BOOL (*udCB)(int id, const char *itmname, int key) = 0);
    void EnableQuitMenuByEscape();
    void DisableQuitMenuByEscape();

  private:
    FILE *CleanUpFile(FILE *in, char *s,
                      const char *outfname, const char *infname);
    void  SetMenuError(int ErrorNo, char *msg);
    void  Next();
    void  Prev();
    void  TranslateID(int *id) const;
    void  DeActivate();
    BOOL  Activate(int id, BOOL think = FALSE);
    BOOL (*CallBack)(int id, const char *itmname, int key);
    MenuItem  *Find(int id) const;
    MenuItem  *FindFirstEnabled(MenuItem *first) const;
    MenuItem  *TryToActivate(MenuItem *current, int select);
    MenuGroup *FirstMenuGroup;
    MenuItem  *CurrentItem;
    int  ErrorNo;
    int  saveX, saveY;
    int  saveCursorVisible;
    int  saveMousePlacement;
    BOOL QuitMenuByEscape;
};

inline void tzMenu::SetCallBack(BOOL (*udCB)(int id, const char *itmname, int key))
{
  CallBack = udCB;
}

inline void tzMenu::EnableQuitMenuByEscape()
{
  QuitMenuByEscape = TRUE;
}

inline void tzMenu::DisableQuitMenuByEscape()
{
  QuitMenuByEscape = FALSE;
}

inline const char *tzMenu::GetReturnName() const
{
  if (CurrentItem)
    return CurrentItem->GetName();
  else
    return "";
}

inline const char *tzMenu::GetReturnIDString() const
{
  if (CurrentItem)
    return CurrentItem->GetIDString();
  else
    return "";
}

inline int tzMenu::GetReturnID() const
{
  if (CurrentItem)
    return CurrentItem->GetUserID();
  else
    return -1;
}

int getKeyStroke(BOOL horizontal);

#endif // _TZMENU
