/* filename: TZMEM.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZMEM
#define _TZMEM
#define TZMEM

#ifndef _TZCOMMON
#include <common.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct MemHeader {
    char Name[11];
    unsigned TypeID;
    char Reserved1[3];
    char Len;
    char Reserved2[15];
} MemHeader; // 32 bytes in all

typedef struct LinkType {
   char    Name[11];
   char    Typ;
   char    Data[12];
   char   *StrPtr;
   struct LinkType *NextPtr;
} LinkType;

extern struct LinkType *MemPtr, *TempPtr;

void  AddMem(const char * Name, char Typ, void * memvar);
void  ClearMem(void);
void  DisplayMemory(void);
int   Mem(const char * name);
void* MemAddr(unsigned i);
int   MemCount(void);
char *MemName(unsigned i);
char  MemType(unsigned i);
void  RestoreFrom(const char * memFile);
void  SaveTo(const char* memFile);

#ifdef __cplusplus
}
#endif

#endif
