/* filename: SCRNEDIT.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZSCREEN
#define _TZSCREEN
#define TZSCREEN

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file. For more information please see TOPAZ USER'S GUIDE page 999.
#endif

#ifndef __STDIO_H
#include <stdio.h>
#endif

#ifndef TZCOMMON
#include <common.h>
#endif

#ifndef TZSAYGET
#include <sayget.h>
#endif

#ifndef TZDBF
#include <dbf.h>
#endif

#ifndef TZVIDPOP
#include <vidpop.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define BlankFieldMask 1
#define NoEditMask 2
#define RequiredMask 4
#define SayOrGetMask 8

typedef enum { AddMode,EditMode,DisplayMode } ScreenGetMode;

typedef struct GetList {
  struct GetList *NextGet;
	unsigned char Column;
	unsigned char Row;
	char DBFAlias[11];
	unsigned char FieldNum;
	char *FieldName;   //  to a String of up to [20]
	char *PictureClause;   //  to a String of up to [50]
	unsigned char intMask;   //  4 ints compressed
	unsigned char Foreground;
	unsigned char BackGround;
	unsigned char FieldLength;   //  User might want to show a field
	unsigned char FieldDecimals;   //  shorter than the full DBF field
	char *RangeLower;   //  to a string of up to [10]
	char *RangeUpper;   //  to a string of up to [10]
	VarTypes SayGetType;
} GetList;

typedef struct GetList *GetListPtr;

//  NOTE: The total size of the "pointed to strings" is 90 characters.
//  If this changes for some reason, then the coreleft() that checks for
//  sizeof(GetList)+90 needs to be modified appropriately.
typedef struct ScreenList {
  struct ScreenList *NextScreen;
	string10 ScreenName;
	GetListPtr ScreenGets;
} ScreenList;

typedef struct ScreenList *ScreenListPtr;

	/*  The InfoType is a record of all the vars that get Pushed and Popped !
	If you identify something in ScrnEdit that will get clobbered
	during a NESTED call to one of the screen edit routines, and should
	be preserved when the nested call returns, then it should be moved
	into the InfoType record.  NESTED calls happen when an AutoHelp or
	Validation routine happens to call another ScrnEdit routine during
	the ReadGets - typically, there isn't much that happens in this unit
	after a ReadGets is finished, so there isn't much that needs protecting.

	Remember, DoScreenGets is also used by the ScreenEdit procedure as
	well as called by the user.  Also candidates for inclusion in the
	Push and Pop, are any "environment" type things that can be set -
	like colors, or the user specified AutoHelp and Validate void *s.

	If you add something to this record, then you have to also add an
	initial value to the following CONST statement for the INFO typed
	constant, and add initialization in the PushScreenEdit routine.
	Typically, when these values are Pushed - the current "working"
	values are reset to their defaults. Don't forget to change the
	variable references to "Info.xxxxx" in the code.  */

typedef struct InfoType {
  struct InfoType *LastInfoRecord;
	ScreenListPtr CurrentScreen;
	int ScreenWasPresent;
  void (*UserHelpProc)(void);
  void (*UserValidateProc)(void);
} InfoType;

typedef struct InfoType *InfoPtr;

void ClearScreenGets(string10 ScreenName);
void CloseScreenGets(void);
void DoScreenGets(string10 ScreenName, ScreenGetMode ScreenMode,
				void (* UserCallBack)(void));
void LoadScreenGets(string10 ScreenName, void *  MemoryLoc,
        unsigned  char LibraryNo);
void PushScreenEdit(void);
void PopScreenEdit(void);
void ScreenEdit(string10 ScreenName, void *MemoryLoc, unsigned char LibraryNo,
        ScreenGetMode ScreenMode, void (* UserCallBack)(void));
unsigned char ScreenFieldCount(void);
void ScreenFieldNames(string10 * ThisDBF, string10 * ThisField);
unsigned char ScreenFieldNo(string10 ThisDBF, string10 ThisField);
void SetScreenHelpTo(void (* HelpProc)(void));
void SetScreenValidateTo(void (* ValidateProc)(void));

extern long ScrnEditMem;
extern long ScrnEditMax;

#ifdef __cplusplus
}
#endif

#endif
